/****************************************************************************/
/*!

  @file        SysView_MemoryAllocatorStatistics.cpp

  -------------------------------------------------------------------------

  @author      ElkeZ

  @ingroup     SystemViews
  @brief       This module implements the "MemoryAllocatorStatistics" view class.

  @see        

*/
/*-------------------------------------------------------------------------

  copyright:    (c) 2002-2004 SAP AG


    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "ggg00.h"
#include "SystemViews/SysView_Defines.hpp"
#include "SystemViews/SysView_ITableObj.hpp"
#include "SystemViews/SysView_MemoryAllocatorStatistics.hpp"
#include "RunTime/MemoryManagement/RTEMem_AllocatorInfoReader.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/



/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTIONS  (PROTOTYPES)                                     *
 *===========================================================================*/



/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

void SysView_MemoryAllocatorStatistics::Create()
{

	m_Table->AppendCol (ITOCT_CHAR,  SV_ALLOCATORNAME, 40);
	m_Table->AppendCol (ITOCT_FIXED, SV_USEDSIZE, 20);
	m_Table->AppendCol (ITOCT_FIXED, SV_MAXUSEDSIZE, 20);
	m_Table->AppendCol (ITOCT_FIXED, SV_ALLOCATEDSIZE, 20);
	m_Table->AppendCol (ITOCT_FIXED, SV_ALLOCATECOUNT, 20);
	m_Table->AppendCol (ITOCT_FIXED, SV_DEALLOCATECOUNT, 20);
	m_Table->AppendCol (ITOCT_FIXED, SV_FAILEDALLOCATECOUNT, 20);
	m_Table->AppendCol (ITOCT_FIXED, SV_FOUNDERRORCOUNT, 10);    
	m_Table->AppendCol (ITOCT_CHAR,  SV_BASEALLOCATORNAME, 40);
	m_Table->AppendCol (ITOCT_FIXED, SV_BASEALLOCATECOUNT, 20);
	m_Table->AppendCol (ITOCT_FIXED, SV_BASEDEALLOCATECOUNT, 20);
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_MemoryAllocatorStatistics::GetColCount()
{
	return SV_CC_MEMORYALLOCATORSTATISTICS;
}

/*---------------------------------------------------------------------------*/

SAPDB_Int SysView_MemoryAllocatorStatistics::EstimateRows()
{
	return SV_ER_MEMORYALLOCATORSTATISTICS;
}

/*---------------------------------------------------------------------------*/

void SysView_MemoryAllocatorStatistics::Execute()
{
    RTEMem_AllocatorInfoReader                  reader(m_Context.GetAllocator());
    RTEMem_AllocatorInfoItem                    *pInfo;

    m_Table->GetCatalogTable();

    if (m_Context.IsOk())
    {

        if (reader.First())
        {
            while (reader.Next (pInfo) )
            {
                m_Table->MoveToCol (ITOVT_CHARPTR, pInfo->siAllocatorName, strlen((SAPDB_Char *)pInfo->siAllocatorName));
                m_Table->MoveToCol (ITOVT_INT8, &pInfo->siUsedSize, 0);
                m_Table->MoveToCol (ITOVT_INT8, &pInfo->siMaxUsedSize, 0);
                m_Table->MoveToCol (ITOVT_INT8, &pInfo->siAllocatedSize, 0);
                m_Table->MoveToCol (ITOVT_INT8, &pInfo->siAllocateCount, 0);
                m_Table->MoveToCol (ITOVT_INT8, &pInfo->siDeallocateCount, 0);
                m_Table->MoveToCol (ITOVT_NULL, NULL, 0);
                m_Table->MoveToCol (ITOVT_NULL, NULL, 0);
                m_Table->MoveToCol (ITOVT_CHARPTR, pInfo->siBaseAllocatorName, (SAPDB_Int)strlen((SAPDB_Char *)pInfo->siBaseAllocatorName));
                m_Table->MoveToCol (ITOVT_INT8, &pInfo->siBaseAllocateCount, 0);
                m_Table->MoveToCol (ITOVT_INT8, &pInfo->siBaseDeallocateCount, 0);
            }
        }
    }
}

/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
