/****************************************************************************

  module      : Pager_Wrapper.cpp

  -------------------------------------------------------------------------

  responsible : Henrik

  special area: Pager_Wrapper
  description : 


  last changed: 2002-02-16
  see also    : 

  -------------------------------------------------------------------------

  copyright:    (c) 2001-2004 SAP AG

  ========== licence begin  GPL
  Copyright (c) 2001-2004 SAP AG

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
  ========== licence end

*****************************************************************************/



/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "Pager/Pager_Controller.hpp"
#include "RunTime/MemoryManagement/RTEMem_Allocator.hpp"


/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/


/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/



/*===========================================================================*
 *  LOCAL CLASSES, STRUCTURES, TYPES, UNIONS ...                             *
 *===========================================================================*/



/*===========================================================================*
 *  STATIC/INLINE FUNCTION PROTOTYPES                                        *
 *===========================================================================*/


/*===========================================================================*
 *  METHODS                                                                  *
 *===========================================================================*/

/* called from vak91 */
externC void bd999CreatePagerController() {

    SAPDBTRACE_ROUTINE_DEBUG("::EndSavepoint", Pager_Trace, 5 );

    Pager_Controller::GetInstance();
}

/* called from vak91 */
externC void bd999CreatePagerWriter(tgg00_TransContext &t){
    Pager_Writer  *instance;

    instance = new( RTEMem_Allocator::Instance() ) Pager_Writer(t);
    if (NULL == instance ){
        RTE_Crash(SAPDBErr_Exception(__FILE__, __LINE__, SAPDBERR_ASSERT_STATE_FAILED, "Pager_Wrapper::CreatePagerWriter() alloc failed"));
    }
    instance->Initialize();
}

/* called from vbd01 */
externC void bd999EnableDataWriter(){
    (Pager_Controller::GetInstance()).EnablePagerWriter();
}

/* called from vbd20 */
externC void bd999ResumeOneDataWriter(tsp00_TaskId TaskId,
                                      SAPDB_Int RegOffset) {

    (Pager_Controller::GetInstance()).FlushDataCacheRegion(TaskId, RegOffset);
}


/*===========================================================================*
 *  END OF CODE                                                              *
 *===========================================================================*/
