#ifndef __OMS_DEFINES_HPP
#define __OMS_DEFINES_HPP

/*===========================================================================*
*  INCLUDES                                                                 *
*===========================================================================*/
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <wchar.h>

/*===========================================================================*
*  DEFINES                                                                  *
*===========================================================================*/

#define OMS_DEFAULT_SCHEMA_HANDLE        1
#define OMS_MAX_SCHEMA_NAME_LENGTH      31

/*! Number of objects which are processed by a single mass-operation-call 
** to the kernel. 
*/
#define OMS_MASS_OPERATION_CNT          20


struct IliveCacheSink;

#if !defined(HPUX) && !defined(AIX) && !defined(LINUX)
#define OMS_PLACEMENT_DELETE
#endif

#define LIVECACHEOMS_VERSION     "LiveCache.h       7.2.2.0   DATE: 2000-01-27"
#define LIVECACHESQL_VERSION     "LiveCacheSQL.h    7.2.2.0   DATE: 2000-01-27"
#define ILIVECACHESINK_VERSION   "ILiveCacheSink.h  7.2.2.0   DATE: 2000-01-27"
#define LIVECACHETYPES_VERSION   "LiveCacheTypes.h  7.2.2.0   DATE: 2000-01-27"

#include "Oms/OMS_GUID.hpp"

&if $OS = WIN32
/* if std::string type is to be used as parameter for SQL, the following symbol
* has to be defined 

#define SQL_STD_STRING_SUPPORTED
*/
&endif

#ifndef GEO00_H
&if $MACH in [ _IBMR2 ] 
#if (__IBMCPP__ < 500)
typedef unsigned char bool;
#define     true    1
#define     false   0
#endif
&endif

&if $MACH in [ SUN ] 
#if !defined(_BOOL)
typedef unsigned char bool;
#define     true    ((const bool)1)
#define     false   ((const bool)0)
#endif
&endif

&if $MACH in [ _IBMR2 ] 
/*
* These keywords are not supported by the AIX compiler (C++ Standard of 1992 ...)
* If you are carefull, you are able to ignore them sometimes...
*/

// PTS 1106619
#if (__IBMCPP__ < 500)
#define explicit
#define mutable
#define typename
#define CONST_CAST(TYPE_,EXPR_) ((TYPE_)(EXPR_))
#define REINTERPRET_CAST(TYPE_,EXPR_) ((TYPE_)(EXPR_))
#define STATIC_CAST(TYPE_,EXPR_) ((TYPE_)(EXPR_))
#else
#define CONST_CAST(TYPE_,EXPR_) const_cast< TYPE_ >(EXPR_)
#define REINTERPRET_CAST(TYPE_,EXPR_) reinterpret_cast< TYPE_ >(EXPR_)
#define STATIC_CAST(TYPE_,EXPR_) static_cast< TYPE_ >(EXPR_)
#endif

&else

#define CONST_CAST(TYPE_,EXPR_) const_cast< TYPE_ >(EXPR_)
#define REINTERPRET_CAST(TYPE_,EXPR_) reinterpret_cast< TYPE_ >(EXPR_)
#define STATIC_CAST(TYPE_,EXPR_) static_cast< TYPE_ >(EXPR_)

&endif

#endif  /* ifndef GEO00_H */

#include "Oms/OMS_AFX.h"

&if $OS = WIN32
#pragma warning(disable:4103)
#ifdef _AFXDLL
#pragma warning(disable: 4251)  // using non-exported as public in exported
#endif

#include <oaidl.h>
&else

#define MAX_PATH          260
#define MIDL_INTERFACE(x) struct

#ifdef __cplusplus
#define EXTERN_C    extern "C"
#else
#define EXTERN_C    extern
#endif

#define _MAX_PATH   256 /* max. length of full pathname */
#define __stdcall
#define DECLSPEC_UUID(x)   
typedef long long hyper;
#define __RPC_USER 
#define __RPC_STUB 
#define __cdecl

&if $BIT64
typedef int                 HRESULT;
&else
typedef long                HRESULT;
&endif

#define STDMETHODCALLTYPE       __stdcall
#define STDMETHOD(method)       virtual HRESULT STDMETHODCALLTYPE method
#define STDMETHOD_(type,method) virtual type STDMETHODCALLTYPE method
#define STDMETHODIMP            HRESULT STDMETHODCALLTYPE
#define STDMETHODIMP_(type)     type STDMETHODCALLTYPE
#define STDAPICALLTYPE          __stdcall
#define STDAPI                  EXTERN_C HRESULT STDAPICALLTYPE
#define STDAPI_(type)           EXTERN_C type STDAPICALLTYPE
#define WINAPI                  __stdcall

#define __RPC_FAR
#define FAR
#define BEGIN_INTERFACE
#define END_INTERFACE

#define DECLARE_HANDLE(name) typedef HANDLE name
#define _ASSERT(expr) ((void)0)
#define _ASSERTE(expr) ((void)0)

#define _CrtCheckMemory() ;
#define _CrtIsValidPointer(p, n, r)         ((int)1)

/*===========================================================================*
*  MACROS                                                                   *
*===========================================================================*/

/*===========================================================================*
*  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
*===========================================================================*/

#define CONST               const
typedef int                 INT;
typedef unsigned int        UINT;
typedef int                 *PINT;
typedef int                 *LPINT;
typedef unsigned int        *PUINT;
#ifndef _CHAR
#define _CHAR
typedef char                CHAR;
#endif
typedef CHAR                *PCHAR;
typedef CHAR                *LPCH, *PCH;
typedef char                *PSZ;
#ifndef _UCHAR
#define _UCHAR
typedef unsigned char       UCHAR;
#endif
typedef UCHAR               *PUCHAR;
typedef unsigned char       BYTE;
typedef BYTE                *PBYTE;
typedef BYTE                *LPBYTE;
typedef BYTE                BOOLEAN;           
typedef int                 BOOL;
typedef BOOL                *PBOOL;
typedef BOOL                *LPBOOL;
typedef unsigned char       boolean;
typedef unsigned short      WORD;
typedef WORD                *PWORD;
typedef WORD                *LPWORD;
typedef unsigned long       DWORD;
typedef DWORD               *LPDWORD;
typedef short               SHORT;
typedef long                LONG;
typedef long                *LPLONG;
typedef void                VOID;
typedef void                *LPVOID;
typedef void                *PVOID;    
typedef unsigned long       ULONG;
typedef ULONG               *PULONG;
typedef unsigned short      USHORT;
typedef USHORT              *PUSHORT;
typedef float               FLOAT;
typedef float               FLOAT;
typedef FLOAT               *PFLOAT;
#ifndef __HANDLE_T__
#define __HANDLE_T__ __HANDLE_T__
typedef PVOID               HANDLE;
#endif
typedef void                *RPC_IF_HANDLE;
typedef void                IRpcStubBuffer;
typedef void                IRpcChannelBuffer;
typedef void                RPC_MESSAGE;
typedef void*               PRPC_MESSAGE;
DECLARE_HANDLE(HINSTANCE);
DECLARE_HANDLE(HKEY);
typedef HINSTANCE           HMODULE;      
typedef CHAR                *LPSTR, *PSTR;
typedef wchar_t             WCHAR;        // wc,   16-bit UNICODE character
typedef WCHAR               *LPWSTR, *PWSTR;
typedef LPWSTR              PTSTR, LPTSTR;
typedef WCHAR				        OLECHAR;
typedef OLECHAR				      *BSTR;
typedef BSTR				        *LPBSTR;
typedef CONST CHAR          *LPCSTR, *PCSTR;
typedef OLECHAR             *LPOLESTR;
#if !defined (_WIN64)
typedef int               HFILE;  // Old style, no longer supported!!!
#endif

#define __IID_DEFINED__     /* needed for MIDL generated Code */
#define IID_NULL            GUID_NULL
#define IsEqualIID(riid1, riid2) IsEqualGUID(riid1, riid2)
#define CLSID_NULL          GUID_NULL
#define IsEqualCLSID(rclsid1, rclsid2) IsEqualGUID(rclsid1, rclsid2)
#define FMTID_NULL          GUID_NULL
#define IsEqualFMTID(rfmtid1, rfmtid2) IsEqualGUID(rfmtid1, rfmtid2)


typedef struct _GUID {          // size is 16
&if $BIT64
  unsigned int  Data1;
&else
  DWORD         Data1;
&endif
  WORD          Data2;
  WORD          Data3;
  BYTE          Data4[8];
} GUID;

typedef GUID                IID;
typedef IID                 *LPIID;
typedef GUID                CLSID;
typedef CLSID               *LPCLSID;
typedef GUID                *LPGUID;

#ifdef __cplusplus
#define REFGUID             const GUID &
#define REFCLSID            const CLSID &
#define REFIID              const IID &

inline BOOL IsEqualGUID(REFGUID rguid1, REFGUID rguid2) {
  return !memcmp(&rguid1, &rguid2, sizeof(GUID));
}
inline BOOL operator==(const GUID& guidOne, const GUID& guidOther)
{
  return IsEqualGUID(guidOne,guidOther);
}

inline BOOL operator!=(const GUID& guidOne, const GUID& guidOther)
{
  return !(guidOne == guidOther);
}
#else   //  ! __cplusplus
#define IsEqualGUID(rguid1, rguid2) (!memcmp(rguid1, rguid2, sizeof(GUID)))
#endif  //  __cplusplus


#ifdef __cplusplus
extern "C"{
#endif 

  /* Forward Declarations */ 
  typedef struct IUnknown IUnknown;
  typedef struct IClassFactory IClassFactory;

  void *MIDL_user_allocate(size_t);
  void MIDL_user_free( void * ); 

  extern RPC_IF_HANDLE __MIDL__intf_0000_v0_0_c_ifspec;
  extern RPC_IF_HANDLE __MIDL__intf_0000_v0_0_s_ifspec;

  typedef /* [unique] */ IUnknown *LPUNKNOWN;

  //////////////////////////////////////////////////////////////////
  // IID_IUnknown and all other system IIDs are provided in UUID.LIB
  // Link that library in with your proxies, clients and servers
  //////////////////////////////////////////////////////////////////

#if defined(INITGUID)
  /* IID's, normally defined within UUID.LIB */
  EXTERN_C const IID IID_IUnknown = {0x00000000,0x0000,0x0000,
  {0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46}};
  EXTERN_C const IID GUID_NULL = {0x00000000,0x0000,0x0000,
  {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}};
#else
  EXTERN_C const IID IID_IUnknown;
  EXTERN_C const IID GUID_NULL;
#endif

#if defined(__cplusplus) && !defined(CINTERFACE)

  struct IUnknown {
public:
  BEGIN_INTERFACE
    virtual HRESULT STDMETHODCALLTYPE QueryInterface( 
    /* [in] */ REFIID riid,
    /* [iid_is][out] */ void  **ppvObject) = 0;
    virtual ULONG STDMETHODCALLTYPE AddRef( void) = 0;
    virtual ULONG STDMETHODCALLTYPE Release( void) = 0;
  END_INTERFACE
  };

#else 	/* C style interface */

  typedef struct IUnknownVtbl {
    BEGIN_INTERFACE
      HRESULT ( STDMETHODCALLTYPE *QueryInterface )( 
      IUnknown  *This,
      /* [in] */ REFIID riid,
      /* [iid_is][out] */ void  **ppvObject);
      ULONG ( STDMETHODCALLTYPE *AddRef )( 
      IUnknown *This);
      ULONG ( STDMETHODCALLTYPE *Release )( 
        IUnknown *This);
    END_INTERFACE
  } IUnknownVtbl;

&if $OS = WIN32
  interface IUnknown {
&else
  struct IUnknown {
&endif
    CONST_VTBL struct IUnknownVtbl *lpVtbl;
  };
#endif

  typedef /* [unique] */ IClassFactory *LPCLASSFACTORY;

#if defined(INITGUID)
  /* IID's, normally defined within UUID.LIB */
  EXTERN_C const IID IID_IClassFactory = {0x00000001,0x0000,0x0000,
  {0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x46}};
#else
  EXTERN_C const IID IID_IClassFactory;
#endif

#if defined(__cplusplus) && !defined(CINTERFACE)

  struct IClassFactory : public IUnknown
  {
  public:
    virtual /* [local] */ HRESULT STDMETHODCALLTYPE CreateInstance( 
      /* [unique][in] */ IUnknown *pUnkOuter,
      /* [in] */ REFIID riid,
      /* [iid_is][out] */ void **ppvObject) = 0;

      virtual /* [local] */ HRESULT STDMETHODCALLTYPE LockServer( 
      /* [in] */ BOOL fLock) = 0;
  };

#else 	/* C style interface */

  typedef struct IClassFactoryVtbl
  {
    BEGIN_INTERFACE

      HRESULT ( STDMETHODCALLTYPE *QueryInterface )( 
      IClassFactory *This,
      /* [in] */ REFIID riid,
      /* [iid_is][out] */ void **ppvObject);

      ULONG ( STDMETHODCALLTYPE *AddRef )( 
      IClassFactory *This);

      ULONG ( STDMETHODCALLTYPE  *Release )( 
        IClassFactory *This);

      /* [local] */ HRESULT ( STDMETHODCALLTYPE *CreateInstance )( 
      IClassFactory *This,
        /* [unique][in] */ IUnknown *pUnkOuter,
        /* [in] */ REFIID riid,
        /* [iid_is][out] */ void  **ppvObject);

        /* [local] */ HRESULT ( STDMETHODCALLTYPE *LockServer )( 
        IClassFactory *This,
        /* [in] */ BOOL fLock);

    END_INTERFACE
  } IClassFactoryVtbl;

  struct IClassFactory
  {
    CONST_VTBL struct IClassFactoryVtbl *lpVtbl;
  };

#endif 	/* C style interface */

#ifdef __cplusplus
}
#endif

#ifndef INITGUID
#define DEFINE_GUID(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8) \
  EXTERN_C const GUID name
#else
#define DEFINE_GUID(name, l, w1, w2, b1, b2, b3, b4, b5, b6, b7, b8) \
  EXTERN_C const GUID name \
  = { l, w1, w2, { b1, b2,  b3,  b4,  b5,  b6,  b7,  b8 } }
#endif // INITGUID

#define HKEY_CLASSES_ROOT					   (( HKEY ) 0x80000000 )

&if $BIT64
#define MAKE_HRESULT(sev,fac,code) \
  ((HRESULT) (((unsigned int)(sev)<<31) | ((unsigned int)(fac)<<16) | ((unsigned int)(code))) )
&else
#define MAKE_HRESULT(sev,fac,code) \
  ((HRESULT) (((unsigned long)(sev)<<31) | ((unsigned long)(fac)<<16) | ((unsigned long)(code))) )
&endif
#define FAILED(Status)                         ((HRESULT)(Status)<0)
#define SUCCEEDED(Status)                      ((HRESULT)(Status)>=0)
#define ResultFromScode(sc)                    ((HRESULT) (sc))
#define _HRESULT_TYPEDEF_(_sc)                 ((HRESULT)_sc)
#define S_OK                                   ((HRESULT)0x00000000L)
#define S_FALSE                                ((HRESULT)0x00000001L)
#if !defined (NO_ERROR)
#define NO_ERROR						             0L                                                 
#endif   
#define NOERROR                          0L                       
#define ERROR_SUCCESS                    0L
#define ERROR_FILE_NOT_FOUND             2L
#define ERROR_NOT_ENOUGH_MEMORY          8L    
#define ERROR_INVALID_PARAMETER          87L    
#define E_NOINTERFACE                    _HRESULT_TYPEDEF_(0x80004002L)
#define CLASS_E_NOAGGREGATION            _HRESULT_TYPEDEF_(0x80040110L)
#define CLASS_E_CLASSNOTAVAILABLE        _HRESULT_TYPEDEF_(0x80040111L)
#define REGDB_E_CLASSNOTREG              _HRESULT_TYPEDEF_(0x80040154L)
#define CO_E_CLASSSTRING                 _HRESULT_TYPEDEF_(0x800401F3L)
#define E_OUTOFMEMORY                    _HRESULT_TYPEDEF_(0x8007000EL)

#define DLL_PROCESS_ATTACH 1    
#define DLL_THREAD_ATTACH  2    
#define DLL_THREAD_DETACH  3    
#define DLL_PROCESS_DETACH              0    

#if !defined(FALSE)
#define FALSE               0
#define TRUE                1
#endif

typedef enum tagCLSCTX {	
  CLSCTX_INPROC_SERVER	= 0x1,
  CLSCTX_INPROC_HANDLER	= 0x2,
  CLSCTX_LOCAL_SERVER	= 0x4,
  CLSCTX_INPROC_SERVER16	= 0x8,
  CLSCTX_REMOTE_SERVER	= 0x10,
  CLSCTX_INPROC_HANDLER16	= 0x20,
  CLSCTX_INPROC_SERVERX86	= 0x40,
  CLSCTX_INPROC_HANDLERX86	= 0x80
}	CLSCTX;

//DECLSPEC_IMPORT 
EXTERN_C VOID WINAPI DebugBreak( void );

EXTERN_C LONG STDAPICALLTYPE InterlockedIncrement( LPLONG lpAddend );
EXTERN_C LONG STDAPICALLTYPE InterlockedDecrement( LPLONG lpAddend );

EXTERN_C DECLSPEC_IMPORT DWORD WINAPI GetModuleFileNameA(
  HMODULE hModule,
  LPSTR lpFilename,
  DWORD nSize
  );
EXTERN_C DECLSPEC_IMPORT DWORD WINAPI GetModuleFileNameW(
  HMODULE hModule,
  LPWSTR lpFilename,
  DWORD nSize
  );
EXTERN_C DECLSPEC_IMPORT DWORD WINAPI GetLastError(
  void
  );
EXTERN_C DECLSPEC_IMPORT HMODULE WINAPI LoadLibraryA(
  LPCSTR lpLibFileName
  );
typedef int (WINAPI *PROC)();
EXTERN_C DECLSPEC_IMPORT PROC WINAPI GetProcAddress(
  HMODULE hModule,
  LPCSTR lpProcName
  );
EXTERN_C DECLSPEC_IMPORT BOOL WINAPI FreeLibrary(
  HMODULE hLibModule
  );

#ifdef UNICODE
#define GetModuleFileName  GetModuleFileNameW
#else
#define GetModuleFileName  GetModuleFileNameA
#endif 

&endif 

// Assertions : compile with option /-D_ASSERT_OMS

#ifdef _ASSERT_OMS
#define _OMSASSERT(session,expr) if (!(expr)) { session->ThrowDBError(-28999, #expr, __MY_FILE__, __LINE__);}
#else
#define _OMSASSERT(h,expr) 
#endif

#if defined(OMSTST)
#define OMS_CHECK_EXCEPTION(HANDLE) { (HANDLE).m_pSession->CheckCancelCountDown();\
  (HANDLE).m_pSession->CheckExceptionCountDown(); }
#else
#define OMS_CHECK_EXCEPTION(HANDLE)
#endif

#ifndef _DEBUG

/****************************************************************************
*
* Debug OFF
* Debug OFF
* Debug OFF
*
***************************************************************************/

#define _TRACE_METHOD_ENTRY(h,methodname)
#define _TRACE_OID(h,oid)
#else

/****************************************************************************
*
* Debug ON
* Debug ON
* Debug ON
*
***************************************************************************/

#define _TRACE_METHOD_ENTRY(h,methodname) (h)->omsTracef(methodname);

#define _TRACE_OID(h,oid) (h)->omsTraceOid(oid);

#endif

#define MEMBER_OFFSET(T,M) (((char*) &((T*) 0)->M) - (char*) 0)


/*===========================================================================*
*  Defines for Synchronization                                               *
*============================================================================*/

#define OMS_VDIR_SIZE         17  /* PTS 1124533; must match definition in vgg08 */
#define OMS_VDIR_RW_START_CNT 1   /* PTS 1124533 */
#define OMS_VDIR_CS_START_CNT 7   /* PTS 1124533; must match offset in vgg08 */

enum {
  RGN_VDIR_STRIPED    = 6+OMS_VDIR_SIZE,   /* PTS 1124533 */
  RGN_EMERGENCY_CHUNK = 6,
  RGN_STACK_HEAP      = 5,
  RGN_SHARED_HEAP     = 4,
  RGN_VERSION_DIR     = 3,   /* PTS 1124533: used to synchonize the access to the global iterator (Glob_co10.VersionIter) */
  RGN_CLASS_DIR       = 2,
  RGN_UNLOAD_VERSION  = 1,
  RGN_MONITOR         = 0
};

/* If the following define is changed, the define OMS_SYS_REGION in geo38.h,
** the define OMS_SYS_RGNS in vgg08, and the computation of _OMS_RGNS in
** cserv.pcf must be adapted
*/
#define OMS_INTERNAL_CRITICAL_SECTIONS (7+OMS_VDIR_SIZE) /* PTS 1124533 */

enum OMS_LockMode{ OMS_NO_LOCK, OMS_LOCK_SHARED, OMS_LOCK_EXCLUSIVE }; /* PTS 1124533 */

#endif  /* __OMS_DEFINES_HPP */
