#include "Oms/OMS_CriticalSection.hpp"
#include "Oms/OMS_Session.hpp"
#include "Oms/OMS_Handle.hpp"
#include "Oms/OMS_ObjectContainer.hpp"

/*----------------------------------------------------------------------*/
/* Implementation of class OmsCriticalSection                           */
/*----------------------------------------------------------------------*/

OmsCriticalSection::OmsCriticalSection(OmsHandle* h, int regionId) 
  : m_session(h->m_pSession), m_inSection(false), 
    m_regionId(regionId + OMS_INTERNAL_CRITICAL_SECTIONS)
{
  if ((regionId < 0) || !(m_regionId < OMS_Globals::KernelInterfaceInstance->GetOmsRegionCnt())) // PTS 1112197
  {
    h->dbpOpError("OmsCriticalSection : invalid regionId %d", regionId); 
    m_session->ThrowDBError (e_invalid_csid, "OmsCriticalSection", __MY_FILE__, __LINE__);
  }
}

/*----------------------------------------------------------------------*/

void OmsCriticalSection::omsEnter() {
  if ((m_inSection) || (m_session->m_critical_section_in_use[m_regionId-OMS_INTERNAL_CRITICAL_SECTIONS])) {
    m_session->ThrowDBError (e_already_in_critical_section, "omsEnter", __MY_FILE__, __LINE__);
  }
  m_session->m_critical_section_in_use[m_regionId-OMS_INTERNAL_CRITICAL_SECTIONS] = true;
  m_session->m_lcSink->EnterCriticalSection(m_regionId);
  m_inSection = true;
}

/*----------------------------------------------------------------------*/

void OmsCriticalSection::omsLeave() {
  if (m_inSection) {
    m_session->m_lcSink->LeaveCriticalSection(m_regionId);
    m_session->m_critical_section_in_use[m_regionId-OMS_INTERNAL_CRITICAL_SECTIONS] = false;
    m_inSection = false;
  }
  else {
    m_session->ThrowDBError ( e_not_in_critical_section, "omsLeave", __MY_FILE__, __LINE__);
  }
}

/*----------------------------------------------------------------------*/

OmsCriticalSection::~OmsCriticalSection() {
  if (m_inSection) {
    omsLeave();
  }
}

