/*!**************************************************************************

  module      : Log_ActionObjectFile.cpp
  special area: Logging
  responsible : UweH
  last changed: 2000-09-25  12:00
  copyright:    (c) 2000-2004 SAP AG
  description : implements class Log_ActionObjectFile



    ========== licence begin  GPL
    Copyright (c) 2000-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end

*****************************************************************************/

/*===========================================================================*
 *  INCLUDES                                                                 *
 *===========================================================================*/

#include "KernelCommon/Kernel_VTrace.hpp"
#include "Logging/Log_ActionObjectFile.hpp"
#include "Logging/Log_AfterImage.hpp"
#include "Logging/Log_BeforeImage.hpp"
#include "hbd04.h"
#include "hbd95.h"

/*===========================================================================*
 *  DEFINES                                                                  *
 *===========================================================================*/
/*===========================================================================*
 *  MACROS                                                                   *
 *===========================================================================*/
/*===========================================================================*
 *  EXTERNAL VARIABLES                                                       *
 *===========================================================================*/
/*===========================================================================*
 *  CLASSES, STRUCTURES, TYPES, UNIONS ...                                   *
 *===========================================================================*/

/* --------------------------------------------------------------------------*/
void Log_ActionObjectFile::WritePersistentFormat
        (Data_SplitSpaceWriter &Writer,
         bool                  &isOK) const
{
    Head                          *pHead;
    Data_SplitSpaceWriter::Result  result;

    // set the structured data

    Writer.Reserve (sizeof(Head), REINTERPRET_CAST(SAPDB_Byte*&, pHead), result);
    isOK = Data_SplitSpaceWriter::ok == result;
    if ( ! isOK ) return;

    *pHead = m_Head;
}

/* --------------------------------------------------------------------------*/
void Log_ActionObjectFile::ReadPersistentFormat
        (Data_SplitSpaceReader  &Reader,
         SAPDBMem_IRawAllocator &Allocator,
         bool                   &isOK)
{
    isOK = true;

    Head                          *pHead;
    Data_SplitSpaceReader::Result  result;

    // set the structured data

    Reader.Reserve (sizeof(Head), REINTERPRET_CAST(SAPDB_Byte*&, pHead), result);
    isOK = Data_SplitSpaceReader::ok == result;
    if ( ! isOK ) return;

    m_Head = *pHead;
}

/* --------------------------------------------------------------------------*/
void Log_ActionObjectFile::Redo (tgg00_TransContext   &Trans,
                                 const Log_AfterImage &AfterImage)
{
    switch ( AfterImage.GetActionType() )
    {
    case Log_CreateObjectFile:
        {
            // AIX compiler does not like an temporary object (rvalue) parsed via reference
            LVC_RootPageNoArray rootPageNoArray(m_Head.rootPages,sizeof(m_Head.rootPages));

            bd95Rollforward_CreateObjFile (Trans,
                                           m_Head.fileno,
                                           m_Head.forVarObjects,
                                           m_Head.bodyLength,
                                           m_Head.keyLength,
                                           m_Head.createSeveralKeyFiles,
                                           rootPageNoArray );
        }
		break;
    case Log_DropObjectFile:
        bd95Rollforward_DropObjFile (Trans, m_Head.fileno);
        break;
    default:
        Trans.trError_gg00 = e_not_implemented;
        return;
    }
}

/* --------------------------------------------------------------------------*/
void Log_ActionObjectFile::WriteToTrace (const char * Title) const
{
    if ( Title != NULL )
        Kernel_VTrace() << Title;
    Kernel_VTrace() << "ObjFileNo: " << m_Head.fileno;
    Kernel_VTrace() << "BodySize: "  << m_Head.bodyLength
                    << ", KeySize: " << m_Head.keyLength;
}
    
