# ------------------------------------------------------------------------------
#
# Logging Descriptions
#
# ------------------------------------------------------------------------------
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2004 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

#


regex(.*\.cpp$)    -except

# -------------------------------------------------------------------------------------
# basic types
# -------------------------------------------------------------------------------------

Log_Types.hpp                   inc=SAPDB_Types.hpp,\
                                    SAPDB_EnhancedTypes.hpp,\
                                    SAPDBTrace_Topic.hpp,\
                                    SAPDBDiag_CheckTopic.hpp,\
                                    SAPDB_OStream.hpp,\
                                    Kernel_DateTime.hpp

Log_Types.cpp                   inc=Log_Types.hpp,\
                                    Kernel_VTrace.hpp,\
                                    RTE_Message.hpp,\
                                    Log_Exceptions.hpp

Log_Types-diagnose.cpp          inc=Log_Types.hpp,\
                                    Kernel_VTrace.hpp,\
                                    RTE_Message.hpp,\
                                    Log_Exceptions.hpp -DINSLOWCI=1 

# ------------------------------------------------------------------------------
# Exceptions ans Messages
# ------------------------------------------------------------------------------

Log_Messages.genmsg    ascii

Log_Messages.hpp       inc=SAPDBErr_MessageList.hpp

Log_Exceptions.hpp     inc=SAPDBErr_MessageList.hpp \
                       dep=Log_Messages.hpp

# -------------------------------------------------------------------------------------
# Transactional behaviour
# -------------------------------------------------------------------------------------

Log_Transaction.hpp             inc=ggg00,ggg92.h,\
                                    RTESync_Spinlock.hpp,\
                                    Container_Stack.hpp,\
                                    Data_Types.hpp,\
                                    Data_ISplitSpace.hpp,\
                                    Log_Types.hpp,\
                                    Log_UndoFile.hpp,\
                                    Rst_RedoFile.hpp,\
                                    Log_ActionMultiple.hpp

Log_Transaction.cpp             inc=SAPDBErr_Assertions.hpp,\
                                    SAPDBTrace_Usage.hpp,\
                                    SAPDBMem_NewDestroy.hpp,\
                                    Data_Exceptions.hpp,\
                                    Log_Exceptions.hpp,\
                                    Log_Transaction.hpp,\
                                    Log_Types.hpp,\
                                    Log_Volume.hpp,\
                                    Log_UndoFile.hpp,\
                                    Rst_RedoFile.hpp,\
                                    Log_History.hpp,\
                                    Log_AfterImage.hpp,\
                                    Log_BeforeImage.hpp,\
                                    Log_IAction.hpp,\
                                    Log_Savepoint.hpp,\
                                    Log_ActionCopyUpdBlob.hpp,\
                                    Log_ActionCreateDropFile.hpp,\
                                    Log_ActionInsDelRec.hpp,\
                                    Log_ActionModifyTable.hpp,\
                                    Log_ActionObject.hpp,\
                                    Log_ActionObjectFile.hpp,\
                                    Log_ActionDeleteAllObjects.hpp,\
                                    Log_ActionRefreshSurrogSeq.hpp,\
                                    Log_ActionReorganizeFile.hpp,\
                                    Log_ActionReloadFile.hpp,\
                                    Log_ActionSetFileState.hpp,\
                                    Log_ActionUnloadFile.hpp,\
                                    Log_ActionUpdateRec.hpp,\
                                    Log_ActionPartialRollback.hpp,\
                                    Log_ActionSavepoint.hpp,\
                                    Rst_IRedoTrafficControl.hpp,\
                                    GC_IGCController.hpp,\
                                    RTEConf_ParameterAccessKernelInterface.hpp,\
                                    hkb50.h,hkb54.h,hkb57.h,hgg01.h



# -------------------------------------------------------------------------------------
# Savepoint Manager
# -------------------------------------------------------------------------------------

Log_Savepoint.hpp           inc=gsp00,ggg00,gkb00,\
                                SAPDB_Types.hpp,\
                                Kernel_DateTime.hpp,\
                                Kernel_TaskWaitList.hpp,\
                                Converter_Version.hpp,\
                                IOMan_BlockAddress.hpp,\
                                Data_Types.hpp,\
                                Log_Types.hpp

Log_Savepoint.cpp           inc=heo52.h,heo55k.h,heo56.h,ggg92.h,hkb50.h,hkb51.h,\
                                hgg01.h,hgg08.h,hgg11.h,hkb53.h,hkb90.h,\
                                hbd01.h,hbd20_4.h,hbd90.h,hbd91.h,\
                                hkb38_1.h,hkb57.h,hkb57_1.h,gkb00,\
                                RTE_Message.hpp,\
                                Kernel_DateTime.hpp,\
                                Kernel_IAdminRestartShutdown.hpp,\
                                Kernel_IAdminHotStandby.hpp,\
                                Converter_IBackUp.hpp,\
                                Converter_ICommon.hpp,\
                                Converter_ISavePoint.hpp,\
                                SAPDBErr_Assertions.hpp",\
                                SAPDBTrace_Usage.hpp,\
                                Log_Types.hpp,\
                                Log_AfterImage.hpp,\
                                Log_ActionSavepoint.hpp,\
                                Log_Volume.hpp,\
                                Log_Transaction.hpp,\
                                Log_OpenTransFile.hpp,\
                                Log_History.hpp,\
                                Log_Savepoint.hpp,\
                                Log_Exceptions.hpp,\
                                Rst_IRedoReadTask.hpp,\
                                FBM_IManager.hpp,\
                                Pager_ISavepoint.hpp

Log_OpenTransFile.hpp       inc=SAPDB_Types.hpp,\
                                Data_ChainFixSizeSpace.hpp,\
                                Data_BaseFile.hpp

Log_OpenTransFile.cpp       inc=SAPDBErr_Assertions.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Log_Exceptions.hpp,\
                                Log_Transaction.hpp,\
                                Log_OpenTransFile.hpp,\
                                Log_UndoFile.hpp,\
                                Rst_RedoFile.hpp

# -------------------------------------------------------------------------------------
# History Manager
# -------------------------------------------------------------------------------------

Log_History.hpp             inc=gsp00,ggg00,\
                                SAPDB_Types.hpp,\
                                Container_Vector.hpp,\
                                Data_Types.hpp,\
                                Log_HistoryFile.hpp,\
                                Log_HistoryDirectory.hpp,\
                                GC_IGarbageCollector.hpp

Log_History.cpp             inc=heo55k.h,heo56.h,heo58.h,\
                                hgg01.h,hgg08.h,ggg92.h,\
                                hkb51.h,hkb57_1.h,\
                                hbd91.h,\
                                SAPDBTrace_Usage.hpp,\
                                SAPDBErr_Assertions.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                RTE_Message.hpp,\
                                RTEMem_Allocator.hpp,\
                                Log_Exceptions.hpp,\
                                Log_Types.hpp,\
                                Log_ActionObject.hpp,\
                                Log_ActionObjectFile.hpp,\
                                Log_UndoFile.hpp,\
                                Log_History.hpp,\
                                GC_IGCController.hpp,\
                                Kernel_IAdminConfig.hpp,\
                                Kernel_Migration.hpp

Log_HistoryFile.hpp         inc=ggg91.h,\
                                SAPDB_Types.hpp,\
                                Data_ChainFixSizeSpace.hpp,\
                                Data_BaseFile.hpp,\
                                Log_Types.hpp

Log_HistoryFile.cpp         inc=ggg00,\
                                SAPDBErr_Assertions.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Log_Exceptions.hpp,\
                                Log_UndoFile.hpp,\
                                Log_HistoryFile.hpp

Log_HistoryDirectory.hpp    inc=SAPDB_Types.hpp,\
                                Data_ChainFixSizeSpace.hpp,\
                                Data_BaseFile.hpp

Log_HistoryDirectory.cpp    inc=ggg00,\
                                SAPDBErr_Assertions.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Data_PageAccessManager.hpp,\
                                Log_Exceptions.hpp,\
                                Log_Types.hpp,\
                                Log_HistoryFile.hpp,\
                                Log_HistoryDirectory.hpp

# -------------------------------------------------------------------------------------
# Undo Manager
# -------------------------------------------------------------------------------------

Log_UndoFile.hpp            inc=ggg00,SAPDB_Types.hpp,\
                                Data_PageAccessManager.hpp,\
                                Data_ChainSplitSpaceBackwardRead.hpp,\
                                Data_BaseFile.hpp,\
                                Log_Exceptions.hpp,\
                                Log_BeforeImage.hpp,\
                                Log_IAction.hpp

Log_UndoFile.cpp            inc=SAPDBErr_Assertions.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Kernel_TraceTopics.hpp,\
                                Kernel_VTrace.hpp,\
                                Data_Types.hpp,\
                                Log_Exceptions.hpp,\
                                Log_UndoFile.hpp


# -------------------------------------------------------------------------------------
# Redo Manager
# -------------------------------------------------------------------------------------

# -------------------------------------------------------------------------------------
# Archive Log Manager
# -------------------------------------------------------------------------------------

Log_Page.hpp                    inc=SAPDBTrace_Usage.hpp,\
                                    Data_Types.hpp,\
                                    Kernel_Page74.hpp,\
                                    Kernel_DateTime.hpp,\
                                    Log_Types.hpp

Log_Page.cpp                    inc=Log_Page.hpp,\
                                    Log_Exceptions.hpp,\
                                    Kernel_VTrace.hpp,\
                                    SAPDB_ToString.hpp

Log_InfoPage.hpp                inc=gkb00,\
                                    RTE_Types.h,\
                                    Kernel_Page74.hpp,\
                                    Kernel_DateTime.hpp,\
                                    Kernel_VTrace.hpp,\
                                    Kernel_IAdminInfo.hpp,\
                                    Log_Types.hpp,\
                                    hgg08.h,heo55k.h

Log_WriterTaskSynchronizer.hpp  inc=gsp00,ggg00,heo00x.h,heo56.h,\
                                    SAPDB_Types.hpp,\
                                    RTESync_NamedSpinlock.hpp

Log_QueueEntry.hpp              inc=gsp00,\
                                    RTESync_InterlockedCounter.hpp,\
                                    SAPDBTrace_Usage.hpp,\
                                    Kernel_TaskWaitList.hpp,\
                                    Container_Vector.hpp,\
                                    Log_Page.hpp

Log_QueueRingBuffer.hpp         inc=Log_QueueEntry.hpp,\
                                    Container_CircularList.hpp,\
                                    IOMan_LogPages.hpp,\
                                    hgg01_3.h,\
                                    RTE_ISystem.hpp

Log_QueueRingBuffer.cpp         inc=Log_QueueRingBuffer.hpp

Log_Queue.hpp                   inc=gsp00,ggg04,heo55k.h,hgg08.h,\
                                    SAPDB_Types.hpp,\
                                    Kernel_TaskWaitList.hpp,\
                                    Container_Vector.hpp,\
                                    Log_Types.hpp,\
                                    Log_RawDeviceIterator.hpp,\
                                    Log_WriterTaskSynchronizer.hpp,\
                                    Log_QueueRingBuffer.hpp,\
                                    Log_AfterImageSpace.hpp,\
                                    IOMan_LogPages.hpp
Log_Queue.cpp                   inc=heo56.h,\
                                    RTE_Message.hpp,\
                                    SAPDB_ToString.hpp,\
                                    SAPDBTrace_Usage.hpp,\
                                    Kernel_VTrace.hpp,\
                                    Log_Exceptions.hpp,\
                                    Log_Queue.hpp

Log_RawDeviceIterator.hpp       inc=Kernel_VTrace.hpp,Log_Types.hpp

Log_Writer.hpp                  inc=Container_Vector.hpp,\
                                    Container_CircularList.hpp,\
                                    Log_Queue.hpp,\
                                    Log_InfoPage.hpp,\
                                    Log_WriterTaskSynchronizer.hpp,\
                                    Log_RawDeviceIterator.hpp,\
                                    Kernel_Event.hpp,\
                                    IOMan_ILogIO.hpp,\
                                    hgg01.h

Log_Writer.cpp                  inc=SAPDBTrace_Usage.hpp,\
                                    Kernel_VTrace.hpp,\
                                    Kernel_IAdminInfo.hpp,\
                                    Kernel_DateTime.hpp,\
                                    Log_Writer.hpp,\
                                    Log_Volume.hpp,\
                                    Log_Savepoint.hpp,\
                                    Log_Messages.hpp,\
                                    hkb38_1.h,\
                                    hkb57_1.h,\
                                    heo52.h

Log_ClusterAddress.hpp          inc=IOMan_Types.hpp,\
                                    Log_Types.hpp

Log_SaveIterator.hpp            inc=gkb03,gsp00,\
                                    IOMan_ILogIO.hpp,\
                                    Kernel_Page.hpp,\
                                    Log_Page.hpp,\
                                    Log_RawDeviceIterator.hpp,\
                                    SAPDBMem_IRawAllocator.hpp,\
                                    Log_QueueRingBuffer.hpp,\
                                    IOMan_LogPages.hpp

Log_SaveIterator.cpp            inc=Log_SaveIterator.hpp,\
                                    Log_VolumeIterator.hpp,\
                                    Log_ClusterAddress.hpp,\
                                    SAPDBMem_NewDestroy.hpp,\
                                    Kernel_VTrace.hpp,\
                                    hgg01.h

Log_Volume.hpp              inc=gsp00,\
                                    SAPDB_Types.hpp,\
                                    SAPDBMem_NewDestroy.hpp,\
                                    SAPDBMem_IRawAllocator.hpp,\
                                    Container_Vector.hpp,\
                                    Kernel_Event.hpp,\
                                    Log_IDiagnose.hpp,\
                                    Log_Exceptions.hpp,\
                                    Log_RawDeviceIterator.hpp,\
                                    Log_SaveIterator.hpp,\
                                    Log_Queue.hpp,\
                                    Log_Writer.hpp,\
                                    Log_InfoPage.hpp,\
                                    Log_VolumeIterator.hpp,\
                                    IOMan_ILogIO.hpp,\
                                    Log_SeqLogDevReader.hpp

Log_Volume.cpp              inc=hgg01.h,hgg01_3.h,\
                                    heo47.h,\
                                    hkb38.h,hkb57_1.h,\
                                    SAPDBTrace_Usage.hpp,\
                                    Kernel_DateTime.hpp,\
                                    Kernel_Version.hpp,\
                                    Kernel_IAdminRestartShutdown.hpp,\
                                    Kernel_IAdminHotStandby.hpp,\
                                    Kernel_IAdminDiagnose.hpp,\
                                    Kernel_IAdminInfo.hpp,\
                                    Kernel_IAdminConfig.hpp,\
                                    Kernel_Version.hpp,\
                                    Kernel_Migration.hpp,\
                                    SAPDBMem_NewDestroy.hpp,\
                                    RTE_Message.hpp,\
                                    RTE_Crash.hpp,\
                                    RTEConf_ParameterAccessKernelInterface.hpp,\
                                    IOMan_ILogManager.hpp,\
                                    IOMan_ILogInfo.hpp,\
                                    Log_SeqTapeReader.hpp,\
                                    Log_Savepoint.hpp,\
                                    Log_Volume.hpp \
&if $OSSPEC = LINUX #PTS 1110637
nodebug
&endif

Log_VolumeIterator.hpp      inc=gsp00,\
                                    IOMan_ILogIO.hpp,\
                                    Log_Types.hpp,\
                                    Log_ISequentialReader.hpp
                                    
Log_VolumeIterator.cpp      inc=SAPDBTrace_Usage.hpp,\
                                    Kernel_VTrace.hpp,\
                                    Kernel_IAdminRestartShutdown.hpp,\
                                    Kernel_IAdminHotStandby.hpp,\
                                    Log_VolumeIterator.hpp,\
                                    Rst_StandbySynchronizer.hpp,\
                                    Log_Exceptions.hpp,\
                                    RTE_Message.hpp,\
                                    RTE_Crash.hpp
                                    
Log_ISequentialReader.hpp       inc=gsp00,\
                                    SAPDB_Types.hpp,\
                                    Log_Types.hpp,\
                                    Log_RawDeviceIterator.hpp


Log_SeqLogDevReader.hpp         inc=Log_Types.hpp,\
                                    Log_RawDeviceIterator.hpp,\
                                    Log_ClusterAddress.hpp,\
                                    IOMan_ILogIO.hpp,\
                                    Log_ISequentialReader.hpp,\
                                    Rst_StandbySynchronizer.hpp,\
                                    RTEConf_ParameterAccessKernelInterface.hpp

Log_SeqTapeReader.hpp           inc=Log_ISequentialReader.hpp,\
                                    hkb39.h,\
                                    hgg01_3.h

Log_IDiagnose.hpp               inc=Log_Page.hpp

# -------------------------------------------------------------------------------------
# Log Entries
# -------------------------------------------------------------------------------------

Log_IImage.hpp              inc=SAPDB_Types.hpp,\
                                Data_ISplitSpace.hpp,\
                                Log_Types.hpp

Log_IAction.hpp             inc=SAPDB_Types.hpp,ggg00

Log_BeforeImage.hpp         inc=SAPDB_Types.hpp,\
                                Kernel_VTrace.hpp,\
                                Data_ISplitSpace.hpp,\
                                Data_SplitSpace.hpp,\
                                Data_PageSplitSpace.hpp,\
                                Log_Types.hpp,\
                                Log_IImage.hpp,\
                                ggg91.h

Log_AfterImage.hpp          inc=SAPDB_Types.hpp,\
                                Kernel_VTrace.hpp,\
                                Log_Types.hpp,\
                                Data_ISplitSpace.hpp,\
                                Log_AfterImageSpace.hpp,\
                                Log_IImage.hpp,\
                                ggg91.h

Log_ActionCopyUpdBlob.hpp   inc=Kernel_VTrace.hpp,\
                                SAPDB_Types.hpp,\
                                Log_Types.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                ggg00

Log_ActionCopyUpdBlob.cpp   inc=Log_ActionCopyUpdBlob.hpp,\
                                SAPDB_Types.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Kernel_Trace.hpp,\
                                Log_ActionFileHandling.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                ggg00,hbd01.h,hbd05.h

Log_ActionCreateDropFile.hpp inc=SAPDB_Types.hpp,\
                                Log_Types.hpp,\
                                Log_InvDescMap.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                ggg91.h,ggg00

Log_ActionCreateDropFile.cpp inc=Log_ActionCreateDropFile.hpp,\
                                SAPDB_Types.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Kernel_Trace.hpp,\
                                Kernel_IAdminHotStandby.hpp,\
                                Log_InvDescMap.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                Log_ActionFileHandling.hpp,\
                                ggg91.h,ggg00,\
                                hbd01.h,hbd03.h,hkb64.h

Log_ActionFileHandling.hpp  inc=ggg00,hbd01_1.h

Log_ActionInsDelRec.hpp     inc=SAPDB_Types.hpp,\
                                SAPDBErr_Assertions.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                Log_Types.hpp,\
                                Log_InvDescMap.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                ggg00

Log_ActionInsDelRec.cpp     inc=Log_ActionInsDelRec.hpp,\
                                SAPDB_Types.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Kernel_Trace.hpp,\
                                Log_InvDescMap.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                Log_Transaction.hpp,\
                                ggg00,hbd01_1.h,hbd02.h,hgg10.h

Log_ActionModifyTable.hpp   inc=SAPDB_Types.hpp,\
                                Log_InvDescMap.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                ggg00

Log_ActionModifyTable.cpp     inc=Log_ActionModifyTable.hpp,\
                                SAPDB_Types.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Kernel_Trace.hpp,\
                                Log_Types.hpp,\
                                Log_ActionFileHandling.hpp,\
                                Log_InvDescMap.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                ggg00,hbd01.h,hbd37.h

Log_ActionMultiple.hpp      inc=ggg00,\
                                SAPDB_Types.hpp,\
                                SAPDBErr_Assertions.hpp,\
                                Data_ISplitSpace.hpp,\
                                Log_IAction.hpp,\
                                Log_Types.hpp

Log_ActionMultiple.cpp      inc=Log_ActionMultiple.hpp,\
                                Log_AfterImage.hpp,\
                                Log_Transaction.hpp,\
                                Kernel_VTrace.hpp

Log_ActionObject.hpp        inc=ggg00,ggg92.h,SAPDB_Types.hpp,\
                                SAPDBErr_Assertions.hpp,\
                                SAPDBMem_NewDestroy.hpp,\
                                Data_PageSplitSpace.hpp,\
                                Data_ISplitSpace.hpp,\
                                Log_Types.hpp,\
                                Log_IAction.hpp

Log_ActionObject.cpp        inc=Kernel_VTrace.hpp,\
                                Log_ActionObject.hpp,\
                                Log_AfterImage.hpp,\
                                Log_BeforeImage.hpp,\
                                hbd04.h,\
                                hbd95.h

Log_ActionObjectFile.hpp    inc=ggg00,\
                                SAPDB_Types.hpp,\
                                LVC_Types.hpp,\
                                Log_Types.hpp,\
                                Log_IAction.hpp

Log_ActionObjectFile.cpp    inc=Kernel_VTrace.hpp,\
                                Log_ActionObjectFile.hpp,\
                                Log_AfterImage.hpp,\
                                Log_BeforeImage.hpp,\
                                hbd04.h,\
                                hbd95.h

Log_ActionDeleteAllObjects.hpp inc=ggg00,\
                                   SAPDB_Types.hpp,\
                                   Container_Vector.hpp,\
                                   LVC_Types.hpp,\
                                   Log_Types.hpp,\
                                   Log_IAction.hpp

Log_ActionDeleteAllObjects.cpp inc=Kernel_VTrace.hpp,\
                                   Log_ActionDeleteAllObjects.hpp,\
                                   Log_AfterImage.hpp,\
                                   Log_BeforeImage.hpp,\
                                   hbd04.h,\
                                   hbd95.h

Log_ActionPartialRollback.hpp inc=SAPDB_Types.hpp,\
                                  Data_ISplitSpace.hpp,\
                                  Log_Types.hpp,\
                                  Log_IAction.hpp

Log_ActionRefreshSurrogSeq.hpp inc=SAPDB_Types.hpp,\
                                   SAPDBMem_IRawAllocator.hpp,\
                                   Log_Types.hpp,\
                                   Log_ReadWriteActionImage.hpp,\
                                   gsp00,ggg00

Log_ActionRefreshSurrogSeq.cpp inc=Log_ActionRefreshSurrogSeq.hpp,\
                                   SAPDB_Types.hpp,\
                                   SAPDBMem_IRawAllocator.hpp,\
                                   SAPDBTrace_Usage.hpp,\
                                   Kernel_Trace.hpp,\
                                   Log_ReadWriteActionImage.hpp,\
                                   gsp00,ggg00,hkb57.h

Log_ActionReloadFile.hpp inc=ggg00,\
                             SAPDB_Types.hpp,\
                             Log_Types.hpp,\
                             Log_ReadWriteActionImage.hpp

Log_ActionReloadFile.cpp inc=ggg00,hbd01.h,\
                             Log_ActionReloadFile.hpp,\
                             Log_ActionFileHandling.hpp

Log_ActionUnloadFile.hpp inc=ggg00,\
                             SAPDB_Types.hpp,\
                             Log_Types.hpp,\
                             Log_ReadWriteActionImage.hpp

Log_ActionUnloadFile.cpp inc=ggg00,hbd01.h,\
                             Log_ActionUnloadFile.hpp,\
                             Log_ActionFileHandling.hpp

Log_ActionReorganizeFile.hpp inc=ggg00,\
                                 SAPDB_Types.hpp,\
                                 Log_Types.hpp,\
                                 Log_ReadWriteActionImage.hpp

Log_ActionReorganizeFile.cpp inc=ggg00,hbd01.h,hbd09.h,\
                                 Log_ActionReorganizeFile.hpp,\
                                 Log_ActionFileHandling.hpp

Log_ActionSavepoint.hpp     inc=SAPDB_Types.hpp,\
                                Data_ISplitSpace.hpp,\
                                Log_IAction.hpp,\
                                hgg11.h

Log_ActionSetFileState.hpp inc=ggg00,\
                               SAPDB_Types.hpp,\
                               Log_Types.hpp,\
                               Log_ReadWriteActionImage.hpp

Log_ActionSetFileState.cpp inc=ggg00,hbd01.h,\
                               Log_ActionSetFileState.hpp,\
                               Log_ActionFileHandling.hpp

Log_ActionUpdateRec.hpp     inc=SAPDB_Types.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                Log_Types.hpp,\
                                Log_InvDescMap.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                Log_RecordColumnMap.hpp,\
                                ggg00

Log_ActionUpdateRec.cpp     inc=Log_ActionUpdateRec.hpp,\
                                SAPDB_Types.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Kernel_VTrace.hpp,\
                                Kernel_Trace.hpp,\
                                Log_InvDescMap.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                Log_RecordColumnMap.hpp,\
                                Log_Transaction.hpp,\
                                ggg00,hbd01_1.h,hbd02.h,hgg10.h

Log_AfterImageSpace.hpp     inc=SAPDB_Types.hpp,\
                                SAPDBErr_Assertions.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                Container_Vector.hpp,\
                                Data_ISplitSpace.hpp,\
                                Log_QueueEntry.hpp

Log_InvDescMap.hpp          inc=SAPDB_Types.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                Log_IRecordColumnMap.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                ggg00

Log_InvDescMap.cpp          inc=Log_InvDescMap.hpp,\
                                SAPDB_Types.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                SAPDBMem_NewDestroy.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Log_Types.hpp,\
                                Kernel_Trace.hpp,\
                                Log_IRecordColumnMap.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                SAPDBMem_IncrementalBufferAllocator.hpp,\
                                SAPDBFields_FieldMap.hpp,\
                                DBProc_Handler.hpp,\
                                gsp00,ggg00,ggg01,ggg04,\
                                hbd03.h,hbd06.h,hgg04.h,hgg10.h,\
                                hkb53.h,hkb62.h,hsp30.h,heo58.h

Log_ReadWriteActionImage.hpp inc=SAPDB_Types.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                Data_ISplitSpace.hpp,\
                                Log_Types.hpp,\
                                Log_IAction.hpp,\
                                ggg00

Log_ReadWriteActionImage.cpp inc=Log_ReadWriteActionImage.hpp,\
                                SAPDB_Types.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Data_ISplitSpace.hpp,\
                                Kernel_Trace.hpp,\
                                Log_Types.hpp,\
                                Log_AfterImage.hpp,\
                                Log_BeforeImage.hpp,\
                                Log_Transaction.hpp,\
                                ggg00

Log_IRecordColumnMap.hpp    inc=ggg00

Log_RecordColumnMap.hpp     inc=Log_IRecordColumnMap.hpp,\
                                SAPDB_Types.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                Kernel_VTrace.hpp,\
                                Log_Types.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                ggg00

Log_RecordColumnMap.cpp     inc=Log_RecordColumnMap.hpp,\
                                SAPDB_Types.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                SAPDBMem_NewDestroy.hpp,\
                                SAPDBTrace_Usage.hpp,\
                                Kernel_VTrace.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                Kernel_Trace.hpp,\
                                gsp00,ggg00,\
                                hgg10.h,hsp30.h

# -------------------------------------------------------------------------------------
# Log Commands
# -------------------------------------------------------------------------------------

Log_CommandInsDelUpd.hpp    inc=SAPDBMem_IRawAllocator.hpp,\
                                Log_Types.hpp,\
                                Log_ActionInsDelRec.hpp,\
                                Log_ActionUpdateRec.hpp,\
                                Log_InvDescMap.hpp,\
                                Log_ReadWriteActionImage.hpp,\
                                ggg00

Log_CommandInsDelUpd.cpp    inc=Log_CommandInsDelUpd.hpp,\
                                SAPDBMem_IRawAllocator.hpp,\
                                Log_ActionUpdateRec.hpp,\
                                Log_InvDescMap.hpp,\
                                ggg00,\
                                hbd02.h

# ------------------------------------------------------------------------------
# class Log_Test
# ------------------------------------------------------------------------------

Log_Test.hpp                inc=ggg00,Log_Types.hpp

Log_Test.cpp                inc=Log_Test.hpp,\
                                Log_Transaction.hpp,\
                                ggg00,hkb560.h

# ------------------------------------------------------------------------------
# other Log_Tests
# ------------------------------------------------------------------------------

Log_PageTest.cpp            inc=Log_Page.hpp,\
                                Log_InfoPage.hpp

# ------------------------------------------------------------------------------
# PTS 1111952 UH 2001-09-26
&if $OSSPEC == OSF1 && $__DECCXX > 600
Log_RecordColumnMap.cpp -OPT=-O1
&endif

&if $OSSPEC == LINUX && $MACH in [ S390X, IA64 ]
regex(\w+\.cpp) -OPT=-O2
&endif

&if $OSSPEC == LINUX && $MACH in [ SDBonPPC64 ]
Log_Volume.cpp -OPT=-O1
&endif
