/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.DBProcParameterInfo;
import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.StructMemberTranslator;
import com.sap.dbtech.jdbc.translators.Structure;
import com.sap.dbtech.jdbc.translators.StructureSQLOutput;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.Struct;

public class StructureTranslator
extends DBTechTranslator {
    DBProcParameterInfo parameterStructure;
    StructMemberTranslator[] structureConverter;
    boolean unicode;

    public StructureTranslator(int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super(n, n2, n3, n4, n5, n6);
        this.unicode = bl;
        this.structureConverter = new StructMemberTranslator[0];
    }

    protected void putSpecific(DataPart dataPart, Object object) throws SQLException {
        byte[] byArray = (byte[])object;
        dataPart.putInt1(0, this.bufpos - 1);
        dataPart.putBytes(byArray, this.bufpos, this.physicalLength - 1);
    }

    public byte getByte(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        byte[] byArray = null;
        if (this.isNull(sQLParamController, structuredMem)) {
            return 0;
        }
        byArray = structuredMem.getBytes(this.bufpos, 1);
        return byArray[0];
    }

    public byte[] getBytes(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        byte[] byArray = null;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byArray = structuredMem.getBytes(this.bufpos, this.logicalLength);
        }
        return byArray;
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        byte[] byArray = this.getBytes(sQLParamController, structuredMem);
        if (byArray != null) {
            Object[] objectArray = new Object[this.structureConverter.length];
            StructuredBytes structuredBytes = new StructuredBytes(byArray);
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = this.structureConverter[i].getObject(structuredBytes, 0);
            }
            return new Structure(objectArray, this.parameterStructure.getSQLTypeName());
        }
        return null;
    }

    public Object transByteForInput(byte by) throws SQLException {
        byte[] byArray = new byte[]{by};
        return this.transBytesForInput(byArray);
    }

    public Object transBytesForInput(byte[] byArray) throws SQLException {
        if (byArray == null) {
            return byArray;
        }
        this.checkFieldLimits(byArray.length);
        return byArray;
    }

    public Object transSpecificForInput(Object object) throws SQLException {
        Object object2 = null;
        if (object instanceof byte[]) {
            object2 = this.transBytesForInput((byte[])object);
        } else if (object instanceof Object[]) {
            object2 = this.transObjectArrayForInput((Object[])object);
        } else if (object instanceof Struct) {
            object2 = this.transObjectArrayForInput(((Struct)object).getAttributes());
        } else if (object instanceof SQLData) {
            object2 = this.transSQLDataForInput((SQLData)object);
        }
        return object2;
    }

    public Object transSQLDataForInput(SQLData sQLData) throws SQLException {
        StructureSQLOutput structureSQLOutput = new StructureSQLOutput(this);
        sQLData.writeSQL(structureSQLOutput);
        return structureSQLOutput.getData();
    }

    public Object transObjectArrayForInput(Object[] objectArray) throws SQLException {
        if (objectArray.length != this.structureConverter.length) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.structure.arraywronglength", new Integer(this.structureConverter.length), new Integer(objectArray.length)));
        }
        StructuredBytes structuredBytes = new StructuredBytes(this.physicalLength - 1);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.structure.element.null", new Integer(i + 1)));
            }
            this.structureConverter[i].putObject(structuredBytes, objectArray[i]);
        }
        return structuredBytes.bytes();
    }

    public Object transCharacterStreamForInput(Reader reader, int n) throws SQLException {
        if (n <= 0) {
            return null;
        }
        try {
            char[] cArray = new char[n];
            int n2 = reader.read(cArray);
            if (n2 != n) {
                if (n2 == -1) {
                    n2 = 0;
                }
                char[] cArray2 = cArray;
                cArray = new char[n2];
                System.arraycopy(cArray2, 0, cArray, 0, n2);
            }
            return this.transStringForInput(new String(cArray));
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(iOException.getMessage());
        }
    }

    public Object transBinaryStreamForInput(InputStream inputStream, int n) throws SQLException {
        if (n <= 0) {
            return null;
        }
        try {
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            if (n2 != n) {
                if (n2 == -1) {
                    n2 = 0;
                }
                byte[] byArray2 = byArray;
                byArray = new byte[n2];
                System.arraycopy(byArray2, 0, byArray, 0, n2);
            }
            return this.transBytesForInput(byArray);
        }
        catch (IOException iOException) {
            throw new SQLExceptionSapDB(iOException.getMessage());
        }
    }

    public InputStream getBinaryStream(SQLParamController sQLParamController, StructuredMem structuredMem, StructuredMem structuredMem2) throws SQLException {
        byte[] byArray = this.getBytes(sQLParamController, structuredMem);
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    public void setProcParamInfo(DBProcParameterInfo dBProcParameterInfo) throws SQLException {
        this.parameterStructure = dBProcParameterInfo;
        this.structureConverter = StructMemberTranslator.createStructMemberTranslators(dBProcParameterInfo, this.unicode);
    }
}

