/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.AbstractProcedurePutval;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.InputStreamFilter;
import com.sap.dbtech.util.MessageTranslator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class AsciiProcedurePutval
extends AbstractProcedurePutval {
    private InputStream stream;
    private boolean marksupported;
    private int length;
    private boolean atBegin = true;

    public AsciiProcedurePutval(DBTechTranslator dBTechTranslator, byte[] byArray) {
        this(dBTechTranslator, new ByteArrayInputStream(byArray), -1);
    }

    public AsciiProcedurePutval(DBTechTranslator dBTechTranslator, InputStream inputStream, int n) {
        super(dBTechTranslator);
        if (n == -1) {
            this.stream = inputStream;
            this.marksupported = this.stream.markSupported();
            this.length = Integer.MAX_VALUE;
        } else {
            this.stream = new InputStreamFilter(inputStream, n);
            this.marksupported = this.stream.markSupported();
            this.length = n;
        }
        if (this.marksupported) {
            this.stream.mark(this.length);
        }
    }

    public void transferStream(DataPart dataPart, short s) throws SQLException {
        if (s == -2) {
            if (!this.atBegin) {
                if (this.marksupported) {
                    try {
                        this.stream.reset();
                        this.stream.mark(this.length);
                    }
                    catch (IOException iOException) {
                        throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
                    }
                } else {
                    throw new SQLExceptionSapDB(MessageTranslator.translate("error.reset.stream"));
                }
            }
            s = Short.MAX_VALUE;
        } else if (this.atBegin && this.marksupported) {
            this.stream.mark(this.length);
        }
        if (dataPart.fillWithProcedureStream(this.stream, s)) {
            try {
                this.stream.close();
            }
            catch (IOException iOException) {
                throw new SQLExceptionSapDB(MessageTranslator.translate("error.stream.ioexception", iOException.getMessage()));
            }
        }
    }
}

