'\" t
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface, \fRO'Reilly and Associates, Sebastopol, 1991. 
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
'\" t
.TH XAllocWMHints __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XAllocWMHints, XSetWMHints, XGetWMHints, XWMHints \- allocate window manager hints structure and set or read a window's WM_HINTS property
.SH SYNTAX
.HP
XWMHints *XAllocWMHints\^(void\^); 
.HP
int XSetWMHints\^(\^Display *\fIdisplay\fP, Window \fIw\fP, XWMHints *\fIwmhints\fP\^);
.HP
XWMHints *XGetWMHints\^(\^Display *\fIdisplay\fP, Window \fIw\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIw\fP 1i
Specifies the window.
.IP \fIwmhints\fP 1i
Specifies the 
.ZN XWMHints
structure to be used.
.SH DESCRIPTION
The
.ZN XAllocWMHints
function allocates and returns a pointer to a
.ZN XWMHints
structure.
Note that all fields in the
.ZN XWMHints
structure are initially set to zero.
If insufficient memory is available, 
.ZN XAllocWMHints
returns NULL.
To free the memory allocated to this structure,
use
.ZN XFree .
.LP
The
.ZN XSetWMHints
function sets the window manager hints that include icon information and location,
the initial state of the window, and whether the application relies on the
window manager to get keyboard input.
.LP
.ZN XSetWMHints
can generate
.ZN BadAlloc
and
.ZN BadWindow
errors.
.LP
The
.ZN XGetWMHints
function reads the window manager hints and 
returns NULL if no WM_HINTS property was set on the window 
or returns a pointer to a 
.ZN XWMHints 
structure if it succeeds.
When finished with the data,
free the space used for it by calling
.ZN XFree .
.LP
.ZN XGetWMHints
can generate a
.ZN BadWindow
error.
.SH PROPERTIES
.TP 1i
\s-1WM_HINTS\s+1
Additional hints set by the client for use by the window manager.
The C type of this property is 
.ZN XWMHints .
.SH STRUCTURES
The
.ZN XWMHints
structure contains:
.LP
/\&* Window manager hints mask bits */
.TS
lw(.5i) lw(2.5i) lw(2.5i).
T{
\&#define
T}	T{
.ZN InputHint
T}	T{
(1L << 0)
T}
T{
\&#define
T}	T{
.ZN StateHint
T}	T{
(1L << 1)
T}
T{
\&#define
T}	T{
.ZN IconPixmapHint
T}	T{
(1L << 2)
T}
T{
\&#define
T}	T{
.ZN IconWindowHint
T}	T{
(1L << 3)
T}
T{
\&#define
T}	T{
.ZN IconPositionHint
T}	T{
(1L << 4)
T}
T{
\&#define
T}	T{
.ZN IconMaskHint
T}	T{
(1L << 5)
T}
T{
\&#define
T}	T{
.ZN WindowGroupHint
T}	T{
(1L << 6)
T}
T{
\&#define
T}	T{
.ZN XUrgencyHint
T}	T{
(1L << 8)
T}
T{
\&#define
T}	T{
.ZN AllHints
T}	T{
(InputHint|StateHint|IconPixmapHint|
.br
IconWindowHint|IconPositionHint|
.br
IconMaskHint|WindowGroupHint)
T}
.TE
.IN "XWMHints" "" "@DEF@"
.Ds 0
.TA .5i 2.5i
.ta .5i 2.5i
/\&* Values */

typedef struct {
	long flags;	/\&* marks which fields in this structure are defined */
	Bool input;	/\&* does this application rely on the window manager to
			get keyboard input? */
	int initial_state;	/\&* see below */
	Pixmap icon_pixmap;	/\&* pixmap to be used as icon */
	Window icon_window;	/\&* window to be used as icon */
	int icon_x, icon_y;	/\&* initial position of icon */
	Pixmap icon_mask;	/\&* pixmap to be used as mask for icon_pixmap */
	XID window_group;	/\&* id of related window group */
	/\&* this structure may be extended in the future */
} XWMHints;
.De
.LP
The input member is used to communicate to the window manager the input focus
model used by the application.
Applications that expect input but never explicitly set focus to any 
of their subwindows (that is, use the push model of focus management), 
such as X Version 10 style applications that use real-estate
driven focus, should set this member to 
.ZN True .  
Similarly, applications
that set input focus to their subwindows only when it is given to their
top-level window by a window manager should also set this member to 
.ZN True .
Applications that manage their own input focus by explicitly setting
focus to one of their subwindows whenever they want keyboard input 
(that is, use the pull model of focus management) should set this member to 
.ZN False .
Applications that never expect any keyboard input also should set this member
to 
.ZN False .
.LP
Pull model window managers should make it possible for push model
applications to get input by setting input focus to the top-level windows of
applications whose input member is 
.ZN True .  
Push model window managers should
make sure that pull model applications do not break them 
by resetting input focus to 
.ZN PointerRoot 
when it is appropriate (for example, whenever an application whose
input member is 
.ZN False 
sets input focus to one of its subwindows).
.LP
The definitions for the initial_state flag are:
.TS
lw(.5i) lw(2i) lw(.2i) lw(2.8i).
T{
\&#define
T}	T{
.ZN WithdrawnState
T}	T{
0
T}	T{
T}
T{
\&#define
T}	T{
.ZN NormalState
T}	T{
1
T}	T{
/\&* most applications start this way */
T}
T{
\&#define
T}	T{
.ZN IconicState
T}	T{
3
T}	T{
/\&* application wants to start as an icon */
T}
.TE
The icon_mask specifies which pixels of the icon_pixmap should be used as the
icon.  
This allows for nonrectangular icons.
Both icon_pixmap and icon_mask must be bitmaps.
The icon_window lets an application provide a window for use as an icon
for window managers that support such use.
The window_group lets you specify that this window belongs to a group
of other windows.
For example, if a single application manipulates multiple 
top-level windows, this allows you to provide enough
information that a window manager can iconify all of the windows
rather than just the one window.
.LP
The
.ZN UrgencyHint
flag, if set in the flags field, indicates that the client deems the window
contents to be urgent, requiring the timely response of the user.  The
window manager will make some effort to draw the user's attention to this
window while this flag is set.  The client must provide some means by which the
user can cause the urgency flag to be cleared (either mitigating
the condition that made the window urgent or merely shutting off the alarm)
or the window to be withdrawn.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAlloc
The server failed to allocate the requested resource or server memory.
.TP 1i
.ZN BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
XAllocClassHint(__libmansuffix__),
XAllocIconSize(__libmansuffix__),
XAllocSizeHints(__libmansuffix__),
XFree(__libmansuffix__),
XSetCommand(__libmansuffix__),
XSetTransientForHint(__libmansuffix__),
XSetTextProperty(__libmansuffix__),
XSetWMClientMachine(__libmansuffix__),
XSetWMColormapWindows(__libmansuffix__),
XSetWMIconName(__libmansuffix__),
XSetWMName(__libmansuffix__),
XSetWMProperties(__libmansuffix__),
XSetWMProtocols(__libmansuffix__),
XStringListToTextProperty(__libmansuffix__)
.br
\fI\*(xL\fP
