/*
 * $Id: kom-config.h,v 1.3 1999/05/24 09:38:16 ceder Exp $
 * Copyright (C) 1991-1994, 1998-1999  Lysator Academic Computer Association.
 *
 * This file is part of the LysKOM server.
 * 
 * LysKOM is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 1, or (at your option) 
 * any later version.
 * 
 * LysKOM is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with LysKOM; see the file COPYING.  If not, write to
 * Lysator, c/o ISY, Linkoping University, S-581 83 Linkoping, SWEDEN,
 * or the Free Software Foundation, Inc., 675 Mass Ave, Cambridge, 
 * MA 02139, USA.
 *
 * Please mail bug reports to bug-lyskom@lysator.liu.se. 
 */
/*
 *  config.h
 *
 *  Configuration parameters for compiling.  Contains among other
 *  things all the stupid limits you really want to be without, all the
 *  smart limits that has to be there to make it impossible to crash
 *  the server, and lots of constants and configuration options.
 *
 *  Almost all of this can currently be set in a configuration file.
 *  There is normally no reason to change anything in this file.
 */

/* Collating sequence used. */
#define DEFAULT_COLLAT_TAB	swedish_collate_tab



/* The file kom_perror prints to.  */
/* Yes! This should be stdout. At least during testing and debugging! /ceder */

#define kom_errout	stdout

/*
 * The following are constants which can not be changed without rewriting
 * some of the code.
 */
#define PROTOCOL_NUMBER_BASE 10	/* The number base used in all communication
				 * between server and clients. */


extern const char *DEFAULT_DBASE_DIR;
extern const char *CONFIG_FILE;

/* Communications */

/*
 * MAX_NO_OF_CONNECTIONS must be small enough. Each connection takes one
 * file descriptor, and it is important that there are a few descriptors
 * left so that it is possible to save the data base. lyskomd might crash
 * if this number is too big and that many connection attempts are made
 * simultaneously.
 *
 * The following descriptors are open by LysKOM:
 *   stdin, stdout, stderr   (stdin and stdout could probably be closed.
 *			      The log() function prints to stderr.)
 *   TEXTFILE_NAME	     (always open)
 *   DATAFILE_NAME	     (often open)
 *   STATISTIC_NAME	     (open after a SIGUSR1)
 *   Two TCP/IP ports	     (normal connections and mux-connections)
 *   One UDP/IP port	     (probably from -lresolv, but I'm not sure)
 *   One TCP/IP port	     (if HAVE_LIBAUTHUSER is defined)
 * Thus, the max number of connections is the number of available file
 * descriptors minus ten. This has not been fully tested for a long
 * while, so we subtract twelve just to be on the safe side. That still
 * gives 52 simultaneous users on a sun4, and that is enough for the
 * time beeing. (If you need more connections you can run a mux. Send
 * mail to kom@lysator.liu.se for more info.)
 *
 * Machines where less or more files are open should set this in the 
 * configure script.
 */

#ifndef PROTECTED_FDS
#define PROTECTED_FDS 12
#endif

/*
 * An upper limit of how many connections to LysKOM that can be opened
 * simultaneously. If we HAVE_GETDTABLESIZE this is set once and for
 * all at the beginning of main(). Otherwise it is determined at
 * compile-time.
 */
#if defined(HAVE_GETDTABLESIZE) || defined(HAVE_SYSCONF)
extern int MAX_NO_OF_CONNECTIONS;
#else
extern const int MAX_NO_OF_CONNECTIONS;
#endif

/* What is whitespace? */
extern const unsigned char *WHITESPACE;
