/***************************************************************************
                          shots.h  -  description
                             -------------------
    begin                : Sat Sep 8 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

typedef struct {
    float   x, y;
    float   cur_fr;
    Target  t;
    int     next_too; /* destroys right brick, too */
} Shot;

/*
====================================================================
Load, delete shot graphics
====================================================================
*/
void shot_load();
void shot_delete();
/*
====================================================================
Create new shot at position (centered).
====================================================================
*/
void shot_create( int x, int y );
/*
====================================================================
Delete all shots
====================================================================
*/
void shots_reset();
/*
====================================================================
Hide and show shots
====================================================================
*/
void shots_hide();
void shots_show();
void shots_alphashow( int alpha );
/*
====================================================================
Update position of shots and check if bricks get destroyed
If this happens true is returned and balls must be checked (new
targets).
====================================================================
*/
int shots_update( int ms );
/*
====================================================================
Get new targets for all shots that where supposed to
destroy brick at x,y
====================================================================
*/
void shots_get_new_targets( int x, int y );
/*
====================================================================
Return true if below shot_limit
====================================================================
*/
int shots_below_limit();
