/*XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 * THIS FILE IS NO LONGER IN USE.  THE sim700 + lasi7xx DRIVER
 * HAS BEEN REPLACED BY A NEW 53c700 + lasi700 DRIVER, AND THIS
 * FILE WILL GO AWAY ONCE WE ARE HAPPY WITH THE NEW DRIVER.
 *XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
 */

/*
 * Lasi 53c7xx device driver.
 * By David Kennedy (dkennedy@thepuffingroup.com),
 *    Grant Grundler (grundler@puffin.external.hp.com),
 *    and Gyula Matics (gyula_matics@hp.com)
 *
 * Based on:
 * Detection routine for the NCR53c710 based Amiga SCSI Controllers for Linux.
 *  		Amiga MacroSystemUS WarpEngine SCSI controller.
 *		Amiga Technologies A4000T SCSI controller.
 *		Amiga Technologies/DKB A4091 SCSI controller.
 *
 * Written 1997 by Alan Hourihane <alanh@fairlite.demon.co.uk>
 * plus modifications of the 53c7xx.c driver to support the Amiga.
 */

#include <linux/init.h>
#include <linux/types.h>
#include <linux/stat.h>
#include <linux/mm.h>
#include <linux/blk.h>
#include <linux/sched.h>
#include <linux/version.h>
#include <linux/config.h>
#include <linux/module.h>

#include <asm/page.h>
#include <asm/pgtable.h>
#include <asm/irq.h>
#include <asm/hardware.h>
#include <asm/delay.h>
#include <asm/gsc.h>

#include "scsi.h"
#include "hosts.h"
#include "sim700.h"	/* for OPT_NCR_LE */
#include "lasi7xx.h"


/* hosts_* are kluges to pass info between the lasi7xx_detected()
** and the register_parisc_driver() callbacks.
*/
static Scsi_Host_Template *hosts_tptr;
static int hosts_used;

extern int sim700_init_host(Scsi_Host_Template *tpnt,
                    int chip,
		    unsigned long base_addr,
		    int irq_vector,
		    u32 options
		    );


static int
lasi_scsi_callback(struct parisc_device *dev)
{
	if (dev->id.sversion == 0x00071) {
		hosts_used = sim700_init_host(hosts_tptr, 700, 
			dev->hpa + LASI_SCSI_CORE_OFFSET, dev->irq, OPT_NCR_LE);
	} else {
		hosts_used = sim700_init_host(hosts_tptr, 710, 
			dev->hpa + LASI_SCSI_CORE_OFFSET, dev->irq, 0);
	}

	return (hosts_used == 0);
}

static struct parisc_device_id lasi_scsi_tbl[] = {
	{ HPHW_FIO, HVERSION_REV_ANY_ID, HVERSION_ANY_ID, 0x00071 }, /* 53c700 */
	{ HPHW_FIO, HVERSION_REV_ANY_ID, HVERSION_ANY_ID, 0x00082 }, /* 53c710 */
	{ 0, }
};

MODULE_DEVICE_TABLE(parisc, lasi_scsi_tbl);

static struct parisc_driver lasi_scsi_driver = {
	name:		"Lasi SCSI",
	id_table:	lasi_scsi_tbl,
	probe:		lasi_scsi_callback,
};

int lasi7xx_detect(Scsi_Host_Template *tpnt)
{
	/* "pass" the parameter to the callback functions */
	hosts_tptr = tpnt;
	hosts_used = 0;

	/* This will cause *all* known devices which match entries
	** in lasi_scsi_drivers[] to get invoked and registered.
	*/
	register_parisc_driver(&lasi_scsi_driver);

	/*
	** Check if any callbacks actually found/claimed anything.
	*/
	return (hosts_used != 0);
}
