/*=============================================================================
author        :Walter Schreppers
filename      :lexer.h
description   :Split an input stream up into tokens, eat up white space and
               comments and keep track of row and column
bugreport(log):column will not be incremented enough when numbers are read
=============================================================================*/
/*
    This program is free software; you can redistribute it and/or
    modify it under the terms of version 2 of the GNU General Public
    License as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
 
#ifndef _LEXER_H_
#define _LEXER_H_

#include "number.h"

using namespace std;

enum types {
  
  tokIf=-40,
  tokElse,
  tokWhile,
  tokFor,
  tokTo,
  tokStep,
  tokNumber,
  tokString,
  tokId,
  tokProcId,
  tokBegin,
  tokEnd,
    
  tokOr,
  tokAnd,
  tokNot,
  
  tokGe,
  tokGt,
  tokLe,
  tokLt,
  tokNe,
  tokEq,
  tokAssign,

  tokReturn,
  tokBreak,

  tokForEach,
  tokIn,
    
  tokRun,
  tokEof,
  tokError,
  
  tokLearn,
  
  tokClear,
  tokGo,
  tokGoX,
  tokGoY,
  tokForward,
  tokBackward,
  tokDirection,
  tokTurnLeft,
  tokTurnRight,
  tokCenter,
  tokSetPenWidth,
  tokPenUp,
  tokPenDown,
  tokSetFgColor,
  tokSetBgColor,
  tokResizeCanvas,
  tokSpriteShow,
  tokSpriteHide,
  tokSpritePress,
  tokSpriteChange,
  
  tokDo, // this is a dummy command

  tokMessage,
  tokInputWindow,
  tokPrint,
  tokFontType,
  tokFontSize,
  tokRepeat,
  tokRandom,
  tokWait,
  tokWrapOn,
  tokWrapOff,
  tokReset
  
};


struct token {
  Number  val;
  QString str;
  int     type;
};


class Lexer {
  
  public:
    
    //constructor and destructor
    //==========================
    Lexer( QTextIStream& );
    ~Lexer();
    QString translateCommand(QString s);
  
    //public members
    //==============
    token lex(); //return token
    unsigned int getRow();
    unsigned int getCol();
    
    
  private:
    
    //private members
    //===============
    QChar getChar();
    void ungetChar(QChar);
    void skipComment();
    void skipWhite();
    void getKeywords();
    void checkKeywords(token&);
    int getNumber(Number&);
    int getName(QString&);
    void getStringConstant(token& t);

    typedef QMap<QString, QString> StringMap;
    StringMap KeyMap;
    StringMap AliasMap;
      
    //private locals
    //==============
    QTextIStream* in;
    unsigned int row,col,prevCol;
	QChar putBackChar;
};


#endif // _LEXER_H_


