/* $Id: netwatch.cc,v 1.6 2000/04/15 14:12:33 bergo Exp $ */

/*

    GPS - Graphical Process Statistics
    Copyright (C) 1999-2000 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netinet/in.h>
#include <gtk/gtk.h>
#include <gtk/gtkinvisible.h> /* gtk 1.2.1 lacks this inclusion 
                                 (it's so invisible that even gtk.h
                                  didn't see it... :) ) */
#include "transient.h"
#include "netwatch.h"
#include "polling.h"
#include "netpolling.h"
#include "diefast.h"
#include "gps.h"
#include "msgbox.h"
#include "history.h"
#include "tstring.h"
#include "importglobals.h"

#include "pixmaps/landho.xpm"

GList *hostlist_float=NULL;
GtkWidget *nwdlg,*pl,*toggle_button,*remove_button;
WatchedHost *current_selection=NULL;

static char yesno[2][5]={"Yes","No"};
static char conn_state[3][10]={"-","OK","FAILED"};

void netwatch_config(GtkWidget * widget,gpointer data) {
  GtkWidget *v1,*h1,*h2,*h3,*sw,*lb1,*cmd[10],*sep,*h4,
    *ch1,*ch2;
  int i;
  GList *pt;
  WatchedHost *wh;
  
  current_selection=NULL;
  
  /* some garbage collection */
  if (hostlist_float!=NULL) {
    for(pt=hostlist_float;pt!=NULL;pt=g_list_next(pt))
      delete((WatchedHost *)(pt->data));
    g_list_free(hostlist_float);
  }
  /* copy hostlist_fixed to ...float */
  hostlist_float=NULL;
  for(pt=hostlist_fixed;pt!=NULL;pt=g_list_next(pt)) {
    wh=new WatchedHost();
    wh->copy((WatchedHost *)(pt->data));
    hostlist_float=g_list_append(hostlist_float,wh);
  }
  
  /* ok, real interface handling now */
  nwdlg=gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_transient_for(GTK_WINDOW(nwdlg),MainWindow);
  gtk_window_set_position(GTK_WINDOW(nwdlg),GTK_WIN_POS_CENTER);
  gtk_widget_realize(nwdlg);
  gtk_window_set_policy(GTK_WINDOW(nwdlg),TRUE,TRUE,TRUE);
  gtk_widget_set_usize(nwdlg,400,300);
  gtk_window_set_title(GTK_WINDOW(nwdlg),"Network Watch Setup");
  gtk_container_set_border_width(GTK_CONTAINER(nwdlg),4);
  
  v1=gtk_vbox_new(FALSE,2);
  gtk_container_add(GTK_CONTAINER(nwdlg),v1);
  
  /* label */ 
  h1=gtk_hbox_new(FALSE,0);
  gtk_box_pack_start(GTK_BOX(v1),h1,FALSE,TRUE,0);
  
  lb1=gtk_label_new("Remote hosts to watch:");
  gtk_box_pack_start(GTK_BOX(h1),lb1,FALSE,TRUE,0);
  
  /* host list */
  sw=gtk_scrolled_window_new(NULL,NULL);
  gtk_box_pack_start(GTK_BOX(v1),sw,TRUE,TRUE,4);
  gtk_widget_realize(sw);
  gtk_container_set_border_width(GTK_CONTAINER(sw),0);
  
  pl=gtk_clist_new(4);
  gtk_clist_set_shadow_type(GTK_CLIST(pl),GTK_SHADOW_IN);
  gtk_clist_set_selection_mode(GTK_CLIST(pl),GTK_SELECTION_SINGLE);
  gtk_clist_set_column_title(GTK_CLIST(pl),0,"Host");
  gtk_clist_set_column_title(GTK_CLIST(pl),1,"Port");
  gtk_clist_set_column_title(GTK_CLIST(pl),2,"Enabled");
  gtk_clist_set_column_title(GTK_CLIST(pl),3,"Connection");
  gtk_clist_column_titles_passive(GTK_CLIST(pl));
  gtk_clist_column_titles_show(GTK_CLIST(pl));
 
  gtk_clist_set_column_width(GTK_CLIST(pl),0,170);
  gtk_clist_set_column_width(GTK_CLIST(pl),1,40);
  gtk_clist_set_column_width(GTK_CLIST(pl),2,60);
  gtk_clist_set_column_width(GTK_CLIST(pl),3,60);
  
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(sw),
				 GTK_POLICY_AUTOMATIC,
				 GTK_POLICY_ALWAYS);
  gtk_container_add(GTK_CONTAINER(sw),pl);
  
  /* commands */ 
  h2=gtk_hbox_new(TRUE,8);
  gtk_box_pack_start(GTK_BOX(v1),h2,FALSE,TRUE,2);
  
  h3=gtk_hbox_new(TRUE,8);
  gtk_box_pack_start(GTK_BOX(v1),h3,FALSE,TRUE,2);
  
  sep=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v1),sep,FALSE,TRUE,2);
  
  h4=gtk_hbox_new(TRUE,2);
  gtk_box_pack_start(GTK_BOX(v1),h4,FALSE,TRUE,2);
  
  ch1=gtk_hbox_new(TRUE,2);
  gtk_box_pack_start(GTK_BOX(h4),ch1,FALSE,TRUE,2);
  
  ch2=gtk_hbox_new(TRUE,8);
  gtk_box_pack_start(GTK_BOX(h4),ch2,FALSE,TRUE,2);
  
  cmd[0]=gtk_button_new_with_label("Add host");
  gtk_box_pack_start(GTK_BOX(h2),cmd[0],FALSE,TRUE,0);
  
  remove_button=cmd[1]=gtk_button_new_with_label("Remove host");
  gtk_box_pack_start(GTK_BOX(h2),cmd[1],FALSE,TRUE,0);
  
  cmd[2]=gtk_button_new_with_label("Remove all");
  gtk_box_pack_start(GTK_BOX(h2),cmd[2],FALSE,TRUE,0);
  
  toggle_button=cmd[3]=gtk_button_new_with_label("Enable/Disable");
  gtk_box_pack_start(GTK_BOX(h3),cmd[3],FALSE,TRUE,0);
  
  cmd[4]=gtk_button_new_with_label("Enable all");
  gtk_box_pack_start(GTK_BOX(h3),cmd[4],FALSE,TRUE,0);
  
  cmd[5]=gtk_button_new_with_label("Disable all");
  gtk_box_pack_start(GTK_BOX(h3),cmd[5],FALSE,TRUE,0);
  
  
  cmd[6]=gtk_button_new_with_label("Ok");
  gtk_box_pack_start(GTK_BOX(ch2),cmd[6],FALSE,TRUE,0);
  
  cmd[7]=gtk_button_new_with_label("Cancel");
  gtk_box_pack_start(GTK_BOX(ch2),cmd[7],FALSE,TRUE,0);
  
  cmd[8]=gtk_button_new_with_label("Help");
  gtk_box_pack_start(GTK_BOX(ch2),cmd[8],FALSE,TRUE,0);
  
  gtk_widget_set_sensitive(toggle_button,FALSE);
  gtk_widget_set_sensitive(remove_button,FALSE);
  
  gtk_signal_connect(GTK_OBJECT(cmd[0]),"clicked",
		     GTK_SIGNAL_FUNC(netwatch_add_host),NULL);
  gtk_signal_connect(GTK_OBJECT(cmd[1]),"clicked",
		     GTK_SIGNAL_FUNC(remove_netwatch),NULL);
  gtk_signal_connect(GTK_OBJECT(cmd[2]),"clicked",
		     GTK_SIGNAL_FUNC(remove_all_netwatch),NULL);

  gtk_signal_connect(GTK_OBJECT(cmd[3]),"clicked",
		     GTK_SIGNAL_FUNC(toggle_netwatch),NULL);
  gtk_signal_connect(GTK_OBJECT(cmd[4]),"clicked",
		     GTK_SIGNAL_FUNC(enable_all_netwatch),NULL);
  gtk_signal_connect(GTK_OBJECT(cmd[5]),"clicked",
		     GTK_SIGNAL_FUNC(disable_all_netwatch),NULL);
  
  
  gtk_signal_connect(GTK_OBJECT(cmd[6]),"clicked",
		     GTK_SIGNAL_FUNC(ok_netwatch),NULL);  
  gtk_signal_connect(GTK_OBJECT(cmd[7]),"clicked",
		     GTK_SIGNAL_FUNC(cancel_netwatch),NULL);
  gtk_signal_connect(GTK_OBJECT(cmd[8]),"clicked",
		     GTK_SIGNAL_FUNC(help_netwatch),NULL);

  gtk_signal_connect (GTK_OBJECT(pl),"select_row",
		      GTK_SIGNAL_FUNC(netwatch_select),NULL);
  gtk_signal_connect (GTK_OBJECT(pl),"unselect_row",
		      GTK_SIGNAL_FUNC(netwatch_deselect),NULL);
  
  gtk_widget_show(v1);
  gtk_widget_show(lb1);
  gtk_widget_show(h1);
  
  gtk_widget_show(sw);
  gtk_widget_show(pl);
  
  for(i=0;i<9;i++)
    gtk_widget_show(cmd[i]);
  
  gtk_widget_show(h2);
  gtk_widget_show(h3);
  
  gtk_widget_show(h4);
  gtk_widget_show(ch1);
  gtk_widget_show(ch2);
  
  gtk_widget_show(sep);
  
  gtk_widget_show(nwdlg);
  gtk_grab_add(nwdlg);
  
  update_netwatch_hostlist();
}

GtkWidget *nhdlg;

void help_netwatch(GtkWidget *wid, gpointer data) {
  GtkWidget *v1,*h[36],*t[36],*dis,*sep,*bh;
  int i;
  char buffer[1024];
  char *p;
  GtkStyle *style;
  GdkPixmap *land;
  GdkBitmap *mask;
  GtkWidget *landp;  
  TString *oot;

  nhdlg=gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_transient_for(GTK_WINDOW(nhdlg),GTK_WINDOW(nwdlg));
  gtk_window_set_position(GTK_WINDOW(nhdlg),GTK_WIN_POS_CENTER);
  gtk_widget_realize(nhdlg);
  gtk_window_set_policy(GTK_WINDOW(nhdlg),TRUE,TRUE,TRUE);
  gtk_window_set_title(GTK_WINDOW(nhdlg),"Network Watch Help");
  gtk_container_set_border_width(GTK_CONTAINER(nhdlg),5);

  style=gtk_widget_get_style(nhdlg);
  land=gdk_pixmap_create_from_xpm_d(nhdlg->window,&mask,
				    &style->bg[GTK_STATE_NORMAL],
				    (gchar **)landho_xpm);
  landp=gtk_pixmap_new(land,mask);
  
  v1=gtk_vbox_new(FALSE,0);
  gtk_container_add(GTK_CONTAINER(nhdlg),v1);

  gtk_box_pack_start(GTK_BOX(v1),landp,FALSE,FALSE,0);

  strcpy(buffer,PRE_NETWATCHHELP);
  strcat(buffer,WDOC);
  strcat(buffer,MID_NETWATCHHELP);
  strcat(buffer,GPS_RELEASE);
  strcat(buffer,POS_NETWATCHHELP);
  oot=new TString(1024);
  oot->set(buffer);
  p=oot->token("\n");
  for(i=0;p!=NULL;i++,p=oot->token("\n")) {
    h[i]=gtk_hbox_new(FALSE,2);
    t[i]=gtk_label_new(p);
    gtk_box_pack_start(GTK_BOX(v1),h[i],FALSE,TRUE,0);
    gtk_box_pack_start(GTK_BOX(h[i]),t[i],FALSE,TRUE,0);
    gtk_widget_show(t[i]);
    gtk_widget_show(h[i]);
  }
  delete oot;
  sep=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v1),sep,FALSE,TRUE,2);
  
  bh=gtk_hbox_new(FALSE,2);
  gtk_box_pack_start(GTK_BOX(v1),bh,FALSE,TRUE,2);

  dis=gtk_button_new_with_label(" Dismiss ");
  gtk_box_pack_end(GTK_BOX(bh),dis,FALSE,FALSE,2);

  gtk_signal_connect(GTK_OBJECT(dis),"clicked",
		     GTK_SIGNAL_FUNC(netwatch_help_dismiss),NULL);

  gtk_widget_show(dis);
  gtk_widget_show(landp);
  gtk_widget_show(bh);
  gtk_widget_show(sep);
  gtk_widget_show(v1);
  gtk_widget_show(nhdlg);
  gtk_grab_add(nhdlg);
}

void netwatch_help_dismiss(GtkWidget *widget,gpointer data) {
  gtk_grab_remove(nhdlg);
  gtk_widget_destroy(nhdlg);
}

void ok_netwatch(GtkWidget *wid,gpointer data) {
  GList *pt;
  WatchedHost *wh;
  int a;

  a=0;
  if (hdlg!=NULL) {
    a=message_box(GTK_WINDOW(nwdlg),
		  ASK_CLEAR_HISTORY,
		  "Question",
		  MSGBOX_YESNO,
		  MSGBOX_ICON_QUESTION);
    if (a==MSGBOX_R_NO)
      return;
    a=1;
    close_history(NULL,NULL);
    while(gtk_events_pending()) gtk_main_iteration(); // force end of timeout
    usleep(1000*250);
  }

  gtk_grab_remove(nwdlg);
  gtk_widget_destroy(nwdlg);

  /* some garbage collection */
  if (hostlist_fixed!=NULL) {
    for(pt=hostlist_fixed;pt!=NULL;pt=g_list_next(pt))
      delete((WatchedHost *)(pt->data));
    g_list_free(hostlist_fixed);
  }
  /* copy hostlist_float to ...fixed */
  hostlist_fixed=NULL;
  for(pt=hostlist_float;pt!=NULL;pt=g_list_next(pt)) {
    wh=new WatchedHost();
    wh->copy((WatchedHost *)(pt->data));
    if (!(wh->enable))
      wh->attached_poller=NULL;
    hostlist_fixed=g_list_append(hostlist_fixed,wh);
  }

  refresh();
  write_rc();
  netwatch_update();

  if (a)
    pop_history(NULL,NULL);
}

void cancel_netwatch(GtkWidget *wid,gpointer data) {
  gtk_grab_remove(nwdlg);
  gtk_widget_destroy(nwdlg);
}

void toggle_netwatch(GtkWidget *wid,gpointer data) {
  if (current_selection==NULL) return;
  current_selection->enable=1-current_selection->enable;
  update_netwatch_hostlist();
}

void enable_all_netwatch(GtkWidget *wid,gpointer data) {
  GList *pt;
  WatchedHost *wh;
  for(pt=hostlist_float;pt!=NULL;pt=g_list_next(pt)) {
    wh=(WatchedHost *)(pt->data);
    wh->enable=TRUE;
  }
  update_netwatch_hostlist();
}

void disable_all_netwatch(GtkWidget *wid,gpointer data) {
  GList *pt;
  WatchedHost *wh;
  for(pt=hostlist_float;pt!=NULL;pt=g_list_next(pt)) {
    wh=(WatchedHost *)(pt->data);
    wh->enable=FALSE;
  }
  update_netwatch_hostlist();
}

void remove_all_netwatch(GtkWidget *wid,gpointer data) {
  GList *pt;
  WatchedHost *wh;
  for(pt=hostlist_float;pt!=NULL;pt=g_list_next(pt))
    delete((WatchedHost *)(pt->data));
  g_list_free(hostlist_float);
  hostlist_float=NULL;
  current_selection=NULL;
  gtk_widget_set_sensitive(toggle_button,FALSE);
  gtk_widget_set_sensitive(remove_button,FALSE);
  update_netwatch_hostlist();
}

void remove_netwatch(GtkWidget *wid,gpointer data) {
  if (current_selection==NULL) return;
  hostlist_float=g_list_remove(hostlist_float,current_selection);
  delete(current_selection);
  current_selection=NULL;
  gtk_widget_set_sensitive(toggle_button,FALSE);
  gtk_widget_set_sensitive(remove_button,FALSE);
  update_netwatch_hostlist();
}

void netwatch_select(GtkWidget *widget,gint row,gint column,
		     GdkEventButton *event,gpointer data) {
  GList *pt;
  int i;

  current_selection=NULL;
  for(i=0,pt=hostlist_float;pt!=NULL;pt=g_list_next(pt),i++)
    if (i==row) {
      current_selection=(WatchedHost *)pt->data;
      break;
    }

  if (current_selection==NULL) return;

  gtk_widget_set_sensitive(toggle_button,TRUE);
  gtk_widget_set_sensitive(remove_button,TRUE);

  if (event!=NULL)
    if (event->type==GDK_2BUTTON_PRESS) {
      current_selection->enable=1-current_selection->enable;
      update_netwatch_hostlist();
    }
}

void netwatch_deselect(GtkWidget *widget,gint row,gint column,
		       GdkEventButton *event,gpointer data) {
  gtk_widget_set_sensitive(toggle_button,FALSE);
  gtk_widget_set_sensitive(remove_button,FALSE);
  current_selection=NULL;
}

void update_netwatch_hostlist() {
  GList *pt;
  gchar *p[4];
  char b[32];
  WatchedHost *wh;
  int i;

  gtk_clist_freeze(GTK_CLIST(pl));
  gtk_clist_clear(GTK_CLIST(pl));

  for(i=0,pt=hostlist_float;pt!=NULL;pt=g_list_next(pt),i++) {
    wh=(WatchedHost *)(pt->data);
    p[0]=wh->hostname;
    p[2]=(wh->enable)?yesno[0]:yesno[1];
    
    sprintf(b,"%d",wh->tcpport);
    p[1]=b;

    if (wh->attached_poller==NULL) {
      p[3]=conn_state[0];
    } else {
      if (wh->attached_poller->isOk())
	p[3]=conn_state[1];
      else
	p[3]=conn_state[2];
    }

    gtk_clist_append(GTK_CLIST(pl),(gchar **)p);
    if (current_selection!=NULL)
      if (current_selection==wh)
	gtk_clist_select_row(GTK_CLIST(pl),i,0);
  }

  gtk_clist_thaw(GTK_CLIST(pl));
}

/*******************/
/*                 */
/* add host dialog */
/*                 */
/*******************/

GtkWidget *ahdlg,*hnentry,*portentry;

void netwatch_add_host(GtkWidget *widget, gpointer data) {
  GtkWidget *v1,*h1,*l1,*sep,*h2,*bok,*bca,*inv,*l2,*h3;

  ahdlg=gtk_window_new(GTK_WINDOW_DIALOG);
  gtk_window_set_transient_for(GTK_WINDOW(ahdlg),GTK_WINDOW(nwdlg));
  gtk_widget_realize(ahdlg);
  gtk_window_set_policy(GTK_WINDOW(ahdlg),TRUE,TRUE,TRUE);
  // gtk_widget_set_usize(ahdlg,160,90);
  gtk_window_set_title(GTK_WINDOW(ahdlg),"Network Watch Setup");
  gtk_container_set_border_width(GTK_CONTAINER(ahdlg),4);
  
  v1=gtk_vbox_new(FALSE,2);
  gtk_container_add(GTK_CONTAINER(ahdlg),v1);
  
  h1=gtk_hbox_new(TRUE,2);
  gtk_box_pack_start(GTK_BOX(v1),h1,FALSE,TRUE,1);
  l1=gtk_label_new("Hostname (or IP address) to add:");
  gtk_box_pack_start(GTK_BOX(h1),l1,FALSE,TRUE,1);
  
  hnentry=gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(v1),hnentry,FALSE,TRUE,2);
  
  h3=gtk_hbox_new(FALSE,2);
  gtk_box_pack_start(GTK_BOX(v1),h3,FALSE,TRUE,1);

  l2=gtk_label_new("TCP port:");
  gtk_box_pack_start(GTK_BOX(h3),l2,FALSE,TRUE,1);

  portentry=gtk_entry_new();
  gtk_entry_set_text(GTK_ENTRY(portentry),RGPSP_PORT);
  gtk_box_pack_start(GTK_BOX(h3),portentry,FALSE,TRUE,2);

  sep=gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(v1),sep,FALSE,TRUE,3);
  
  h2=gtk_hbox_new(TRUE,20);
  gtk_box_pack_start(GTK_BOX(v1),h2,FALSE,TRUE,0);
  
  bok=gtk_button_new_with_label("Ok");
  bca=gtk_button_new_with_label("Cancel");
  inv=gtk_invisible_new();
  
  gtk_box_pack_start(GTK_BOX(h2),inv,FALSE,TRUE,0);
  gtk_box_pack_start(GTK_BOX(h2),bok,FALSE,TRUE,2);
  gtk_box_pack_start(GTK_BOX(h2),bca,FALSE,TRUE,2);
  
  gtk_signal_connect(GTK_OBJECT(bok),"clicked",
		     GTK_SIGNAL_FUNC(netwatch_addhost_ok),NULL);
  gtk_signal_connect(GTK_OBJECT(bca),"clicked",
		     GTK_SIGNAL_FUNC(netwatch_addhost_cancel),NULL);
  
  gtk_widget_show(inv);
  gtk_widget_show(bok);
  gtk_widget_show(bca);
  gtk_widget_show(h2);
  gtk_widget_show(sep);
  gtk_widget_show(hnentry);
  gtk_widget_show(l1);
  gtk_widget_show(l2);
  gtk_widget_show(h3);
  gtk_widget_show(portentry);
  gtk_widget_show(h1);
  gtk_widget_show(v1);
  gtk_widget_show(ahdlg);
  
  gtk_widget_grab_focus(hnentry);
  gtk_grab_add(ahdlg);
}

void netwatch_addhost_ok(GtkWidget *widget,gpointer data) {
  WatchedHost *wh;
  int i,j;
  int pn;

  pn=atoi(gtk_entry_get_text(GTK_ENTRY(portentry)));
  wh=new WatchedHost(gtk_entry_get_text(GTK_ENTRY(hnentry)),pn,TRUE);
  hostlist_float=g_list_append(hostlist_float,(gpointer)wh);

  /* thou shall not put spaces in hostnames!!! */
  j=strlen(wh->hostname);
  for(i=0;i<j;i++)
    if (wh->hostname[i]==' ')
      wh->hostname[i]='_';

  gtk_grab_remove(ahdlg);
  gtk_widget_destroy(ahdlg);

  update_netwatch_hostlist();

  /* I should do a gethostent here... */
  if ((strcmp(wh->hostname,this_host)==0)||
     (strcmp(wh->hostname,"localhost")==0)||
      (strcmp(wh->hostname,"127.0.0.1")==0)) {
    message_box(GTK_WINDOW(nwdlg),
		WARN_INCLUDE_SELF,
		"Warning",
		MSGBOX_OK,
		MSGBOX_ICON_EXCLAMATION);
  }
}

void netwatch_addhost_cancel(GtkWidget *widget,gpointer data) {
  gtk_grab_remove(ahdlg);
  gtk_widget_destroy(ahdlg);
}

/*********************/
/*                   */
/* WatchedHost class */
/*                   */
/*********************/

WatchedHost::WatchedHost() {
  hostname[0]=0;
  tcpport=0;
  enable=FALSE;
  attached_poller=NULL;
}

WatchedHost::WatchedHost(char *hn,int port,int en) {
  strncpy(hostname,hn,128);
  hostname[127]=0;
  enable=en;
  tcpport=port;
  attached_poller=NULL;
}

WatchedHost::WatchedHost(FILE *f) {
  char *p;
  char buffer[1024];
  TString *t;

  hostname[0]=0;
  tcpport=atoi(RGPSP_PORT);
  enable=FALSE;

  fgets(buffer,1024,f);
  t=new TString(1024);
  t->set(buffer);
  p=t->token(" \n\t");
  if (strcmp(p,"HOSTENTRY")!=0) {
    delete t;
    return;
  }
  strcpy(hostname,t->token(" \n\t"));

  p=t->token(" \n\t");
  tcpport=atoi(p);

  p=t->token(" \n\t");
  if (p[0]=='0')
    enable=FALSE;
  else
    enable=TRUE;
  attached_poller=NULL;
  delete t;
}

void WatchedHost::write(FILE *f) {
  fprintf(f,"HOSTENTRY %s %d %s\n",
	  hostname,tcpport,(enable?"1":"0"));
}

void WatchedHost::copy(WatchedHost *c) {
  strcpy(hostname,c->hostname);
  enable=c->enable;
  tcpport=c->tcpport;
  attached_poller=c->attached_poller;
}

/* real action */

void netwatch_init() {
  GList *pt;
  WatchedHost *wh;
  NetworkListPoller *nlp;
  NetworkDetailsPoller *ndp;
  NetworkSystemInfoProvider *nsip;
  gint mustfix;

  mustfix=gotgui;
  if (mustfix)
    freeze_timeouts();

  watch_count=0;
  listwatch=NULL;
  detailswatch=NULL;
  sysinfowatch=NULL;
  for(pt=hostlist_fixed;pt!=NULL;pt=g_list_next(pt)) {
    wh=(WatchedHost *)(pt->data);
    if (wh->enable) {
      if (net_halt_request) break;
      nlp=new NetworkListPoller(wh->hostname,wh->tcpport);
      wh->attached_poller=nlp;
      listwatch=g_list_append(listwatch,(gpointer)nlp); /* LIST */

      if (net_halt_request) break;
      if (!nlp->isOk())
	nettimeout=1;

      ndp=new NetworkDetailsPoller(wh->hostname,wh->tcpport);
      detailswatch=g_list_append(detailswatch,(gpointer)ndp); /* DETAILS */

      if (net_halt_request) break;
      if (!ndp->isOk())
	nettimeout=1;

      nsip=new NetworkSystemInfoProvider(wh->hostname,wh->tcpport);
      sysinfowatch=g_list_append(sysinfowatch,(gpointer)nsip); /* CPU/MEM */

      nettimeout=DEFAULT_NET_TIMEOUT;
      watch_count++;
    }
  }

  if (net_halt_request) {
    gtk_label_set_text(GTK_LABEL(status_label[1]),
		       "Network activity aborted by user.");
    net_halt_request=0;
  }

  if (mustfix)
    unfreeze_timeouts();

  if (gotgui)
    stop_wheel();
}

void netwatch_update() {
  while(!enter_mutex()) usleep(430);
  netwatch_destroy();
  netwatch_init();
  exit_mutex();
  refresh();
}

void netwatch_destroy() {
  GList *pt;  

  if (listwatch==NULL) {
    watch_count=0;
    return;
  }

  /* list */
  for(pt=listwatch;pt!=NULL;pt=g_list_next(pt)) {
    ((NetworkListPoller *)(pt->data))->terminate();
    delete((NetworkListPoller *)(pt->data));
  }
  g_list_free(listwatch);
  listwatch=NULL;

  /* details */
  for(pt=detailswatch;pt!=NULL;pt=g_list_next(pt)) {
    ((NetworkDetailsPoller *)(pt->data))->terminate();
    delete((NetworkDetailsPoller *)(pt->data));
  }
  g_list_free(detailswatch);
  detailswatch=NULL;

  /* cpu/mem */
  for(pt=sysinfowatch;pt!=NULL;pt=g_list_next(pt)) {
    ((NetworkSystemInfoProvider *)(pt->data))->terminate();
    delete((NetworkSystemInfoProvider *)(pt->data));
  }
  g_list_free(sysinfowatch);
  sysinfowatch=NULL;

  watch_count=0;
}

void netwatch_restart(GtkWidget *widget,gpointer data) {
  int a;
  if (listwatch==NULL) {
    message_box(MainWindow,
		INFO_NONE_REMOTE,
		"Nothing to do",MSGBOX_OK,
		MSGBOX_ICON_INFO);
    return;
  }

  a=0;
  if (hdlg!=NULL) {
    a=message_box(MainWindow,
		  ASK_CLEAR_HISTORY2,
		  "Question",
		  MSGBOX_YESNO,
		  MSGBOX_ICON_QUESTION);
    if (a==MSGBOX_R_NO)
      return;
    a=1;
    close_history(NULL,NULL);
    while(gtk_events_pending()) gtk_main_iteration(); // force end of timeout
    usleep(1000*250);
  }

  netwatch_update();

  if (a)
    pop_history(NULL,NULL);
}
