/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

#ifndef __GGV_WINDOW_H__
#define __GGV_WINDOW_H__

#include <gdk/gdk.h>
#include <gtk/gtkwidget.h>
#include "crop.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

enum {
        TOGGLE_CURRENT_PAGE = -1,
        TOGGLE_EVEN_PAGES = -2,
        TOGGLE_ODD_PAGES = -3,
        TOGGLE_ALL_PAGES = -4,
        UNMARK_ALL_PAGES = -5,
};

enum {
        TARGET_URI_LIST,
};

typedef struct _window_with_data window_with_data;
typedef struct _ggv_window ggv_window;
typedef struct _ggv_prefs ggv_prefs;

/* global variables */
extern GdkCursor *pan_cursor;
extern GList     *window_list;
extern int       active_ggv;
extern ggv_prefs prefs_dialog;
extern GList     *recent_files_list;

/* prototypes */
gboolean load_gs(ggv_window *ggv, char *fname);
ggv_window *create_ggv_window(void);
void create_sidebar(ggv_window *retval);
void create_menus(ggv_window *retval, window_with_data *temp);
void create_popup_menus(ggv_window *ggv);
void open_window(gchar *filename);
void close_window(ggv_window *ggv);
void set_gs_prefs(ggv_window *ggv);
void apply_gs_prefs(GList *windows);
void open_prefs_dialog(ggv_prefs *pd);
void goto_page(ggv_window *ggv, int page);
void set_page_sensitivities(ggv_window *ggv, int page);
void flash_message(ggv_window *ggv, gchar *flash);
void error_message(ggv_window *ggv, gchar *errormsg);
void toggle_pages(ggv_window *ggv, gint what_to_toggle, gint page_number);
void save_marked_pages(ggv_window *ggv, gchar *file);

struct _window_with_data {
        ggv_window *ggv;
        gpointer data;
};

struct _ggv_window {
        GtkWidget *main_window;
	GtkWidget *pagelistscroll;
        GtkWidget *pagelist;
        GtkWidget *coordinates;
        GtkWidget *scrollpane;
        GtkWidget *popup_menu;
        GtkWidget *sidebar;
        GtkWidget *file_sel;
        GtkWidget *save_file_sel;
        GtkWidget *appbar;
        GtkObject *hadj, *vadj;
        GtkWidget *gs;
        gboolean show_menus, show_panel;
        gboolean loaded;
        gboolean pan;
        gboolean pane_auto_jump;	/* ...to top of new page */
        gdouble prev_x, prev_y;
        gchar *startup_file;
        crop_data *cd;
        gint zoom_magstep;
        window_with_data menudata[16];

        /* store some pointers to widgets from GnomeUIInfo trees here
           as we need them for setting sensitivity and stuff like that */
        GtkWidget *nextbutton, *nextitem, *nextpu;  /* next button, menu item and popup menu item */
        GtkWidget *prevbutton, *previtem, *prevpu;  /* prev ... */
        GtkWidget *printitem, *reloaditem;          /* menu items... */
        GtkWidget *save;
        /*        GtkWidget *saveas; */
        GtkWidget *printmarked;
        GtkWidget *zoominbutton;                    /* zoom buttons */
        GtkWidget *zoomoutbutton;
        GtkWidget *panel_vis, *menus_vis;           /* menu/side panel visibility check items in menus */
        GtkWidget *panel_vis_pu, *menus_vis_pu;     /* and in popup menu */
 	GtkWidget *toggleakt, *toggleall,           /* (un)mark pages */
 	          *toggleeven, *toggleodd, *clearall,
 	          *toggleakt_pu, *toggleall_pu,
 	          *toggleeven_pu, *toggleodd_pu, *clearall_pu;
        guint num_recent;                           /* Recent menu has been intantiated? so we can
                                                       remove it before we add new entries */
};

struct _ggv_prefs
{
        GnomePropertyBox *pbox;
        GtkWidget *gs, *scan_pdf, *uncompress, *print; /* entries */
        GtkWidget *media;                              /* option menus */
        GtkWidget *aa, *override_media;                /* checkbuttons */
        GtkWidget *tbar, *mbar, *auto_jump;            /* checkbuttons */
        GtkWidget *media_choice[PAPER_SIZE_COUNT];     /* menu items */
};

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif
