%a 4000
%o 8000
%k 100
%n 100
%p 500
%e 200

WHITESPACE	[ \t]
COMMENT		[\#]
COLON		[\:]
COMMA		[\,]
EQUALS		[\=]
EOL		[\n]
EOR		[\;]
QSTRING		[\"][^\"]*[\"]
STRING		[A-Za-z0-9\-_\.\@\?\*\/\$]+

%%

{WHITESPACE}++	{ /* Eat whitespace */	}
{COMMENT}[^\n]*	{ /* Eat comments   */	}
{EOL}		{ line_count++;  	}
{EQUALS}	{ return	EQUALS; }
{COLON}		{ return	COLON; 	}
{COMMA}		{ return	COMMA;	}
{EOR}		{ return	EOR;	}
appletype       { return        APPLETYPE; }
charset		{ return	CHARSET;}
textenc         { return        TEXTENC;}
henc            { return        HENC;   }
format		{ return	FORMAT; }
bin		{ return	BIN; 	}
group		{ return	GROUP;	}
member		{ return	MEMBER; }
match		{ return	MATCH;  }
mailer		{ return	MAILER;  }
localhostname	{ return	HOSTNAME;  }

{QSTRING}	{ int	qstringlen;
		  yylval.string	= strcpy(Yalloc(strlen(&yytext[1])+1),
					 &yytext[1]);
		  qstringlen	= strlen(yylval.string);
		  yylval.string[qstringlen-1]	= 0;
		  return	QSTRING;
		}

{STRING}	{ yylval.string = strcpy(Yalloc(strlen(yytext)+1),yytext);
		  return	STRING; 
		}

%%
