'''
   This plugin provides a compatibility layer which turns new-style
   POSIX entries into old-style entries.
'''
__revision__ = '$Revision: 5484 $'

import Bcfg2.Server.Plugin

COMPAT_DICT = {'file': 'ConfigFile',
               'device': 'device',
               'directory': 'Directory',
               'nonexistent': 'nonexistent',
               'permissions': 'Permissions',
               'symlink': 'SymLink'}


class POSIXCompat(Bcfg2.Server.Plugin.Plugin,
             Bcfg2.Server.Plugin.GoalValidator):
    name = 'POSIXCompat'
    __version__ = '$Id: POSIXCompat.py 5484 2009-10-16 03:07:12Z solj $'
    __author__ = 'bcfg-dev@mcs.anl.gov'

    def __init__(self, core, datastore):
        Bcfg2.Server.Plugin.Plugin.__init__(self, core, datastore)
        Bcfg2.Server.Plugin.GoalValidator.__init__(self)

    def validate_goals(self, metadata, goals):
        for goal in goals:
            for entry in goal.getchildren():
                if entry.tag == 'Path' and \
                   entry.get('type') not in ['nonexistent', 'device']:
                    oldentry = entry
                    entry.tag = COMPAT_DICT[entry.get('type')]
                    del entry.attrib['type']
                    # FIXME: use another attribute? old clients only
                    #        know about type=None
                    #entry.set('type', 'POSIXCompat')
                    goal.replace(oldentry, entry)
