#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
# 
# Test tree constructs.
#
# $Id: tree.py,v 1.7 2003/09/21 04:40:31 djc Exp $

import unittest
import albatross
import albatross_test

one_we_prepared_earlier="""\
-a
 |-b
 | |-c
 | \-d
 \-e
   |-f
   | \-g
   |   |-h
   |   \-i
   |-j
   \-k
     |-l
     \-m
"""

tree_input_folded="""\
<form action="here">
 <table>
  <tr>
    <td width="16">
      <input type="image" src="close.png" width="13" height="13" border="0" name="treefold,n,a" /></td>
    <td width="16"><input type="checkbox" name="treeselect,n,a" value="on" /></td>
    <td colspan="999" nowrap>a</td>
   </tr>
  </table>
<input type="hidden" name="__albform__" value="eJwDAAAAAAE=
" />
</form>"""

tree_input_unfolded="""\
<form action="here">
 <table>
  <tr>
    <td width="16">
      <input type="image" src="open.png" width="13" height="13" border="0" name="treefold,n,a" /></td>
    <td width="16"><input type="checkbox" name="treeselect,n,a" value="on" /></td>
    <td colspan="999" nowrap>a</td>
   </tr>
  <tr>
    <td width="16" colspan="1" nowrap></td>
    <td width="16">
      <input type="image" src="close.png" width="13" height="13" border="0" name="treefold,n,b" /></td>
    <td width="16"><input type="checkbox" name="treeselect,n,b" value="on" /></td>
    <td colspan="999" nowrap>b</td>
   </tr>
  <tr>
    <td width="16" colspan="1" nowrap></td>
    <td width="16">
      <input type="image" src="open.png" width="13" height="13" border="0" name="treefold,n,e" /></td>
    <td width="16"><input type="checkbox" name="treeselect,n,e" value="on" /></td>
    <td colspan="999" nowrap>e</td>
   </tr>
  <tr>
    <td width="16" colspan="2" nowrap></td>
    <td width="16">
      <input type="image" src="close.png" width="13" height="13" border="0" name="treefold,n,f" /></td>
    <td width="16"><input type="checkbox" name="treeselect,n,f" value="on" /></td>
    <td colspan="999" nowrap>f</td>
   </tr>
  <tr>
    <td width="16" colspan="2" nowrap></td>
    <td width="16" nowrap></td>
    <td width="16"><input type="checkbox" name="treeselect,n,j" value="on" /></td>
    <td colspan="999" nowrap>j</td>
   </tr>
  <tr>
    <td width="16" colspan="2" nowrap></td>
    <td width="16">
      <input type="image" src="close.png" width="13" height="13" border="0" name="treefold,n,k" /></td>
    <td width="16"><input type="checkbox" name="treeselect,n,k" value="on" /></td>
    <td colspan="999" nowrap>k</td>
   </tr>
  </table>
<input type="hidden" name="__albform__" value="eJwDAAAAAAE=
" />
</form>"""

tree_input_unfolded_selected="""\
<form action="here">
 <table>
  <tr>
    <td width="16">
      <input type="image" src="open.png" width="13" height="13" border="0" name="treefold,n,a" /></td>
    <td width="16"><input type="checkbox" name="treeselect,n,a" value="on" /></td>
    <td colspan="999" nowrap>a</td>
   </tr>
  <tr>
    <td width="16" colspan="1" nowrap></td>
    <td width="16">
      <input type="image" src="close.png" width="13" height="13" border="0" name="treefold,n,b" /></td>
    <td width="16"><input type="checkbox" name="treeselect,n,b" value="on" checked /></td>
    <td colspan="999" nowrap>b</td>
   </tr>
  <tr>
    <td width="16" colspan="1" nowrap></td>
    <td width="16">
      <input type="image" src="open.png" width="13" height="13" border="0" name="treefold,n,e" /></td>
    <td width="16"><input type="checkbox" name="treeselect,n,e" value="on" /></td>
    <td colspan="999" nowrap>e</td>
   </tr>
  <tr>
    <td width="16" colspan="2" nowrap></td>
    <td width="16">
      <input type="image" src="close.png" width="13" height="13" border="0" name="treefold,n,f" /></td>
    <td width="16"><input type="checkbox" name="treeselect,n,f" value="on" /></td>
    <td colspan="999" nowrap>f</td>
   </tr>
  <tr>
    <td width="16" colspan="2" nowrap></td>
    <td width="16" nowrap></td>
    <td width="16"><input type="checkbox" name="treeselect,n,j" value="on" checked /></td>
    <td colspan="999" nowrap>j</td>
   </tr>
  <tr>
    <td width="16" colspan="2" nowrap></td>
    <td width="16">
      <input type="image" src="close.png" width="13" height="13" border="0" name="treefold,n,k" /></td>
    <td width="16"><input type="checkbox" name="treeselect,n,k" value="on" /></td>
    <td colspan="999" nowrap>k</td>
   </tr>
  </table>
<input type="hidden" name="__albform__" value="eJwDAAAAAAE=
" />
</form>"""

class SimpleNode:
    def __init__(self, name, children = None):
        self.name = name
        if children is not None:
            self.children = children

class LazyNode:
    def __init__(self, name, children = None):
        self.name = name
        if children is not None:
            self.unloaded_children = children
            self.children = []
        self.children_loaded = 0

    def load_children(self,ctx):
        self.children = self.unloaded_children

    def albatross_alias(self):
        return self.name

def build_tree(Ctor):
    return Ctor('a', [Ctor('b', [Ctor('c'),
                                 Ctor('d')]),
                      Ctor('e', [Ctor('f', [Ctor('g', [Ctor('h'),
                                                       Ctor('i')])]),
                                 Ctor('j'),
                                 Ctor('k', [Ctor('l'),
                                            Ctor('m')])])])

class TreeCase(albatross_test.AlbatrossTestCase):
    template_dir = "tree"

    def check_tree(self):
        self.ctx.locals.tree = build_tree(SimpleNode)
        self.html_test("tree.html", one_we_prepared_earlier)

    def check_tree_lazy(self):
        self.ctx.locals.tree = build_tree(LazyNode)
        self.html_test("tree-lazy.html", "-a\n")
        self.ctx.locals.n.set_backdoor('treefold','a',1)
        self.html_test("tree-lazy.html", "-a\n |-b\n \-e\n")

    def check_tree_input(self):
        self.ctx.locals.tree = build_tree(LazyNode)
        self.html_test("tree-input.html", tree_input_folded)
        self.ctx.locals.n.set_backdoor('treefold','a',1)
        self.ctx.locals.n.set_backdoor('treefold','e',1)
        self.html_test("tree-input.html", tree_input_unfolded)
        self.ctx.locals.n.set_backdoor('treeselect','b',1)
        self.ctx.locals.n.set_backdoor('treeselect','j',1)
        self.html_test("tree-input.html", tree_input_unfolded_selected)


class TreeSuite(unittest.TestSuite):
    test_list = (
        "check_tree",
        "check_tree_lazy",
        "check_tree_input",
    )
    def __init__(self):
        unittest.TestSuite.__init__(self, map(TreeCase, self.test_list))

def suite():
    return TreeSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='suite')
