#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
#
# Basic functionality tests - save and restore a single context
#
# $Id: basic.py,v 1.3 2002/07/30 07:33:51 andrewm Exp $
#

import unittest

import ses_file
import ses_server
import ses_hiddenfield

class BasicCase:
    def runTest(self):

        test_str = "Green Eggs and Ham"

        session = self.new_session()

        ctx = session.new_context()
        ctx.load_session()
        self.assertEqual(ctx.locals.__dict__, {})
        ctx.locals.test_var = test_str
        ctx.add_session_vars('test_var')
        ctx.test_save()

        ctx = session.new_context()
        ctx.load_session()
        self.assertEqual(ctx.locals.__dict__.keys(), ['test_var'])
        self.assertEqual(ctx.locals.test_var, test_str)


class FileBasicCase(ses_file.FileCase, BasicCase):
    pass

class ServerBasicCase(ses_server.ServerCase, BasicCase):
    pass

class HiddenFieldBasicCase(ses_hiddenfield.HiddenFieldCase, BasicCase):
    pass


class BasicCase(unittest.TestCase):
    def check_file(self):
        self.test_saverestore(ses_file.Session())

    def check_server(self):
        self.test_saverestore(ses_server.Session())

    def check_hiddenfield(self):
        self.test_saverestore(ses_hiddenfield.Session())


class BasicSuite(unittest.TestSuite):
    test_list = [
        FileBasicCase(),
        ServerBasicCase(),
        HiddenFieldBasicCase(),
    ]

    def __init__(self):
        unittest.TestSuite.__init__(self, self.test_list)

def suite():
    return BasicSuite()

if __name__ == '__main__':
    unittest.main(defaultTest='BasicSuite')
