#
# Copyright 2001 by Object Craft P/L, Melbourne, Australia.
#
# LICENCE - see LICENCE file distributed with this software for details.
#
import cgi
import sys
import os
from albatross.common import *
from albatross.request import RequestBase


class Request(RequestBase):

    def __init__(self, fields = None):
        if fields is None:
            fields = cgi.FieldStorage()
        RequestBase.__init__(self, fields)

    def get_uri(self):
        return os.environ.get('REQUEST_URI')

    def get_method(self):
        return os.environ.get('REQUEST_METHOD')

    def get_path_info(self):
        return os.environ.get('PATH_INFO')

    def get_servername(self):
        return os.environ.get('HTTP_HOST')

    def get_header(self, name):
        env_name = 'HTTP_' + name.upper().replace('-', '_')
        return os.environ.get(env_name)

    def write_header(self, name, value):
        sys.stdout.write('%s: %s\n' % (name, value))

    def end_headers(self):
        status = self.status()
        if status != HTTP_OK:
            self.write_header('Status', http_status_string(status))
        sys.stdout.write('\n')

    def redirect(self, loc):
        self.set_status(HTTP_MOVED_PERMANENTLY)
        self.write_header('Location', loc)
        self.end_headers()

    def write_content(self, data):
        sys.stdout.write(data)
        sys.stdout.flush()
