/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.sql;

import java.io.IOException;
import java.sql.Array;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.JDBCStream;
import org.apache.solr.handler.sql.CalciteSolrDriver;

public class CalciteJDBCStream
extends JDBCStream {
    private static final long serialVersionUID = 1L;

    public CalciteJDBCStream(String connectionUrl, String sqlQuery, StreamComparator definedSort, Properties connectionProperties, String driverClassName) throws IOException {
        super(connectionUrl, sqlQuery, definedSort, connectionProperties, driverClassName);
    }

    protected JDBCStream.ResultSetValueSelector determineValueSelector(int columnIdx, ResultSetMetaData metadata) throws SQLException {
        JDBCStream.ResultSetValueSelector valueSelector = super.determineValueSelector(columnIdx, metadata);
        if (valueSelector == null) {
            final int columnNumber = columnIdx + 1;
            final String columnName = metadata.getColumnLabel(columnNumber);
            String className = metadata.getColumnClassName(columnNumber);
            if (Array.class.getName().equals(className)) {
                valueSelector = new JDBCStream.ResultSetValueSelector(){

                    public Object selectValue(ResultSet resultSet) throws SQLException {
                        Object o = resultSet.getObject(columnNumber);
                        if (resultSet.wasNull()) {
                            return null;
                        }
                        if (o instanceof Array) {
                            Array array = (Array)o;
                            return array.getArray();
                        }
                        return o;
                    }

                    public String getColumnName() {
                        return columnName;
                    }
                };
            }
        }
        return valueSelector;
    }

    protected Driver getDriver() {
        return CalciteSolrDriver.INSTANCE;
    }
}

