/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.ThreadSafe;
import ucar.nc2.dataset.TransformType;
import ucar.unidata.util.Parameter;

@ThreadSafe
public class CoordinateTransform
implements Comparable<CoordinateTransform> {
    protected final String name;
    protected final String authority;
    protected final TransformType transformType;
    protected List<Parameter> params;
    private volatile int hashCode = 0;

    public CoordinateTransform(String name, String authority, TransformType transformType) {
        this.name = name;
        this.authority = authority;
        this.transformType = transformType;
        this.params = new ArrayList<Parameter>();
    }

    public void addParameter(Parameter param) {
        this.params.add(param);
    }

    public String getName() {
        return this.name;
    }

    public String getAuthority() {
        return this.authority;
    }

    public TransformType getTransformType() {
        return this.transformType;
    }

    public List<Parameter> getParameters() {
        return this.params;
    }

    public Parameter findParameterIgnoreCase(String name) {
        for (Parameter a : this.params) {
            if (!name.equalsIgnoreCase(a.getName())) continue;
            return a;
        }
        return null;
    }

    public boolean equals(Object oo) {
        if (this == oo) {
            return true;
        }
        if (!(oo instanceof CoordinateTransform)) {
            return false;
        }
        CoordinateTransform o = (CoordinateTransform)oo;
        if (!this.getName().equals(o.getName())) {
            return false;
        }
        if (!this.getAuthority().equals(o.getAuthority())) {
            return false;
        }
        if (this.getTransformType() != o.getTransformType()) {
            return false;
        }
        List<Parameter> oparams = o.getParameters();
        if (this.params.size() != oparams.size()) {
            return false;
        }
        for (int i = 0; i < this.params.size(); ++i) {
            Parameter att = this.params.get(i);
            Parameter oatt = oparams.get(i);
            if (att.getName().equals(oatt.getName())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.getName().hashCode();
            result = 37 * result + this.getAuthority().hashCode();
            result = 37 * result + this.getTransformType().hashCode();
            for (Parameter att : this.params) {
                result = 37 * result + att.getName().hashCode();
            }
            this.hashCode = result;
        }
        return this.hashCode;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(CoordinateTransform oct) {
        return this.name.compareTo(oct.getName());
    }
}

