/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.RequestUrlParamsEncoder;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class HttpJsonServerStreamingRequestParamCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> callable;
    private final RequestUrlParamsEncoder<RequestT> paramsEncoder;

    HttpJsonServerStreamingRequestParamCallable(ServerStreamingCallable<RequestT, ResponseT> callable, RequestParamsExtractor<RequestT> paramsExtractor) {
        this.callable = (ServerStreamingCallable)Preconditions.checkNotNull(callable);
        this.paramsEncoder = new RequestUrlParamsEncoder((RequestParamsExtractor)Preconditions.checkNotNull(paramsExtractor));
    }

    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        ApiCallContext newCallContext = context;
        String encodedHeader = this.paramsEncoder.encode(request);
        if (!encodedHeader.isEmpty()) {
            newCallContext = HttpJsonCallContext.createDefault().nullToSelf(context).withExtraHeaders((Map<String, List<String>>)ImmutableMap.of((Object)"x-goog-request-params", (Object)ImmutableList.of((Object)encodedHeader)));
        }
        this.callable.call(request, responseObserver, newCallContext);
    }
}

