/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Arrays;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.SQLUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.Datum;

class BooleanBinder
extends Binder {
    int paramVal;
    Binder theBooleanCopyingBinder = null;

    BooleanBinder(int x) {
        BooleanBinder.init(this);
        this.paramVal = x;
    }

    static void init(Binder x) {
        x.type = (short)252;
        x.bytelen = 4;
    }

    @Override
    Binder copyingBinder() {
        if (this.theBooleanCopyingBinder == null) {
            this.theBooleanCopyingBinder = new BooleanBinder(this.paramVal);
        }
        return this.theBooleanCopyingBinder;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] b = bindBytes;
        int offset = byteoffset + 1;
        int val = this.paramVal;
        int len = 0;
        long pos = 0L;
        if (bindUseDBA) {
            bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
            stmt.lastBoundDataOffsets[bindPosition] = pos;
            bindDataOffsets[bindDataIndex] = bindData.getPosition();
            b = stmt.connection.methodTempLittleByteBuffer;
            offset = 0;
        } else {
            b = bindBytes;
            offset = byteoffset + 1;
        }
        len = this.getDatumBytes(stmt, val, b, offset);
        bindIndicators[indoffset] = 0;
        bindIndicators[lenoffset] = (short)(len + 1);
        bindData.put(b, 0, len);
        bindDataLengths[bindDataIndex] = len;
        return localCheckSum;
    }

    private int getDatumBytes(OraclePreparedStatement stmt, int val, byte[] b, int offset) throws SQLException {
        int len;
        if (val != 0) {
            b[offset] = 1;
            b[offset + 1] = 1;
            len = 2;
        } else {
            b[offset] = 0;
            len = 1;
        }
        return len;
    }

    @Override
    Datum getDatum(OraclePreparedStatement stmt, int bindPosition, int formOfUse, int internalType) throws SQLException {
        byte[] b = stmt.connection.methodTempLittleByteBuffer;
        int len = this.getDatumBytes(stmt, this.paramVal, b, 0);
        return SQLUtil.makeDatum((OracleConnection)stmt.connection, Arrays.copyOf(b, len), internalType, null, 0);
    }
}

