/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.coordinator.group.api.assignor.SubscribedTopicDescriber;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.metadata.BrokerRegistration;
import org.apache.kafka.metadata.PartitionRegistration;

public class SubscribedTopicDescriberImpl
implements SubscribedTopicDescriber {
    private final MetadataImage metadataImage;

    public SubscribedTopicDescriberImpl(MetadataImage metadataImage) {
        this.metadataImage = Objects.requireNonNull(metadataImage);
    }

    public int numPartitions(Uuid topicId) {
        TopicImage topicImage = this.metadataImage.topics().getTopic(topicId);
        return topicImage == null ? -1 : topicImage.partitions().size();
    }

    public Set<String> racksForPartition(Uuid topicId, int partition) {
        PartitionRegistration partitionRegistration;
        TopicImage topic = this.metadataImage.topics().getTopic(topicId);
        if (topic != null && (partitionRegistration = (PartitionRegistration)topic.partitions().get(partition)) != null) {
            HashSet racks = new HashSet();
            for (int replica : partitionRegistration.replicas) {
                BrokerRegistration brokerRegistration = this.metadataImage.cluster().broker(replica);
                if (brokerRegistration == null) continue;
                brokerRegistration.rack().ifPresent(racks::add);
            }
            return Collections.unmodifiableSet(racks);
        }
        return Set.of();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscribedTopicDescriberImpl that = (SubscribedTopicDescriberImpl)o;
        return this.metadataImage.equals((Object)that.metadataImage);
    }

    public int hashCode() {
        return Objects.hashCode(this.metadataImage);
    }

    public String toString() {
        return "SubscribedTopicMetadata(metadataImage=" + String.valueOf(this.metadataImage) + ")";
    }
}

