/*
 * Decompiled with CFR 0.152.
 */
package java.util.stream;

import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Spliterator;
import java.util.concurrent.CountedCompleter;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.AbstractShortCircuitTask;
import java.util.stream.PipelineHelper;
import java.util.stream.Sink;
import java.util.stream.StreamOpFlag;
import java.util.stream.StreamShape;
import java.util.stream.TerminalOp;
import java.util.stream.TerminalSink;

final class FindOps {
    private FindOps() {
    }

    public static <T> TerminalOp<T, Optional<T>> makeRef(boolean bl) {
        return new FindOp(bl, StreamShape.REFERENCE, Optional.empty(), Optional::isPresent, FindSink.OfRef::new);
    }

    public static TerminalOp<Integer, OptionalInt> makeInt(boolean bl) {
        return new FindOp<Integer, OptionalInt>(bl, StreamShape.INT_VALUE, OptionalInt.empty(), OptionalInt::isPresent, FindSink.OfInt::new);
    }

    public static TerminalOp<Long, OptionalLong> makeLong(boolean bl) {
        return new FindOp<Long, OptionalLong>(bl, StreamShape.LONG_VALUE, OptionalLong.empty(), OptionalLong::isPresent, FindSink.OfLong::new);
    }

    public static TerminalOp<Double, OptionalDouble> makeDouble(boolean bl) {
        return new FindOp<Double, OptionalDouble>(bl, StreamShape.DOUBLE_VALUE, OptionalDouble.empty(), OptionalDouble::isPresent, FindSink.OfDouble::new);
    }

    private static final class FindTask<P_IN, P_OUT, O>
    extends AbstractShortCircuitTask<P_IN, P_OUT, O, FindTask<P_IN, P_OUT, O>> {
        private final FindOp<P_OUT, O> op;

        FindTask(FindOp<P_OUT, O> findOp, PipelineHelper<P_OUT> pipelineHelper, Spliterator<P_IN> spliterator) {
            super(pipelineHelper, spliterator);
            this.op = findOp;
        }

        FindTask(FindTask<P_IN, P_OUT, O> findTask, Spliterator<P_IN> spliterator) {
            super(findTask, spliterator);
            this.op = findTask.op;
        }

        @Override
        protected FindTask<P_IN, P_OUT, O> makeChild(Spliterator<P_IN> spliterator) {
            return new FindTask<P_IN, P_OUT, O>(this, spliterator);
        }

        @Override
        protected O getEmptyResult() {
            return this.op.emptyValue;
        }

        private void foundResult(O o) {
            if (this.isLeftmostNode()) {
                this.shortCircuit(o);
            } else {
                this.cancelLaterNodes();
            }
        }

        @Override
        protected O doLeaf() {
            Object t = ((TerminalSink)this.helper.wrapAndCopyInto((Sink)this.op.sinkSupplier.get(), this.spliterator)).get();
            if (!this.op.mustFindFirst) {
                if (t != null) {
                    this.shortCircuit(t);
                }
                return null;
            }
            if (t != null) {
                this.foundResult(t);
                return (O)t;
            }
            return null;
        }

        @Override
        public void onCompletion(CountedCompleter<?> countedCompleter) {
            if (this.op.mustFindFirst) {
                FindTask findTask = (FindTask)this.leftChild;
                FindTask findTask2 = null;
                while (findTask != findTask2) {
                    Object r = findTask.getLocalResult();
                    if (r != null && this.op.presentPredicate.test(r)) {
                        this.setLocalResult(r);
                        this.foundResult(r);
                        break;
                    }
                    findTask2 = findTask;
                    findTask = (FindTask)this.rightChild;
                }
            }
            super.onCompletion(countedCompleter);
        }
    }

    private static abstract class FindSink<T, O>
    implements TerminalSink<T, O> {
        boolean hasValue;
        T value;

        FindSink() {
        }

        @Override
        public void accept(T t) {
            if (!this.hasValue) {
                this.hasValue = true;
                this.value = t;
            }
        }

        @Override
        public boolean cancellationRequested() {
            return this.hasValue;
        }

        static final class OfDouble
        extends FindSink<Double, OptionalDouble>
        implements Sink.OfDouble {
            OfDouble() {
            }

            @Override
            public void accept(double d) {
                this.accept(Double.valueOf(d));
            }

            @Override
            public OptionalDouble get() {
                return this.hasValue ? OptionalDouble.of((Double)this.value) : null;
            }
        }

        static final class OfLong
        extends FindSink<Long, OptionalLong>
        implements Sink.OfLong {
            OfLong() {
            }

            @Override
            public void accept(long l) {
                this.accept(Long.valueOf(l));
            }

            @Override
            public OptionalLong get() {
                return this.hasValue ? OptionalLong.of((Long)this.value) : null;
            }
        }

        static final class OfInt
        extends FindSink<Integer, OptionalInt>
        implements Sink.OfInt {
            OfInt() {
            }

            @Override
            public void accept(int n) {
                this.accept(Integer.valueOf(n));
            }

            @Override
            public OptionalInt get() {
                return this.hasValue ? OptionalInt.of((Integer)this.value) : null;
            }
        }

        static final class OfRef<T>
        extends FindSink<T, Optional<T>> {
            OfRef() {
            }

            @Override
            public Optional<T> get() {
                return this.hasValue ? Optional.of(this.value) : null;
            }
        }
    }

    private static final class FindOp<T, O>
    implements TerminalOp<T, O> {
        private final StreamShape shape;
        final boolean mustFindFirst;
        final O emptyValue;
        final Predicate<O> presentPredicate;
        final Supplier<TerminalSink<T, O>> sinkSupplier;

        FindOp(boolean bl, StreamShape streamShape, O o, Predicate<O> predicate, Supplier<TerminalSink<T, O>> supplier) {
            this.mustFindFirst = bl;
            this.shape = streamShape;
            this.emptyValue = o;
            this.presentPredicate = predicate;
            this.sinkSupplier = supplier;
        }

        @Override
        public int getOpFlags() {
            return StreamOpFlag.IS_SHORT_CIRCUIT | (this.mustFindFirst ? 0 : StreamOpFlag.NOT_ORDERED);
        }

        @Override
        public StreamShape inputShape() {
            return this.shape;
        }

        @Override
        public <S> O evaluateSequential(PipelineHelper<T> pipelineHelper, Spliterator<S> spliterator) {
            Object t = ((TerminalSink)pipelineHelper.wrapAndCopyInto((Sink)this.sinkSupplier.get(), spliterator)).get();
            return (O)(t != null ? t : this.emptyValue);
        }

        @Override
        public <P_IN> O evaluateParallel(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator) {
            return (O)new FindTask(this, pipelineHelper, spliterator).invoke();
        }
    }
}

