// Generated by gmmproc 2.86.0 -- DO NOT MODIFY!
#ifndef _GDKMM_MEMORYTEXTURE_H
#define _GDKMM_MEMORYTEXTURE_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2020 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gdkmm/texture.h>
#include <glibmm/bytes.h>
#include <gdk/gdk.h> // For GDK_MEMORY_DEFAULT


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GdkMemoryTexture = struct _GdkMemoryTexture;
using GdkMemoryTextureClass = struct _GdkMemoryTextureClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gdk
{ class GDKMM_API MemoryTexture_Class; } // namespace Gdk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gdk
{
/** A Gdk::Texture representing image data in memory.
 *
 * @newin{3,98}
 */

class GDKMM_API MemoryTexture : public Gdk::Texture
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = MemoryTexture;
  using CppClassType = MemoryTexture_Class;
  using BaseObjectType = GdkMemoryTexture;
  using BaseClassType = GdkMemoryTextureClass;

  // noncopyable
  MemoryTexture(const MemoryTexture&) = delete;
  MemoryTexture& operator=(const MemoryTexture&) = delete;

private:  friend class MemoryTexture_Class;
  static CppClassType memorytexture_class_;

protected:
  explicit MemoryTexture(const Glib::ConstructParams& construct_params);
  explicit MemoryTexture(GdkMemoryTexture* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  MemoryTexture(MemoryTexture&& src) noexcept;
  MemoryTexture& operator=(MemoryTexture&& src) noexcept;

  ~MemoryTexture() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdkMemoryTexture*       gobj()       { return reinterpret_cast<GdkMemoryTexture*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdkMemoryTexture* gobj() const { return reinterpret_cast<GdkMemoryTexture*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdkMemoryTexture* gobj_copy();

private:


protected:
  MemoryTexture();

public:
  //TODO: When we can break API/ABI, remove MemoryTexture::Format and replace
  // it by MemoryFormat. MemoryTexture::Format became problematic when
  // Texture::get_format() was added to the base class.
  /** @addtogroup gdkmmEnums gdkmm Enums and Flags */

  /**  @enum Format
   * Prefer Gdk::MemoryFormat to %Gdk::MemoryTexture::Format where possible.
   *
   * %Gdk::MemoryFormat and %Gdk::MemoryTexture::Format are identical.
   * It's possible to convert between them with static_cast.
   *  @var Format::B8G8R8A8_PREMULTIPLIED
   * 4 bytes; for blue, green, red, alpha.
   * The color values are premultiplied with the alpha value.
   * 
   *  @var Format::A8R8G8B8_PREMULTIPLIED
   * 4 bytes; for alpha, red, green, blue.
   * The color values are premultiplied with the alpha value.
   * 
   *  @var Format::R8G8B8A8_PREMULTIPLIED
   * 4 bytes; for red, green, blue, alpha
   * The color values are premultiplied with the alpha value.
   * 
   *  @var Format::B8G8R8A8
   * 4 bytes; for blue, green, red, alpha.
   * 
   *  @var Format::A8R8G8B8
   * 4 bytes; for alpha, red, green, blue.
   * 
   *  @var Format::R8G8B8A8
   * 4 bytes; for red, green, blue, alpha.
   * 
   *  @var Format::A8B8G8R8
   * 4 bytes; for alpha, blue, green, red.
   * 
   *  @var Format::R8G8B8
   * 3 bytes; for red, green, blue. The data is opaque.
   * 
   *  @var Format::B8G8R8
   * 3 bytes; for blue, green, red. The data is opaque.
   * 
   *  @var Format::N_FORMATS
   * The number of formats. This value will change as
   * more formats get added, so do not rely on its concrete integer.
   * 
   *  @var Format::R32G32B32_FLOAT
   * 3 float values; for red, green, blue.
   * 
   *  @var Format::A8B8G8R8_PREMULTIPLIED
   * 4 bytes; for alpha, blue, green, red, The color values are premultiplied with
   * the alpha value.
   * 
   * @newin{4,14}
   * 
   *  @var Format::B8G8R8X8
   * 4 bytes; for blue, green, red, unused.
   * 
   * @newin{4,14}
   * 
   *  @var Format::X8R8G8B8
   * 4 bytes; for unused, red, green, blue.
   * 
   * @newin{4,14}
   * 
   *  @var Format::R8G8B8X8
   * 4 bytes; for red, green, blue, unused.
   * 
   * @newin{4,14}
   * 
   *  @var Format::X8B8G8R8
   * 4 bytes; for unused, blue, green, red.
   * 
   * @newin{4,14}
   * 
   *  @var Format::R16G16B16
   * 3 guint16 values; for red, green, blue.
   * 
   * @newin{4,6}
   * 
   *  @var Format::R16G16B16A16_PREMULTIPLIED
   * 4 guint16 values; for red, green, blue, alpha. The color values are
   * premultiplied with the alpha value.
   * 
   * @newin{4,6}
   * 
   *  @var Format::R16G16B16A16
   * 4 guint16 values; for red, green, blue, alpha.
   * 
   * @newin{4,6}
   * 
   *  @var Format::R16G16B16_FLOAT
   * 3 half-float values; for red, green, blue. The data is opaque.
   * 
   * @newin{4,6}
   * 
   *  @var Format::R16G16B16A16_FLOAT_PREMULTIPLIED
   * 4 half-float values; for red, green, blue and alpha. The color values are
   * premultiplied with the alpha value.
   * 
   * @newin{4,6}
   * 
   *  @var Format::R16G16B16A16_FLOAT
   * 4 half-float values; for red, green, blue and alpha.
   * 
   * @newin{4,6}
   * 
   *  @var Format::R32G32B32A32_FLOAT_PREMULTIPLIED
   * 4 float values; for red, green, blue and alpha. The color values are
   * premultiplied with the alpha value.
   * 
   * @newin{4,6}
   * 
   *  @var Format::R32G32B32A32_FLOAT
   * 4 float values; for red, green, blue and alpha.
   * 
   * @newin{4,6}
   * 
   *  @var Format::G8A8_PREMULTIPLIED
   * 2 bytes; for grayscale, alpha. The color values are premultiplied with the
   * alpha value.
   * 
   * @newin{4,12}
   * 
   *  @var Format::G8A8
   * 2 bytes; for grayscale, alpha.
   * 
   * @newin{4,12}
   * 
   *  @var Format::G8
   * One byte; for grayscale. The data is opaque.
   * 
   * @newin{4,12}
   * 
   *  @var Format::G16A16_PREMULTIPLIED
   * 2 guint16 values; for grayscale, alpha. The color values are premultiplied
   * with the alpha value.
   * 
   * @newin{4,12}
   * 
   *  @var Format::G16A16
   * 2 guint16 values; for grayscale, alpha.
   * 
   * @newin{4,12}
   * 
   *  @var Format::G16
   * One guint16 value; for grayscale. The data is opaque.
   * 
   * @newin{4,12}
   * 
   *  @var Format::A8
   * One byte; for alpha.
   * 
   * @newin{4,12}
   * 
   *  @var Format::A16
   * One guint16 value; for alpha.
   * 
   * @newin{4,12}
   * 
   *  @var Format::A16_FLOAT
   * One half-float value; for alpha.
   * 
   * @newin{4,12}
   * 
   *  @var Format::A32_FLOAT
   * One float value; for alpha.
   * 
   * @newin{4,12}
   * 
   *  @var Format::G8_B8R8_420
   * Multiplane format with 2 planes.
   * 
   * The first plane contains the first channel, usually containing
   * luma values.
   * The second plane with interleaved chroma values, Cb followed by Cr.
   * Subsampled in both the X and Y direction.
   * 
   * Commonly known by the fourcc "NV12".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_R8B8_420
   * Multiplane format with 2 planes.
   * 
   * The first plane contains the first channel, usually containing
   * luma values.
   * The second plane with interleaved chroma values, Cr followed by Cb.
   * Subsampled in both the X and Y direction.
   * 
   * Commonly known by the fourcc "NV21".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_B8R8_422
   * Multiplane format with 2 planes.
   * 
   * The first plane contains the first channel, usually containing
   * luma values.
   * The second plane with interleaved chroma values, Cb followed by Cr.
   * Subsampled in the X direction.
   * 
   * Commonly known by the fourcc "NV16".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_R8B8_422
   * Multiplane format with 2 planes.
   * 
   * The first plane contains the first channel, usually containing
   * luma values.
   * The second plane with interleaved chroma values, Cr followed by Cb.
   * Subsampled in the X direction.
   * 
   * Commonly known by the fourcc "NV61".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_B8R8_444
   * Multiplane format with 2 planes.
   * 
   * The first plane contains the first channel, usually containing
   * luma values.
   * The second plane with interleaved chroma values, Cb followed by Cr.
   * This format is not subsampled.
   * 
   * Commonly known by the fourcc "NV24".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_R8B8_444
   * Multiplane format with 2 planes.
   * 
   * The first plane contains the first channel, usually containing
   * luma values.
   * The second plane with interleaved chroma values, Cr followed by Cb.
   * This format is not subsampled.
   * 
   * Commonly known by the fourcc "NV42".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G10X6_B10X6R10X6_420
   * Multiplane format with 2 planes.
   * 
   * Each channel is a 16 bit integer, but only the highest 10 bits are used.
   * 
   * The first plane contains the first channel, usually containing
   * luma values.
   * The second plane with interleaved chroma values, Cr followed by Cb.
   * This format is not subsampled.
   * 
   * Commonly known by the fourcc "P010".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G12X4_B12X4R12X4_420
   * Multiplane format with 2 planes.
   * 
   * Each channel is a 16 bit integer, but only the highest 10 bits are used.
   * 
   * The first plane contains the first channel, usually containing
   * luma values.
   * The second plane with interleaved chroma values, Cr followed by Cb.
   * This format is not subsampled.
   * 
   * Commonly known by the fourcc "P012".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G16_B16R16_420
   * Multiplane format with 2 planes.
   * 
   * Each channel is a 16 bit integer.
   * 
   * The first plane contains the first channel, usually containing
   * luma values.
   * The second plane with interleaved chroma values, Cr followed by Cb.
   * This format is not subsampled.
   * 
   * Commonly known by the fourcc "P016".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_B8_R8_410
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 8 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel.
   * Subsampled in both the X and Y direction with 4:1 ratio. It is
   * mapped into the 3rd channel.
   * 
   * The third plane usually contains the second chroma channel.
   * Subsampled in both the X and Y direction with 4:1 ratio. It is
   * mapped into the 1st channel.
   * 
   * Commonly known by the fourcc "YUV410".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_R8_B8_410
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 8 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the second chroma chanel.
   * Subsampled in both the X and Y direction with 4:1 ratio. It is
   * mapped into the 1st channel.
   * 
   * The third plane usually contains the first chroma channel.
   * Subsampled in both the X and Y direction with 4:1 ratio. It is
   * mapped into the 3rd channel.
   * 
   * Commonly known by the fourcc "YVU410".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_B8_R8_411
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 8 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel.
   * Subsampled in the X direction with 4:1 ratio. It is
   * mapped into the 3rd channel.
   * 
   * The third plane usually contains the second chroma channel.
   * Subsampled in the X direction with 4:1 ratio. It is
   * mapped into the 1st channel.
   * 
   * Commonly known by the fourcc "YUV411".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_R8_B8_411
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 8 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the second chroma chanel.
   * Subsampled in the X direction with 4:1 ratio. It is
   * mapped into the 1st channel.
   * 
   * The third plane usually contains the first chroma channel.
   * Subsampled in the X direction with 4:1 ratio. It is
   * mapped into the 3rd channel.
   * 
   * Commonly known by the fourcc "YVU411".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_B8_R8_420
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 8 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel.
   * Subsampled in both the X and Y direction. It is mapped into the
   * 3rd channel.
   * 
   * The third plane usually contains the second chroma channel.
   * Subsampled in both the X and Y direction. It is mapped into the
   * 1st channel.
   * 
   * Commonly known by the fourcc "YUV420".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_R8_B8_420
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 8 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the second chroma chanel.
   * Subsampled in both the X and Y direction. It is mapped into the
   * 1st channel.
   * 
   * The third plane usually contains the first chroma channel.
   * Subsampled in both the X and Y direction. It is mapped into the
   * 3rd channel.
   * 
   * Commonly known by the fourcc "YVU420".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_B8_R8_422
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 8 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel.
   * Subsampled in the X direction. It is mapped into the 3rd channel.
   * 
   * The third plane usually contains the second chroma channel.
   * Subsampled in the X direction. It is mapped into the 1st channel.
   * 
   * Commonly known by the fourcc "YUV422".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_R8_B8_422
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 8 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the second chroma chanel.
   * Subsampled in the X direction. It is mapped into the 1st channel.
   * 
   * The third plane usually contains the first chroma channel.
   * Subsampled in the X direction. It is mapped into the 3rd channel.
   * 
   * Commonly known by the fourcc "YVU422".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_B8_R8_444
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 8 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel. It is
   * mapped into the 3rd channel.
   * 
   * The third plane usually contains the second chroma channel. It is
   * mapped into the 1st channel.
   * 
   * Commonly known by the fourcc "YUV444".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8_R8_B8_444
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 8 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the second chroma chanel.
   * Subsampled in the X direction. It is mapped into the 1st channel.
   * 
   * The third plane usually contains the first chroma channel.
   * Subsampled in the X direction. It is mapped into the 3rd channel.
   * 
   * Commonly known by the fourcc "YVU444".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8B8G8R8_422
   * Packed format with subsampled channels.
   * 
   * Each channel is a 8 bit integer. The red and blue/chroma channels
   * are subsampled and interleaved with the green/luma channel.
   * 
   * Each block contains 2 pixels, so the width must be a multiple of
   * 2.
   * 
   * Commonly known by the fourcc "YUYV".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G8R8G8B8_422
   * Packed format with subsampled channels.
   * 
   * Each channel is a 8 bit integer. The red and blue/chroma channels
   * are subsampled and interleaved with the green/luma channel.
   * 
   * Each block contains 2 pixels, so the width must be a multiple of
   * 2.
   * 
   * Commonly known by the fourcc "YVYU".
   * 
   * @newin{4,20}
   * 
   *  @var Format::R8G8B8G8_422
   * Packed format with subsampled channels.
   * 
   * Each channel is a 8 bit integer. The red and blue/chroma channels
   * are subsampled and interleaved with the green/luma channel.
   * 
   * Each block contains 2 pixels, so the width must be a multiple of
   * 2.
   * 
   * Commonly known by the fourcc "VYUY".
   * 
   * @newin{4,20}
   * 
   *  @var Format::B8G8R8G8_422
   * Packed format with subsampled channels.
   * 
   * Each channel is a 8 bit integer. The red and blue/chroma channels
   * are subsampled and interleaved with the green/luma channel.
   * 
   * Each block contains 2 pixels, so the width must be a multiple of
   * 2.
   * 
   * Commonly known by the fourcc "UYVY".
   * 
   * @newin{4,20}
   * 
   *  @var Format::X6G10_X6B10_X6R10_420
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 16 bit integer.
   * 
   * Only the 10 lower bits are used. The remaining ones must be set to 0 by the
   * producer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel.
   * Subsampled in both the X and Y direction. It is mapped into the
   * 3rd channel.
   * 
   * The third plane usually contains the second chroma channel.
   * Subsampled in both the X and Y direction. It is mapped into the
   * 1st channel.
   * 
   * Commonly known by the fourcc "S010".
   * 
   * @newin{4,20}
   * 
   *  @var Format::X6G10_X6B10_X6R10_422
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 16 bit integer.
   * 
   * Only the 10 lower bits are used. The remaining ones must be set to 0 by the
   * producer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel.
   * Subsampled in the X direction. It is mapped into the 3rd channel.
   * 
   * The third plane usually contains the second chroma channel.
   * Subsampled in the X direction. It is mapped into the 1st channel.
   * 
   * Commonly known by the fourcc "S210".
   * 
   * @newin{4,20}
   * 
   *  @var Format::X6G10_X6B10_X6R10_444
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 16 bit integer.
   * 
   * Only the 10 lower bits are used. The remaining ones must be set to 0 by the
   * producer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel. It is
   * mapped into the 3rd channel.
   * 
   * The third plane usually contains the second chroma channel. It is
   * mapped into the 1st channel.
   * 
   * Commonly known by the fourcc "S410".
   * 
   * @newin{4,20}
   * 
   *  @var Format::X4G12_X4B12_X4R12_420
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 16 bit integer.
   * 
   * Only the 12 lower bits are used. The remaining ones must be set to 0 by the
   * producer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel.
   * Subsampled in both the X and Y direction. It is mapped into the
   * 3rd channel.
   * 
   * The third plane usually contains the second chroma channel.
   * Subsampled in both the X and Y direction. It is mapped into the
   * 1st channel.
   * 
   * Commonly known by the fourcc "S012".
   * 
   * @newin{4,20}
   * 
   *  @var Format::X4G12_X4B12_X4R12_422
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 16 bit integer.
   * 
   * Only the 12 lower bits are used. The remaining ones must be set to 0 by the
   * producer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel.
   * Subsampled in the X direction. It is mapped into the 3rd channel.
   * 
   * The third plane usually contains the second chroma channel.
   * Subsampled in the X direction. It is mapped into the 1st channel.
   * 
   * Commonly known by the fourcc "S212".
   * 
   * @newin{4,20}
   * 
   *  @var Format::X4G12_X4B12_X4R12_444
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 16 bit integer.
   * 
   * Only the 12 lower bits are used. The remaining ones must be set to 0 by the
   * producer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel. It is
   * mapped into the 3rd channel.
   * 
   * The third plane usually contains the second chroma channel. It is
   * mapped into the 1st channel.
   * 
   * Commonly known by the fourcc "S412".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G16_B16_R16_420
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 16 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel.
   * Subsampled in both the X and Y direction. It is mapped into the
   * 3rd channel.
   * 
   * The third plane usually contains the second chroma channel.
   * Subsampled in both the X and Y direction. It is mapped into the
   * 1st channel.
   * 
   * Commonly known by the fourcc "S016".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G16_B16_R16_422
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 16 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel.
   * Subsampled in the X direction. It is mapped into the 3rd channel.
   * 
   * The third plane usually contains the second chroma channel.
   * Subsampled in the X direction. It is mapped into the 1st channel.
   * 
   * Commonly known by the fourcc "S216".
   * 
   * @newin{4,20}
   * 
   *  @var Format::G16_B16_R16_444
   * Multiplane format with 3 planes.
   * 
   * Each channel is a 16 bit integer.
   * 
   * The first plane usually contains the luma channel. It is mapped
   * into the 2nd channel.
   * 
   * The second plane usually contains the first chroma chanel. It is
   * mapped into the 3rd channel.
   * 
   * The third plane usually contains the second chroma channel. It is
   * mapped into the 1st channel.
   * 
   * Commonly known by the fourcc "S416".
   * 
   * @newin{4,20}
   */
   /** Describes formats that image data can have in memory.
   * 
   * It describes formats by listing the contents of the memory passed to it.
   * So `Gdk::MemoryFormat::A8R8G8B8` will be 1 byte (8 bits) of alpha, followed by a
   * byte each of red, green and blue. It is not endian-dependent, so
   * `Cairo::Surface::Format::ARGB32` is represented by different `Gdk::MemoryFormats`
   * on architectures with different endiannesses.
   * 
   * Its naming is modelled after
   * [VkFormat](https://www.khronos.org/registry/vulkan/specs/1.0/html/vkspec.htmlVkFormat)
   * for details).
   *
   * @ingroup gdkmmEnums
   */
  enum class Format
  {
    B8G8R8A8_PREMULTIPLIED,
    A8R8G8B8_PREMULTIPLIED,
    R8G8B8A8_PREMULTIPLIED,
    B8G8R8A8,
    A8R8G8B8,
    R8G8B8A8,
    A8B8G8R8,
    R8G8B8,
    B8G8R8,
    R16G16B16,
    R16G16B16A16_PREMULTIPLIED,
    R16G16B16A16,
    R16G16B16_FLOAT,
    R16G16B16A16_FLOAT_PREMULTIPLIED,
    R16G16B16A16_FLOAT,
    R32G32B32_FLOAT,
    R32G32B32A32_FLOAT_PREMULTIPLIED,
    R32G32B32A32_FLOAT,
    G8A8_PREMULTIPLIED,
    G8A8,
    G8,
    G16A16_PREMULTIPLIED,
    G16A16,
    G16,
    A8,
    A16,
    A16_FLOAT,
    A32_FLOAT,
    A8B8G8R8_PREMULTIPLIED,
    B8G8R8X8,
    X8R8G8B8,
    R8G8B8X8,
    X8B8G8R8,
    G8_B8R8_420,
    G8_R8B8_420,
    G8_B8R8_422,
    G8_R8B8_422,
    G8_B8R8_444,
    G8_R8B8_444,
    G10X6_B10X6R10X6_420,
    G12X4_B12X4R12X4_420,
    G16_B16R16_420,
    G8_B8_R8_410,
    G8_R8_B8_410,
    G8_B8_R8_411,
    G8_R8_B8_411,
    G8_B8_R8_420,
    G8_R8_B8_420,
    G8_B8_R8_422,
    G8_R8_B8_422,
    G8_B8_R8_444,
    G8_R8_B8_444,
    G8B8G8R8_422,
    G8R8G8B8_422,
    R8G8B8G8_422,
    B8G8R8G8_422,
    X6G10_X6B10_X6R10_420,
    X6G10_X6B10_X6R10_422,
    X6G10_X6B10_X6R10_444,
    X4G12_X4B12_X4R12_420,
    X4G12_X4B12_X4R12_422,
    X4G12_X4B12_X4R12_444,
    G16_B16_R16_420,
    G16_B16_R16_422,
    G16_B16_R16_444,
    N_FORMATS
  };


  /** Default memory format used by GTK.
   *
   * It is the format provided by Gdk::Texture::download().
   * It is equal to Cairo::Surface::Format::ARGB32.
   *
   * Be aware that unlike the Format values, this format is
   * different for different endianness.
   */
  static const Format DEFAULT_FORMAT = static_cast<Format>(GDK_MEMORY_DEFAULT);

  // gdk_memory_texture_new() does more than call g_object_new().
  
  /** Creates a new texture for a blob of image data.
   * 
   * The `Glib::Bytes` must contain @a stride × @a height pixels
   * in the given format.
   * 
   * @param width The width of the texture.
   * @param height The height of the texture.
   * @param format The format of the data.
   * @param bytes The `Glib::Bytes` containing the pixel data.
   * @param stride Rowstride for the data.
   * @return A newly-created `Gdk::Texture`.
   */
  static Glib::RefPtr<Texture> create(int width, int height, Format format, const Glib::RefPtr<const Glib::Bytes>& bytes, gsize stride);

  // There are no public signals, properties or vfuncs.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class GDKMM_API Value<Gdk::MemoryTexture::Format> : public Glib::Value_Enum<Gdk::MemoryTexture::Format>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdk::MemoryTexture
   */
  GDKMM_API
  Glib::RefPtr<Gdk::MemoryTexture> wrap(GdkMemoryTexture* object, bool take_copy = false);
}


#endif /* _GDKMM_MEMORYTEXTURE_H */

