/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.contentassist;

import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.UIUtils;

public class SmartTextContentAdapter
extends TextContentAdapter {
    private static final Log log = Log.getLog(UIUtils.class);

    public void insertControlContents(Control control, String contents, int cursorPosition) {
        Text text = (Text)control;
        String curValue = text.getText().toUpperCase();
        Point selection = text.getSelection();
        if (selection.x == selection.y) {
            String contentsUC = contents.toUpperCase();
            int i = selection.x - 1;
            while (i >= 0) {
                String prefix = curValue.substring(i, selection.x);
                if (contentsUC.startsWith(prefix) && selection.x >= i && selection.x < i + contents.length()) {
                    text.setSelection(i, selection.x);
                    break;
                }
                char ch = curValue.charAt(i);
                if (!Character.isLetterOrDigit(ch) && contentsUC.indexOf(ch) == -1) break;
                --i;
            }
        }
        text.insert(contents);
        if (cursorPosition < contents.length()) {
            text.setSelection(selection.x + cursorPosition, selection.x + cursorPosition);
        }
    }
}

