/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.NamedFieldVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;

public class SimilarMemberVisitor
implements MemberVisitor {
    private final Clazz targetClass;
    private final boolean visitThisMember;
    private final boolean visitSuperMembers;
    private final boolean visitInterfaceMembers;
    private final boolean visitOverridingMembers;
    private final MemberVisitor memberVisitor;

    public SimilarMemberVisitor(boolean visitThisMember, boolean visitSuperMembers, boolean visitInterfaceMembers, boolean visitOverridingMembers, MemberVisitor memberVisitor) {
        this(null, visitThisMember, visitSuperMembers, visitInterfaceMembers, visitOverridingMembers, memberVisitor);
    }

    public SimilarMemberVisitor(Clazz targetClass, boolean visitThisMember, boolean visitSuperMembers, boolean visitInterfaceMembers, boolean visitOverridingMembers, MemberVisitor memberVisitor) {
        this.targetClass = targetClass;
        this.visitThisMember = visitThisMember;
        this.visitSuperMembers = visitSuperMembers;
        this.visitInterfaceMembers = visitInterfaceMembers;
        this.visitOverridingMembers = visitOverridingMembers;
        this.memberVisitor = memberVisitor;
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        Clazz targetClass = this.targetClass(programClass);
        targetClass.hierarchyAccept(this.visitThisMember, this.visitSuperMembers, this.visitInterfaceMembers, this.visitOverridingMembers, new NamedFieldVisitor(programField.getName(programClass), programField.getDescriptor(programClass), this.memberVisitor));
    }

    @Override
    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        Clazz targetClass = this.targetClass(libraryClass);
        targetClass.hierarchyAccept(this.visitThisMember, this.visitSuperMembers, this.visitInterfaceMembers, this.visitOverridingMembers, new NamedFieldVisitor(libraryField.getName(libraryClass), libraryField.getDescriptor(libraryClass), this.memberVisitor));
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        Clazz targetClass = this.targetClass(programClass);
        targetClass.hierarchyAccept(this.visitThisMember, this.visitSuperMembers, this.visitInterfaceMembers, this.visitOverridingMembers, new NamedMethodVisitor(programMethod.getName(programClass), programMethod.getDescriptor(programClass), this.memberVisitor));
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        Clazz targetClass = this.targetClass(libraryClass);
        targetClass.hierarchyAccept(this.visitThisMember, this.visitSuperMembers, this.visitInterfaceMembers, this.visitOverridingMembers, new NamedMethodVisitor(libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass), this.memberVisitor));
    }

    private Clazz targetClass(Clazz clazz) {
        return this.targetClass != null ? this.targetClass : clazz;
    }
}

