/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.datatype;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nu.validator.datatype.AbstractDatatype;
import org.relaxng.datatype.DatatypeException;

abstract class AbstractDatetime
extends AbstractDatatype {
    private static int[] DAYS_IN_MONTHS = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final boolean WARN = System.getProperty("nu.validator.datatype.warn", "").equals("true");

    AbstractDatetime() {
    }

    private void checkMonth(String year, String month) throws DatatypeException {
        try {
            this.checkMonth(Integer.parseInt(year), Integer.parseInt(month));
        }
        catch (NumberFormatException e) {
            throw this.newDatatypeException("Year or month out of range.");
        }
    }

    private void checkYear(int year) throws DatatypeException {
        if (year < 1) {
            throw this.newDatatypeException("Year cannot be less than 1.");
        }
        if (WARN && (year < 1000 || year >= 3000)) {
            throw this.newDatatypeException("Year may be mistyped.", WARN);
        }
    }

    private void checkMonth(int year, int month) throws DatatypeException {
        if (month < 1) {
            throw this.newDatatypeException("Month cannot be less than 1.");
        }
        if (month > 12) {
            throw this.newDatatypeException("Month cannot be greater than 12.");
        }
        this.checkYear(year);
    }

    private void checkDate(String year, String month, String day) throws DatatypeException {
        try {
            this.checkDate(Integer.parseInt(year), Integer.parseInt(month), Integer.parseInt(day));
        }
        catch (NumberFormatException e) {
            throw this.newDatatypeException("Year, month, or day out of range.");
        }
    }

    private void checkDate(int year, int month, int day) throws DatatypeException {
        if (month < 1) {
            throw this.newDatatypeException("Month cannot be less than 1.");
        }
        if (month > 12) {
            throw this.newDatatypeException("Month cannot be greater than 12.");
        }
        if (day < 1) {
            throw this.newDatatypeException("Day cannot be less than 1.");
        }
        if (!(day <= DAYS_IN_MONTHS[month - 1] || day == 29 && month == 2 && this.isLeapYear(year))) {
            throw this.newDatatypeException("Day out of range.");
        }
        this.checkYear(year);
    }

    private boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    private void checkYearlessDate(String month, String day) throws DatatypeException {
        try {
            this.checkYearlessDate(Integer.parseInt(month), Integer.parseInt(day));
        }
        catch (NumberFormatException e) {
            throw this.newDatatypeException("Month or day out of range.");
        }
    }

    private void checkYearlessDate(int month, int day) throws DatatypeException {
        if (month < 1) {
            throw this.newDatatypeException("Month cannot be less than 1.");
        }
        if (month > 12) {
            throw this.newDatatypeException("Month cannot be greater than 12.");
        }
        if (day < 1) {
            throw this.newDatatypeException("Day cannot be less than 1.");
        }
    }

    private void checkWeek(String year, String week) throws DatatypeException {
        try {
            this.checkWeek(Integer.parseInt(year), Integer.parseInt(week));
        }
        catch (NumberFormatException e) {
            throw this.newDatatypeException("Year or week out of range.");
        }
    }

    private void checkWeek(int year, int week) throws DatatypeException {
        if (week < 1) {
            throw this.newDatatypeException("Week cannot be less than 1.");
        }
        if (week > 53) {
            throw this.newDatatypeException("Week cannot be greater than 53.");
        }
        this.checkYear(year);
    }

    protected final void checkHour(String hour) throws DatatypeException {
        try {
            this.checkHour(Integer.parseInt(hour));
        }
        catch (NumberFormatException e) {
            throw this.newDatatypeException("Hour out of range.");
        }
    }

    private void checkHour(int hour) throws DatatypeException {
        if (hour > 23) {
            throw this.newDatatypeException("Hour cannot be greater than 23.");
        }
    }

    protected final void checkMinute(String minute) throws DatatypeException {
        try {
            this.checkMinute(Integer.parseInt(minute));
        }
        catch (NumberFormatException e) {
            throw this.newDatatypeException("Minute out of range.");
        }
    }

    private void checkMinute(int minute) throws DatatypeException {
        if (minute > 59) {
            throw this.newDatatypeException("Minute cannot be greater than 59.");
        }
    }

    protected final void checkSecond(String second) throws DatatypeException {
        try {
            this.checkSecond(Integer.parseInt(second));
        }
        catch (NumberFormatException e) {
            throw this.newDatatypeException("Seconds out of range.");
        }
    }

    private void checkSecond(int second) throws DatatypeException {
        if (second > 59) {
            throw this.newDatatypeException("Second cannot be greater than 59.");
        }
    }

    protected final void checkMilliSecond(String millisecond) throws DatatypeException {
        if (millisecond.length() > 3) {
            throw this.newDatatypeException("A fraction of a second must be one, two, or three digits.");
        }
    }

    private void checkTzd(String hours, String minutes) throws DatatypeException {
        boolean offsetIsNegative = false;
        if (hours.charAt(0) == '+') {
            hours = hours.substring(1);
        } else if (hours.charAt(0) == '-') {
            offsetIsNegative = true;
        }
        try {
            this.checkTzd(Integer.parseInt(hours), Integer.parseInt(minutes), offsetIsNegative);
        }
        catch (NumberFormatException e) {
            throw this.newDatatypeException("Hours or minutes out of range.");
        }
    }

    private void checkTzd(int hours, int minutes, boolean offsetIsNegative) throws DatatypeException {
        if (offsetIsNegative && hours == 0 && minutes == 0) {
            throw this.newDatatypeException("Minus sign not allowed in time zone designator when offset is zero. Use plus sign instead.");
        }
        if (hours < -23 || hours > 23) {
            throw this.newDatatypeException("Hours out of range in time zone designator.");
        }
        if (minutes > 59) {
            throw this.newDatatypeException("Minutes out of range in time zone designator.");
        }
        if (WARN) {
            if (hours < -12 || hours > 14) {
                throw this.newDatatypeException("Hours in time zone designator should be from \u201c-12:00\u201d to \u201d+14:00\u201d", WARN);
            }
            if (minutes != 0 && minutes != 30 && minutes != 45) {
                throw this.newDatatypeException("Minutes in time zone designator should be either \u201c00\u201d, \u201c30\u201d, or \u201c45\u201d.", WARN);
            }
        }
    }

    protected abstract Pattern getPattern();

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        Matcher m = this.getPattern().matcher(literal);
        if (m.matches()) {
            String year = m.group(1);
            String month = m.group(2);
            if (year != null) {
                this.checkMonth(year, month);
                return;
            }
            year = m.group(3);
            month = m.group(4);
            String day = m.group(5);
            if (year != null) {
                this.checkDate(year, month, day);
                return;
            }
            month = m.group(6);
            day = m.group(7);
            if (month != null) {
                this.checkYearlessDate(month, day);
                return;
            }
            String hour = m.group(8);
            String minute = m.group(9);
            String seconds = m.group(10);
            String milliseconds = m.group(11);
            if (hour != null) {
                this.checkHour(hour);
                this.checkMinute(minute);
                if (seconds != null) {
                    this.checkSecond(seconds);
                }
                if (milliseconds != null) {
                    this.checkMilliSecond(milliseconds);
                }
                return;
            }
            year = m.group(12);
            month = m.group(13);
            day = m.group(14);
            hour = m.group(15);
            minute = m.group(16);
            seconds = m.group(17);
            milliseconds = m.group(18);
            if (year != null) {
                this.checkDate(year, month, day);
                this.checkHour(hour);
                this.checkMinute(minute);
                if (seconds != null) {
                    this.checkSecond(seconds);
                }
                if (milliseconds != null) {
                    this.checkMilliSecond(milliseconds);
                }
                return;
            }
            String tzdHours = m.group(19);
            String tzdMinutes = m.group(20);
            if (tzdHours != null) {
                this.checkTzd(tzdHours, tzdMinutes);
                return;
            }
            year = m.group(21);
            month = m.group(22);
            day = m.group(23);
            hour = m.group(24);
            minute = m.group(25);
            seconds = m.group(26);
            milliseconds = m.group(27);
            tzdHours = m.group(28);
            tzdMinutes = m.group(29);
            if (year != null) {
                this.checkDate(year, month, day);
                this.checkHour(hour);
                this.checkMinute(minute);
                if (seconds != null) {
                    this.checkSecond(seconds);
                }
                if (milliseconds != null) {
                    this.checkMilliSecond(milliseconds);
                }
                if (tzdHours != null) {
                    this.checkTzd(tzdHours, tzdMinutes);
                }
                return;
            }
            year = m.group(30);
            String week = m.group(31);
            if (year != null) {
                this.checkWeek(year, week);
            }
            if ((year = m.group(32)) != null) {
                try {
                    this.checkYear(Integer.parseInt(year));
                }
                catch (NumberFormatException e) {
                    throw this.newDatatypeException("Year out of range.");
                }
            }
            if ((milliseconds = m.group(33)) != null) {
                this.checkMilliSecond(milliseconds);
                return;
            }
            milliseconds = m.group(34);
            if (milliseconds != null) {
                this.checkMilliSecond(milliseconds);
                return;
            }
        } else {
            throw this.newDatatypeException("The literal did not satisfy the " + this.getName() + " format.");
        }
    }
}

