/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagLayout;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadTaskList;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.progress.swing.PleaseWaitProgressMonitor;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public abstract class DownloadAlongAction
extends JosmAction {
    public DownloadAlongAction(String name, String iconName, String tooltip, Shortcut shortcut, boolean registerInToolbar) {
        super(name, iconName, tooltip, shortcut, registerInToolbar);
    }

    protected static void addToDownload(Area a, Rectangle2D r, Collection<Rectangle2D> results, double maxArea) {
        Area tmp = new Area(r);
        tmp.intersect(a);
        if (tmp.isEmpty()) {
            return;
        }
        Rectangle2D bounds = tmp.getBounds2D();
        if (bounds.getWidth() * bounds.getHeight() > maxArea) {
            Rectangle2D.Double r2;
            Rectangle2D.Double r1;
            if (bounds.getWidth() > bounds.getHeight()) {
                r1 = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth() / 2.0, bounds.getHeight());
                r2 = new Rectangle2D.Double(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY(), bounds.getWidth() / 2.0, bounds.getHeight());
            } else {
                r1 = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight() / 2.0);
                r2 = new Rectangle2D.Double(bounds.getX(), bounds.getY() + bounds.getHeight() / 2.0, bounds.getWidth(), bounds.getHeight() / 2.0);
            }
            DownloadAlongAction.addToDownload(a, r1, results, maxArea);
            DownloadAlongAction.addToDownload(a, r2, results, maxArea);
        } else {
            results.add(bounds);
        }
    }

    protected static void confirmAndDownloadAreas(Area a, double maxArea, boolean osmDownload, boolean gpxDownload, String title, ProgressMonitor progressMonitor) {
        ArrayList<Rectangle2D> toDownload = new ArrayList<Rectangle2D>();
        DownloadAlongAction.addToDownload(a, a.getBounds(), toDownload, maxArea);
        if (toDownload.isEmpty()) {
            return;
        }
        JPanel msg = new JPanel(new GridBagLayout());
        msg.add((Component)new JLabel(I18n.tr("<html>This action will require {0} individual<br>download requests. Do you wish<br>to continue?</html>", toDownload.size())), GBC.eol());
        if (!GraphicsEnvironment.isHeadless() && 0 != JOptionPane.showConfirmDialog(MainApplication.getMainFrame(), msg, title, 2, -1)) {
            return;
        }
        PleaseWaitProgressMonitor monitor = new PleaseWaitProgressMonitor(I18n.tr("Download data", new Object[0]));
        Future<?> future = new DownloadTaskList().download(false, (List<Rectangle2D>)toDownload, osmDownload, gpxDownload, (ProgressMonitor)monitor);
        DownloadAlongAction.waitFuture(future, monitor);
    }
}

