/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import java.nio.file.Path;
import java.util.Optional;

public class SolrScrapeConfiguration {
    private final ConnectionType type;
    private final String zookeeperConnectionString;
    private final String solrHost;
    private String basicAuthUser;
    private String basicAuthPwd;
    private boolean sslEnabled = false;
    private SslConfiguration sslConfiguration;

    private SolrScrapeConfiguration(ConnectionType type, String zookeeperConnectionString, String solrHost) {
        this.type = type;
        this.zookeeperConnectionString = zookeeperConnectionString;
        this.solrHost = solrHost;
    }

    public ConnectionType getType() {
        return this.type;
    }

    public Optional<String> getZookeeperConnectionString() {
        return Optional.ofNullable(this.zookeeperConnectionString);
    }

    public Optional<String> getSolrHost() {
        return Optional.ofNullable(this.solrHost);
    }

    public static SolrScrapeConfiguration solrCloud(String zookeeperConnectionString) {
        return new SolrScrapeConfiguration(ConnectionType.CLOUD, zookeeperConnectionString, null);
    }

    public static SolrScrapeConfiguration standalone(String solrHost) {
        return new SolrScrapeConfiguration(ConnectionType.STANDALONE, null, solrHost);
    }

    public SolrScrapeConfiguration withBasicAuthCredentials(String user, String password) {
        this.basicAuthUser = user;
        this.basicAuthPwd = password;
        return this;
    }

    public String getBasicAuthUser() {
        return this.basicAuthUser;
    }

    public String getBasicAuthPwd() {
        return this.basicAuthPwd;
    }

    public SolrScrapeConfiguration withSslConfiguration(Path keystorePath, String keystorePassword, Path trustStorePath, String trustStorePassword) {
        this.sslEnabled = true;
        this.sslConfiguration = new SslConfiguration(keystorePath, keystorePassword, trustStorePath, trustStorePassword);
        return this;
    }

    public boolean isSSLEnabled() {
        return this.sslEnabled;
    }

    public SslConfiguration getSslConfiguration() {
        return this.sslConfiguration;
    }

    public String toString() {
        if (this.type == ConnectionType.CLOUD) {
            return "Solr Cloud ZK: " + this.zookeeperConnectionString;
        }
        if (this.type == ConnectionType.STANDALONE) {
            return "Solr Node: " + this.solrHost;
        }
        return "None";
    }

    public static class SslConfiguration {
        public final Path keystorePath;
        public final String keystorePassword;
        public final Path trustStorePath;
        public final String trustStorePassword;

        public SslConfiguration(Path keystorePath, String keystorePassword, Path trustStorePath, String trustStorePassword) {
            this.keystorePath = keystorePath;
            this.keystorePassword = keystorePassword;
            this.trustStorePath = trustStorePath;
            this.trustStorePassword = trustStorePassword;
        }
    }

    public static enum ConnectionType {
        CLOUD,
        STANDALONE;

    }
}

