/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.io.IOException;
import java.util.ArrayList;
import opennlp.tools.lemmatizer.LemmaSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class LemmaSampleStream
extends FilterObjectStream<String, LemmaSample> {
    public LemmaSampleStream(ObjectStream<String> samples) {
        super(samples);
    }

    @Override
    public LemmaSample read() throws IOException {
        ArrayList<String> toks = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<String> preds = new ArrayList<String>();
        String line = (String)this.samples.read();
        while (line != null && !line.equals("")) {
            String[] parts = line.split("\t");
            if (parts.length != 3) {
                System.err.println("Skipping corrupt line: " + line);
            } else {
                toks.add(parts[0]);
                tags.add(parts[1]);
                preds.add(parts[2]);
            }
            line = (String)this.samples.read();
        }
        if (toks.size() > 0) {
            return new LemmaSample(toks.toArray(new String[toks.size()]), tags.toArray(new String[tags.size()]), preds.toArray(new String[preds.size()]));
        }
        return null;
    }
}

