/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.designer;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.SuppressForbidden;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.ManagedIndexSchema;
import org.apache.solr.schema.SchemaField;

public class ManagedSchemaDiff {
    private static final String UPDATED_KEY_STRING = "updated";
    private static final String ADDED_KEY_STRING = "added";
    private static final String REMOVED_KEY_STRING = "removed";
    private static final String FIELDS_KEY_STRING = "fields";
    private static final String FIELD_TYPES_KEY_STRING = "fieldTypes";
    private static final String DYNAMIC_FIELDS_KEY_STRING = "dynamicFields";
    private static final String COPY_FIELDS_KEY_STRING = "copyFields";

    public static Map<String, Object> diff(ManagedIndexSchema oldSchema, ManagedIndexSchema newSchema) {
        HashMap<String, Object> diff = new HashMap<String, Object>();
        Map<String, Object> fieldsDiff = ManagedSchemaDiff.diff(ManagedSchemaDiff.mapFieldsToPropertyValues(oldSchema.getFields()), ManagedSchemaDiff.mapFieldsToPropertyValues(newSchema.getFields()));
        Map<String, Object> fieldTypesDiff = ManagedSchemaDiff.diff(ManagedSchemaDiff.mapFieldTypesToPropValues(oldSchema.getFieldTypes()), ManagedSchemaDiff.mapFieldTypesToPropValues(newSchema.getFieldTypes()));
        Map<String, Object> dynamicFieldDiff = ManagedSchemaDiff.diff(ManagedSchemaDiff.mapDynamicFieldToPropValues(oldSchema.getDynamicFields()), ManagedSchemaDiff.mapDynamicFieldToPropValues(newSchema.getDynamicFields()));
        Map<String, Object> copyFieldDiff = ManagedSchemaDiff.diff(ManagedSchemaDiff.getCopyFieldList(oldSchema), ManagedSchemaDiff.getCopyFieldList(newSchema));
        if (!fieldsDiff.isEmpty()) {
            diff.put(FIELDS_KEY_STRING, fieldsDiff);
        }
        if (!fieldTypesDiff.isEmpty()) {
            diff.put(FIELD_TYPES_KEY_STRING, fieldTypesDiff);
        }
        if (!dynamicFieldDiff.isEmpty()) {
            diff.put(DYNAMIC_FIELDS_KEY_STRING, dynamicFieldDiff);
        }
        if (!copyFieldDiff.isEmpty()) {
            diff.put(COPY_FIELDS_KEY_STRING, copyFieldDiff);
        }
        return diff;
    }

    protected static Map<String, Object> diff(Map<String, SimpleOrderedMap<Object>> map1, Map<String, SimpleOrderedMap<Object>> map2) {
        HashMap<String, List<Map<String, Object>>> changedValues = new HashMap<String, List<Map<String, Object>>>();
        HashMap<String, SimpleOrderedMap<Object>> newValues = new HashMap<String, SimpleOrderedMap<Object>>();
        HashMap<String, SimpleOrderedMap<Object>> removedValues = new HashMap<String, SimpleOrderedMap<Object>>();
        for (String fieldName : map1.keySet()) {
            if (map2.containsKey(fieldName)) {
                List<Map<String, Object>> mapDiff;
                SimpleOrderedMap<Object> newPropValues;
                SimpleOrderedMap<Object> oldPropValues = map1.get(fieldName);
                if (oldPropValues.equals(newPropValues = map2.get(fieldName)) || (mapDiff = ManagedSchemaDiff.getMapDifference(oldPropValues, newPropValues)).isEmpty()) continue;
                changedValues.put(fieldName, mapDiff);
                continue;
            }
            removedValues.put(fieldName, map1.get(fieldName));
        }
        for (String fieldName : map2.keySet()) {
            if (map1.containsKey(fieldName)) continue;
            newValues.put(fieldName, map2.get(fieldName));
        }
        HashMap<String, Object> mapDiff = new HashMap<String, Object>();
        if (!changedValues.isEmpty()) {
            mapDiff.put(UPDATED_KEY_STRING, changedValues);
        }
        if (!newValues.isEmpty()) {
            mapDiff.put(ADDED_KEY_STRING, newValues);
        }
        if (!removedValues.isEmpty()) {
            mapDiff.put(REMOVED_KEY_STRING, removedValues);
        }
        return mapDiff;
    }

    @SuppressForbidden(reason="Maps.difference")
    private static List<Map<String, Object>> getMapDifference(SimpleOrderedMap<Object> simpleOrderedMap1, SimpleOrderedMap<Object> simpleOrderedMap2) {
        Map map2;
        Map map1 = simpleOrderedMap1.toMap(new HashMap());
        Map mapDiff = Maps.difference((Map)map1, (Map)(map2 = simpleOrderedMap2.toMap(new HashMap()))).entriesDiffering();
        if (mapDiff.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, Object> leftMapDiff = mapDiff.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), ((MapDifference.ValueDifference)entry.getValue()).leftValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, Object> rightMapDiff = mapDiff.entrySet().stream().map(entry -> Map.entry((String)entry.getKey(), ((MapDifference.ValueDifference)entry.getValue()).rightValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return Arrays.asList(leftMapDiff, rightMapDiff);
    }

    protected static Map<String, Object> diff(List<SimpleOrderedMap<Object>> list1, List<SimpleOrderedMap<Object>> list2) {
        ArrayList oldList = new ArrayList();
        ArrayList newList = new ArrayList();
        list1.forEach(som -> {
            if (!list2.contains(som)) {
                oldList.add(som);
            }
        });
        list2.forEach(som -> {
            if (!list1.contains(som)) {
                newList.add(som);
            }
        });
        HashMap<String, Object> mapDiff = new HashMap<String, Object>();
        if (!oldList.isEmpty()) {
            mapDiff.put("old", oldList);
        }
        if (!newList.isEmpty()) {
            mapDiff.put("new", newList);
        }
        return mapDiff;
    }

    protected static Map<String, SimpleOrderedMap<Object>> mapFieldsToPropertyValues(Map<String, SchemaField> fields) {
        HashMap<String, SimpleOrderedMap<Object>> propValueMap = new HashMap<String, SimpleOrderedMap<Object>>();
        fields.forEach((k, v) -> propValueMap.put((String)k, v.getNamedPropertyValues(true)));
        return propValueMap;
    }

    protected static Map<String, SimpleOrderedMap<Object>> mapFieldTypesToPropValues(Map<String, FieldType> fieldTypes) {
        HashMap<String, SimpleOrderedMap<Object>> propValueMap = new HashMap<String, SimpleOrderedMap<Object>>();
        fieldTypes.forEach((k, v) -> propValueMap.put((String)k, v.getNamedPropertyValues(true)));
        return propValueMap;
    }

    protected static Map<String, SimpleOrderedMap<Object>> mapDynamicFieldToPropValues(IndexSchema.DynamicField[] dynamicFields) {
        return Stream.of(dynamicFields).map(df -> Map.entry(df.getPrototype().getName(), df.getPrototype().getNamedPropertyValues(true))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected static List<SimpleOrderedMap<Object>> getCopyFieldList(ManagedIndexSchema indexSchema) {
        return indexSchema.getCopyFieldProperties(false, null, null);
    }
}

