/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.scheduled;

import java.util.concurrent.Callable;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.cluster.ExecutionResult;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.services.scheduled.ScheduledTaskRunner;
import org.keycloak.timer.ScheduledTask;

public class ClusterAwareScheduledTaskRunner
extends ScheduledTaskRunner {
    private static final Logger logger = Logger.getLogger(ClusterAwareScheduledTaskRunner.class);
    private final int intervalSecs;

    public ClusterAwareScheduledTaskRunner(KeycloakSessionFactory sessionFactory, ScheduledTask task, long intervalMillis) {
        super(sessionFactory, task);
        this.intervalSecs = (int)(intervalMillis / 1000L);
    }

    protected void runTask(KeycloakSession session) {
        ScheduledTask localTask;
        String taskKey;
        ClusterProvider clusterProvider = (ClusterProvider)session.getProvider(ClusterProvider.class);
        ExecutionResult result = clusterProvider.executeIfNotExecuted(taskKey = this.task.getClass().getSimpleName(), this.intervalSecs, (Callable)new Callable<Void>(){
            final /* synthetic */ ScheduledTask val$localTask;
            final /* synthetic */ KeycloakSession val$session;
            {
                this.val$localTask = scheduledTask;
                this.val$session = keycloakSession;
            }

            @Override
            public Void call() throws Exception {
                this.val$localTask.run(this.val$session);
                return null;
            }
        });
        if (result.isExecuted()) {
            logger.debugf("Executed scheduled task %s", (Object)taskKey);
        } else {
            logger.debugf("Skipped execution of task %s as other cluster node is executing it", (Object)taskKey);
        }
    }
}

