/**
IDBIndex interface of the IndexedDB API provides asynchronous access to an index in a database. An index is a kind of object store for looking up records in another object store, called the referenced object store. You use this interface to retrieve data.

@returns {IDBIndex}
*/
IDBIndex = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(String | String)} string | string[]
**/
IDBIndex.prototype.keyPath = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
IDBIndex.prototype.multiEntry = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {String}
**/
IDBIndex.prototype.name = new String();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {IDBObjectStore}
**/
IDBIndex.prototype.objectStore = new IDBObjectStore();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {Boolean}
**/
IDBIndex.prototype.unique = new Boolean();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Retrieves the number of records matching the given key or key range in query.

If successful, request's result will be the count.

@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[] | IDBKeyRange)} [query] IDBValidKey | IDBKeyRange
@returns {IDBRequest}
**/
IDBIndex.prototype.count = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Retrieves the value of the first record matching the given key or key range in query.

If successful, request's result will be the value, or undefined if there was no matching record.

@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[] | IDBKeyRange)} query IDBValidKey | IDBKeyRange
@returns {IDBRequest}
**/
IDBIndex.prototype.get = function(query) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Retrieves the values of the records matching the given key or key range in query (up to count if given).

If successful, request's result will be an Array of the values.

@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[] | IDBKeyRange | null)} [query] IDBValidKey | IDBKeyRange | null
@param {Number} [count]
@returns {IDBRequest}
**/
IDBIndex.prototype.getAll = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Retrieves the keys of records matching the given key or key range in query (up to count if given).

If successful, request's result will be an Array of the keys.

@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[] | IDBKeyRange | null)} [query] IDBValidKey | IDBKeyRange | null
@param {Number} [count]
@returns {IDBRequest}
**/
IDBIndex.prototype.getAllKeys = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Retrieves the key of the first record matching the given key or key range in query.

If successful, request's result will be the key, or undefined if there was no matching record.

@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[] | IDBKeyRange)} query IDBValidKey | IDBKeyRange
@returns {IDBRequest}
**/
IDBIndex.prototype.getKey = function(query) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Opens a cursor over the records matching query, ordered by direction. If query is null, all records in index are matched.

If successful, request's result will be an IDBCursorWithValue, or null if there were no matching records.

@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[] | IDBKeyRange | null)} [query] IDBValidKey | IDBKeyRange | null
@param {("next" | "nextunique" | "prev" | "prevunique")} [direction] IDBCursorDirection
@returns {IDBRequest}
**/
IDBIndex.prototype.openCursor = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Opens a cursor with key only flag set over the records matching query, ordered by direction. If query is null, all records in index are matched.

If successful, request's result will be an IDBCursor, or null if there were no matching records.

@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[] | IDBKeyRange | null)} [query] IDBValidKey | IDBKeyRange | null
@param {("next" | "nextunique" | "prev" | "prevunique")} [direction] IDBCursorDirection
@returns {IDBRequest}
**/
IDBIndex.prototype.openKeyCursor = function() {};

