/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.spi.support;

import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.openide.util.Lookup;

public abstract class NativeExecutionUserNotification {
    private static NativeExecutionUserNotification INSTANCE = null;

    public static synchronized NativeExecutionUserNotification getDefault() {
        if (INSTANCE == null && (INSTANCE = (NativeExecutionUserNotification)Lookup.getDefault().lookup(NativeExecutionUserNotification.class)) == null) {
            INSTANCE = new Trivial();
        }
        return INSTANCE;
    }

    public abstract void notify(String var1, Descriptor var2);

    public abstract void notify(String var1);

    public abstract void notifyStatus(String var1);

    public abstract void showErrorNotification(String var1, String var2, String var3);

    public abstract void showInfoNotification(String var1, String var2, String var3);

    public abstract boolean confirmShellStatusValiation(String var1, String var2, String var3, Shell var4);

    public abstract boolean showYesNoQuestion(String var1, String var2);

    private static class Trivial
    extends NativeExecutionUserNotification {
        @Override
        public void notify(String message, Descriptor type) {
            System.err.println(message);
        }

        @Override
        public void notify(String message) {
            System.err.println(message);
        }

        @Override
        public void showErrorNotification(String title, String shortMessage, String longMesage) {
            System.err.println(shortMessage);
        }

        @Override
        public void showInfoNotification(String title, String shortMessage, String longMesage) {
            System.err.println(shortMessage);
        }

        @Override
        public boolean confirmShellStatusValiation(String title, String header, String footer, Shell shell) {
            System.err.println(title);
            System.err.println(header);
            for (String error : shell.getValidationStatus().getErrors()) {
                System.err.println(error);
            }
            System.err.println(footer);
            return true;
        }

        @Override
        public boolean showYesNoQuestion(String title, String text) {
            System.err.println(text);
            return true;
        }

        @Override
        public void notifyStatus(String message) {
            System.err.println(message);
        }
    }

    public static enum Descriptor {
        WARNING,
        ERROR;

    }
}

