/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.java.hints.spi.preview.PreviewEnabler;
import org.openide.filesystems.FileObject;
import org.openide.util.EditableProperties;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;

public class EnablePreviewSingleSourceFile
implements PreviewEnabler {
    private static final String ENABLE_PREVIEW_FLAG = "--enable-preview";
    private static final String SOURCE_FLAG = "--source";
    private static final Pattern SOURCE_FLAG_PATTERN = Pattern.compile("--source[ \t]+[0-9]+");
    private static final String FILE_VM_OPTIONS = "single_file_vm_options";
    private FileObject file;

    private EnablePreviewSingleSourceFile(@NonNull FileObject file) {
        Parameters.notNull((CharSequence)"file", (Object)file);
        this.file = file;
    }

    public void enablePreview(String newSourceLevel) throws Exception {
        EditableProperties ep = EnablePreviewSingleSourceFile.getEditableProperties(this.file);
        Object compilerArgs = (String)this.file.getAttribute(FILE_VM_OPTIONS);
        if (compilerArgs == null) {
            compilerArgs = "";
        }
        Matcher m = SOURCE_FLAG_PATTERN.matcher((CharSequence)compilerArgs);
        if (newSourceLevel == null) {
            newSourceLevel = EnablePreviewSingleSourceFile.getJdkRunVersion();
        }
        compilerArgs = ((String)compilerArgs).contains(SOURCE_FLAG) ? m.replaceAll("--enable-preview --source " + newSourceLevel) : (String)compilerArgs + (((String)compilerArgs).isEmpty() ? "" : " ") + "--enable-preview --source " + newSourceLevel;
        this.file.setAttribute(FILE_VM_OPTIONS, compilerArgs);
        EnablePreviewSingleSourceFile.storeEditableProperties(ep, this.file);
    }

    private static EditableProperties getEditableProperties(final FileObject file) throws IOException {
        try {
            return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<EditableProperties>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public EditableProperties run() throws IOException {
                    FileObject propertiesFo = file;
                    EditableProperties ep = null;
                    if (propertiesFo != null) {
                        ep = new EditableProperties(false);
                        try (InputStream is = null;){
                            is = propertiesFo.getInputStream();
                            ep.load(is);
                        }
                    }
                    return ep;
                }
            });
        }
        catch (MutexException ex) {
            return null;
        }
    }

    private static void storeEditableProperties(final EditableProperties ep, final FileObject file) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject propertiesFo = null;
                    if (file != null) {
                        propertiesFo = file;
                    }
                    if (propertiesFo != null) {
                        OutputStream os = null;
                        try {
                            os = propertiesFo.getOutputStream();
                            ep.store(os);
                        }
                        finally {
                            if (os != null) {
                                os.flush();
                                os.close();
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            // empty catch block
        }
    }

    private static String getJdkRunVersion() {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2);
        }
        return javaVersion;
    }

    public static final class FactoryImpl
    implements PreviewEnabler.Factory {
        public PreviewEnabler enablerFor(FileObject file) {
            Project prj;
            if (file != null && (prj = FileOwnerQuery.getOwner((FileObject)file)) == null) {
                return new EnablePreviewSingleSourceFile(file);
            }
            return null;
        }
    }
}

