/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.containerengine.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.containerengine.model.KeyValue;
import com.oracle.bmc.containerengine.model.Node;
import com.oracle.bmc.containerengine.model.NodeEvictionNodePoolSettings;
import com.oracle.bmc.containerengine.model.NodePoolCyclingDetails;
import com.oracle.bmc.containerengine.model.NodePoolLifecycleState;
import com.oracle.bmc.containerengine.model.NodePoolNodeConfigDetails;
import com.oracle.bmc.containerengine.model.NodeShapeConfig;
import com.oracle.bmc.containerengine.model.NodeSourceDetails;
import com.oracle.bmc.containerengine.model.NodeSourceOption;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class NodePool
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="lifecycleState")
    private final NodePoolLifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="clusterId")
    private final String clusterId;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="kubernetesVersion")
    private final String kubernetesVersion;
    @JsonProperty(value="nodeMetadata")
    private final Map<String, String> nodeMetadata;
    @JsonProperty(value="nodeImageId")
    private final String nodeImageId;
    @JsonProperty(value="nodeImageName")
    private final String nodeImageName;
    @JsonProperty(value="nodeShapeConfig")
    private final NodeShapeConfig nodeShapeConfig;
    @JsonProperty(value="nodeSource")
    private final NodeSourceOption nodeSource;
    @JsonProperty(value="nodeSourceDetails")
    private final NodeSourceDetails nodeSourceDetails;
    @JsonProperty(value="nodeShape")
    private final String nodeShape;
    @JsonProperty(value="initialNodeLabels")
    private final List<KeyValue> initialNodeLabels;
    @JsonProperty(value="sshPublicKey")
    private final String sshPublicKey;
    @JsonProperty(value="quantityPerSubnet")
    private final Integer quantityPerSubnet;
    @JsonProperty(value="subnetIds")
    private final List<String> subnetIds;
    @JsonProperty(value="nodes")
    private final List<Node> nodes;
    @JsonProperty(value="nodeConfigDetails")
    private final NodePoolNodeConfigDetails nodeConfigDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="nodeEvictionNodePoolSettings")
    private final NodeEvictionNodePoolSettings nodeEvictionNodePoolSettings;
    @JsonProperty(value="nodePoolCyclingDetails")
    private final NodePoolCyclingDetails nodePoolCyclingDetails;

    @Deprecated
    @ConstructorProperties(value={"id", "lifecycleState", "lifecycleDetails", "compartmentId", "clusterId", "name", "kubernetesVersion", "nodeMetadata", "nodeImageId", "nodeImageName", "nodeShapeConfig", "nodeSource", "nodeSourceDetails", "nodeShape", "initialNodeLabels", "sshPublicKey", "quantityPerSubnet", "subnetIds", "nodes", "nodeConfigDetails", "freeformTags", "definedTags", "systemTags", "nodeEvictionNodePoolSettings", "nodePoolCyclingDetails"})
    public NodePool(String id, NodePoolLifecycleState lifecycleState, String lifecycleDetails, String compartmentId, String clusterId, String name, String kubernetesVersion, Map<String, String> nodeMetadata, String nodeImageId, String nodeImageName, NodeShapeConfig nodeShapeConfig, NodeSourceOption nodeSource, NodeSourceDetails nodeSourceDetails, String nodeShape, List<KeyValue> initialNodeLabels, String sshPublicKey, Integer quantityPerSubnet, List<String> subnetIds, List<Node> nodes, NodePoolNodeConfigDetails nodeConfigDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, NodeEvictionNodePoolSettings nodeEvictionNodePoolSettings, NodePoolCyclingDetails nodePoolCyclingDetails) {
        this.id = id;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.compartmentId = compartmentId;
        this.clusterId = clusterId;
        this.name = name;
        this.kubernetesVersion = kubernetesVersion;
        this.nodeMetadata = nodeMetadata;
        this.nodeImageId = nodeImageId;
        this.nodeImageName = nodeImageName;
        this.nodeShapeConfig = nodeShapeConfig;
        this.nodeSource = nodeSource;
        this.nodeSourceDetails = nodeSourceDetails;
        this.nodeShape = nodeShape;
        this.initialNodeLabels = initialNodeLabels;
        this.sshPublicKey = sshPublicKey;
        this.quantityPerSubnet = quantityPerSubnet;
        this.subnetIds = subnetIds;
        this.nodes = nodes;
        this.nodeConfigDetails = nodeConfigDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.nodeEvictionNodePoolSettings = nodeEvictionNodePoolSettings;
        this.nodePoolCyclingDetails = nodePoolCyclingDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public NodePoolLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getName() {
        return this.name;
    }

    public String getKubernetesVersion() {
        return this.kubernetesVersion;
    }

    public Map<String, String> getNodeMetadata() {
        return this.nodeMetadata;
    }

    public String getNodeImageId() {
        return this.nodeImageId;
    }

    public String getNodeImageName() {
        return this.nodeImageName;
    }

    public NodeShapeConfig getNodeShapeConfig() {
        return this.nodeShapeConfig;
    }

    public NodeSourceOption getNodeSource() {
        return this.nodeSource;
    }

    public NodeSourceDetails getNodeSourceDetails() {
        return this.nodeSourceDetails;
    }

    public String getNodeShape() {
        return this.nodeShape;
    }

    public List<KeyValue> getInitialNodeLabels() {
        return this.initialNodeLabels;
    }

    public String getSshPublicKey() {
        return this.sshPublicKey;
    }

    public Integer getQuantityPerSubnet() {
        return this.quantityPerSubnet;
    }

    public List<String> getSubnetIds() {
        return this.subnetIds;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public NodePoolNodeConfigDetails getNodeConfigDetails() {
        return this.nodeConfigDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public NodeEvictionNodePoolSettings getNodeEvictionNodePoolSettings() {
        return this.nodeEvictionNodePoolSettings;
    }

    public NodePoolCyclingDetails getNodePoolCyclingDetails() {
        return this.nodePoolCyclingDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("NodePool(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", clusterId=").append(String.valueOf(this.clusterId));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", kubernetesVersion=").append(String.valueOf(this.kubernetesVersion));
        sb.append(", nodeMetadata=").append(String.valueOf(this.nodeMetadata));
        sb.append(", nodeImageId=").append(String.valueOf(this.nodeImageId));
        sb.append(", nodeImageName=").append(String.valueOf(this.nodeImageName));
        sb.append(", nodeShapeConfig=").append(String.valueOf((Object)this.nodeShapeConfig));
        sb.append(", nodeSource=").append(String.valueOf((Object)this.nodeSource));
        sb.append(", nodeSourceDetails=").append(String.valueOf((Object)this.nodeSourceDetails));
        sb.append(", nodeShape=").append(String.valueOf(this.nodeShape));
        sb.append(", initialNodeLabels=").append(String.valueOf(this.initialNodeLabels));
        sb.append(", sshPublicKey=").append(String.valueOf(this.sshPublicKey));
        sb.append(", quantityPerSubnet=").append(String.valueOf(this.quantityPerSubnet));
        sb.append(", subnetIds=").append(String.valueOf(this.subnetIds));
        sb.append(", nodes=").append(String.valueOf(this.nodes));
        sb.append(", nodeConfigDetails=").append(String.valueOf((Object)this.nodeConfigDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", nodeEvictionNodePoolSettings=").append(String.valueOf((Object)this.nodeEvictionNodePoolSettings));
        sb.append(", nodePoolCyclingDetails=").append(String.valueOf((Object)this.nodePoolCyclingDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof NodePool)) {
            return false;
        }
        NodePool other = (NodePool)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.clusterId, other.clusterId) && Objects.equals(this.name, other.name) && Objects.equals(this.kubernetesVersion, other.kubernetesVersion) && Objects.equals(this.nodeMetadata, other.nodeMetadata) && Objects.equals(this.nodeImageId, other.nodeImageId) && Objects.equals(this.nodeImageName, other.nodeImageName) && Objects.equals((Object)this.nodeShapeConfig, (Object)other.nodeShapeConfig) && Objects.equals((Object)this.nodeSource, (Object)other.nodeSource) && Objects.equals((Object)this.nodeSourceDetails, (Object)other.nodeSourceDetails) && Objects.equals(this.nodeShape, other.nodeShape) && Objects.equals(this.initialNodeLabels, other.initialNodeLabels) && Objects.equals(this.sshPublicKey, other.sshPublicKey) && Objects.equals(this.quantityPerSubnet, other.quantityPerSubnet) && Objects.equals(this.subnetIds, other.subnetIds) && Objects.equals(this.nodes, other.nodes) && Objects.equals((Object)this.nodeConfigDetails, (Object)other.nodeConfigDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals((Object)this.nodeEvictionNodePoolSettings, (Object)other.nodeEvictionNodePoolSettings) && Objects.equals((Object)this.nodePoolCyclingDetails, (Object)other.nodePoolCyclingDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.clusterId == null ? 43 : this.clusterId.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.kubernetesVersion == null ? 43 : this.kubernetesVersion.hashCode());
        result = result * 59 + (this.nodeMetadata == null ? 43 : this.nodeMetadata.hashCode());
        result = result * 59 + (this.nodeImageId == null ? 43 : this.nodeImageId.hashCode());
        result = result * 59 + (this.nodeImageName == null ? 43 : this.nodeImageName.hashCode());
        result = result * 59 + (this.nodeShapeConfig == null ? 43 : this.nodeShapeConfig.hashCode());
        result = result * 59 + (this.nodeSource == null ? 43 : this.nodeSource.hashCode());
        result = result * 59 + (this.nodeSourceDetails == null ? 43 : this.nodeSourceDetails.hashCode());
        result = result * 59 + (this.nodeShape == null ? 43 : this.nodeShape.hashCode());
        result = result * 59 + (this.initialNodeLabels == null ? 43 : this.initialNodeLabels.hashCode());
        result = result * 59 + (this.sshPublicKey == null ? 43 : this.sshPublicKey.hashCode());
        result = result * 59 + (this.quantityPerSubnet == null ? 43 : this.quantityPerSubnet.hashCode());
        result = result * 59 + (this.subnetIds == null ? 43 : this.subnetIds.hashCode());
        result = result * 59 + (this.nodes == null ? 43 : this.nodes.hashCode());
        result = result * 59 + (this.nodeConfigDetails == null ? 43 : this.nodeConfigDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.nodeEvictionNodePoolSettings == null ? 43 : this.nodeEvictionNodePoolSettings.hashCode());
        result = result * 59 + (this.nodePoolCyclingDetails == null ? 43 : this.nodePoolCyclingDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="lifecycleState")
        private NodePoolLifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="clusterId")
        private String clusterId;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="kubernetesVersion")
        private String kubernetesVersion;
        @JsonProperty(value="nodeMetadata")
        private Map<String, String> nodeMetadata;
        @JsonProperty(value="nodeImageId")
        private String nodeImageId;
        @JsonProperty(value="nodeImageName")
        private String nodeImageName;
        @JsonProperty(value="nodeShapeConfig")
        private NodeShapeConfig nodeShapeConfig;
        @JsonProperty(value="nodeSource")
        private NodeSourceOption nodeSource;
        @JsonProperty(value="nodeSourceDetails")
        private NodeSourceDetails nodeSourceDetails;
        @JsonProperty(value="nodeShape")
        private String nodeShape;
        @JsonProperty(value="initialNodeLabels")
        private List<KeyValue> initialNodeLabels;
        @JsonProperty(value="sshPublicKey")
        private String sshPublicKey;
        @JsonProperty(value="quantityPerSubnet")
        private Integer quantityPerSubnet;
        @JsonProperty(value="subnetIds")
        private List<String> subnetIds;
        @JsonProperty(value="nodes")
        private List<Node> nodes;
        @JsonProperty(value="nodeConfigDetails")
        private NodePoolNodeConfigDetails nodeConfigDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="nodeEvictionNodePoolSettings")
        private NodeEvictionNodePoolSettings nodeEvictionNodePoolSettings;
        @JsonProperty(value="nodePoolCyclingDetails")
        private NodePoolCyclingDetails nodePoolCyclingDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder lifecycleState(NodePoolLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            this.__explicitlySet__.add("clusterId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder kubernetesVersion(String kubernetesVersion) {
            this.kubernetesVersion = kubernetesVersion;
            this.__explicitlySet__.add("kubernetesVersion");
            return this;
        }

        public Builder nodeMetadata(Map<String, String> nodeMetadata) {
            this.nodeMetadata = nodeMetadata;
            this.__explicitlySet__.add("nodeMetadata");
            return this;
        }

        public Builder nodeImageId(String nodeImageId) {
            this.nodeImageId = nodeImageId;
            this.__explicitlySet__.add("nodeImageId");
            return this;
        }

        public Builder nodeImageName(String nodeImageName) {
            this.nodeImageName = nodeImageName;
            this.__explicitlySet__.add("nodeImageName");
            return this;
        }

        public Builder nodeShapeConfig(NodeShapeConfig nodeShapeConfig) {
            this.nodeShapeConfig = nodeShapeConfig;
            this.__explicitlySet__.add("nodeShapeConfig");
            return this;
        }

        public Builder nodeSource(NodeSourceOption nodeSource) {
            this.nodeSource = nodeSource;
            this.__explicitlySet__.add("nodeSource");
            return this;
        }

        public Builder nodeSourceDetails(NodeSourceDetails nodeSourceDetails) {
            this.nodeSourceDetails = nodeSourceDetails;
            this.__explicitlySet__.add("nodeSourceDetails");
            return this;
        }

        public Builder nodeShape(String nodeShape) {
            this.nodeShape = nodeShape;
            this.__explicitlySet__.add("nodeShape");
            return this;
        }

        public Builder initialNodeLabels(List<KeyValue> initialNodeLabels) {
            this.initialNodeLabels = initialNodeLabels;
            this.__explicitlySet__.add("initialNodeLabels");
            return this;
        }

        public Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            this.__explicitlySet__.add("sshPublicKey");
            return this;
        }

        public Builder quantityPerSubnet(Integer quantityPerSubnet) {
            this.quantityPerSubnet = quantityPerSubnet;
            this.__explicitlySet__.add("quantityPerSubnet");
            return this;
        }

        public Builder subnetIds(List<String> subnetIds) {
            this.subnetIds = subnetIds;
            this.__explicitlySet__.add("subnetIds");
            return this;
        }

        public Builder nodes(List<Node> nodes) {
            this.nodes = nodes;
            this.__explicitlySet__.add("nodes");
            return this;
        }

        public Builder nodeConfigDetails(NodePoolNodeConfigDetails nodeConfigDetails) {
            this.nodeConfigDetails = nodeConfigDetails;
            this.__explicitlySet__.add("nodeConfigDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder nodeEvictionNodePoolSettings(NodeEvictionNodePoolSettings nodeEvictionNodePoolSettings) {
            this.nodeEvictionNodePoolSettings = nodeEvictionNodePoolSettings;
            this.__explicitlySet__.add("nodeEvictionNodePoolSettings");
            return this;
        }

        public Builder nodePoolCyclingDetails(NodePoolCyclingDetails nodePoolCyclingDetails) {
            this.nodePoolCyclingDetails = nodePoolCyclingDetails;
            this.__explicitlySet__.add("nodePoolCyclingDetails");
            return this;
        }

        public NodePool build() {
            NodePool model = new NodePool(this.id, this.lifecycleState, this.lifecycleDetails, this.compartmentId, this.clusterId, this.name, this.kubernetesVersion, this.nodeMetadata, this.nodeImageId, this.nodeImageName, this.nodeShapeConfig, this.nodeSource, this.nodeSourceDetails, this.nodeShape, this.initialNodeLabels, this.sshPublicKey, this.quantityPerSubnet, this.subnetIds, this.nodes, this.nodeConfigDetails, this.freeformTags, this.definedTags, this.systemTags, this.nodeEvictionNodePoolSettings, this.nodePoolCyclingDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(NodePool model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("clusterId")) {
                this.clusterId(model.getClusterId());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("kubernetesVersion")) {
                this.kubernetesVersion(model.getKubernetesVersion());
            }
            if (model.wasPropertyExplicitlySet("nodeMetadata")) {
                this.nodeMetadata(model.getNodeMetadata());
            }
            if (model.wasPropertyExplicitlySet("nodeImageId")) {
                this.nodeImageId(model.getNodeImageId());
            }
            if (model.wasPropertyExplicitlySet("nodeImageName")) {
                this.nodeImageName(model.getNodeImageName());
            }
            if (model.wasPropertyExplicitlySet("nodeShapeConfig")) {
                this.nodeShapeConfig(model.getNodeShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("nodeSource")) {
                this.nodeSource(model.getNodeSource());
            }
            if (model.wasPropertyExplicitlySet("nodeSourceDetails")) {
                this.nodeSourceDetails(model.getNodeSourceDetails());
            }
            if (model.wasPropertyExplicitlySet("nodeShape")) {
                this.nodeShape(model.getNodeShape());
            }
            if (model.wasPropertyExplicitlySet("initialNodeLabels")) {
                this.initialNodeLabels(model.getInitialNodeLabels());
            }
            if (model.wasPropertyExplicitlySet("sshPublicKey")) {
                this.sshPublicKey(model.getSshPublicKey());
            }
            if (model.wasPropertyExplicitlySet("quantityPerSubnet")) {
                this.quantityPerSubnet(model.getQuantityPerSubnet());
            }
            if (model.wasPropertyExplicitlySet("subnetIds")) {
                this.subnetIds(model.getSubnetIds());
            }
            if (model.wasPropertyExplicitlySet("nodes")) {
                this.nodes(model.getNodes());
            }
            if (model.wasPropertyExplicitlySet("nodeConfigDetails")) {
                this.nodeConfigDetails(model.getNodeConfigDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("nodeEvictionNodePoolSettings")) {
                this.nodeEvictionNodePoolSettings(model.getNodeEvictionNodePoolSettings());
            }
            if (model.wasPropertyExplicitlySet("nodePoolCyclingDetails")) {
                this.nodePoolCyclingDetails(model.getNodePoolCyclingDetails());
            }
            return this;
        }
    }
}

