/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.file.launcher.actions;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.java.file.launcher.SingleSourceFileUtil;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class JPDAStart
implements Runnable {
    private static final RequestProcessor RP = new RequestProcessor(JPDAStart.class);
    private static final String TRANSPORT = "dt_socket";
    private final Object[] lock = new Object[2];
    private final FileObject fileObject;

    JPDAStart(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() throws Exception {
        SingleSourceFileUtil.LOG.log(Level.INFO, "JPDA Listening Start");
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            RP.post((Runnable)this);
            this.lock.wait();
            if (this.lock[1] != null) {
                throw (Exception)this.lock[1];
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (String)this.lock[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            try {
                Transport t;
                ListeningConnector lc = null;
                Iterator<ListeningConnector> i = Bootstrap.virtualMachineManager().listeningConnectors().iterator();
                while (i.hasNext() && ((t = (lc = i.next()).transport()) == null || !t.name().equals(this.getTransport()))) {
                }
                if (lc == null) {
                    throw new RuntimeException("No trasports named " + this.getTransport() + " found!");
                }
                Map<String, Connector.Argument> args = lc.defaultArguments();
                String address = lc.startListening(args);
                try {
                    int port = Integer.parseInt(address.substring(address.indexOf(58) + 1));
                    Connector.IntegerArgument portArg = (Connector.IntegerArgument)args.get("port");
                    portArg.setValue(port);
                    this.lock[0] = Integer.toString(port);
                }
                catch (NumberFormatException e) {
                    this.lock[0] = address;
                }
                SingleSourceFileUtil.LOG.log(Level.INFO, "Debug Port:{0}", this.lock[0]);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                ClassPath sourcePath = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{this.fileObject.getParent()});
                ClassPath jdkPath = ClassPathSupport.createClassPath((String)System.getProperty("java.class.path"));
                properties.put("sourcepath", sourcePath);
                File baseDir = FileUtil.toFile((FileObject)this.fileObject.getParent());
                properties.put("baseDir", baseDir);
                properties.put("name", this.fileObject.getName());
                ListeningConnector flc = lc;
                RP.post(() -> {
                    try {
                        JPDADebugger.startListening((ListeningConnector)flc, (Map)args, (Object[])new Object[]{properties});
                    }
                    catch (DebuggerStartException ex) {
                        SingleSourceFileUtil.LOG.log(Level.SEVERE, "Debugger Start Error.", ex);
                    }
                });
            }
            catch (IOException ioex) {
                this.lock[1] = ioex;
            }
            catch (IllegalConnectorArgumentsException icaex) {
                this.lock[1] = icaex;
            }
            finally {
                this.lock.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public String getTransport() {
        return TRANSPORT;
    }
}

