/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.util.List;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.openide.util.Pair;

public class DebuggerOptions {
    private static final DebuggerOptions GLOBAL_INSTANCE = new DefaultGlobal();
    int port = -1;
    int maxData = -2;
    int maxChildren = -1;
    int maxStructureDepth = -1;
    Boolean debugForFirstPageOnly;
    String projectEncoding;
    List<Pair<String, String>> pathMapping;
    Pair<String, Integer> debugProxy;

    public static DebuggerOptions getGlobalInstance() {
        return GLOBAL_INSTANCE;
    }

    public List<Pair<String, String>> getPathMapping() {
        return this.pathMapping;
    }

    public Pair<String, Integer> getDebugProxy() {
        return this.debugProxy;
    }

    public int getPort() {
        return this.port != -1 ? this.port : DebuggerOptions.getGlobalInstance().getPort();
    }

    public int getMaxData() {
        return this.maxData != -2 ? this.maxData : DebuggerOptions.getGlobalInstance().getMaxData();
    }

    public int getMaxChildren() {
        return this.maxChildren != -1 ? this.maxChildren : DebuggerOptions.getGlobalInstance().getMaxChildren();
    }

    public int getMaxStructuresDepth() {
        return this.maxStructureDepth != -1 ? this.maxStructureDepth : DebuggerOptions.getGlobalInstance().getMaxStructuresDepth();
    }

    public boolean isDebugForFirstPageOnly() {
        return this.debugForFirstPageOnly != null ? this.debugForFirstPageOnly.booleanValue() : DebuggerOptions.getGlobalInstance().isDebugForFirstPageOnly();
    }

    public boolean showRequestedUrls() {
        return DebuggerOptions.getGlobalInstance().showRequestedUrls();
    }

    public boolean showDebuggerConsole() {
        return DebuggerOptions.getGlobalInstance().showDebuggerConsole();
    }

    public boolean resolveBreakpoints() {
        return DebuggerOptions.getGlobalInstance().resolveBreakpoints();
    }

    public boolean isDebuggerStoppedAtTheFirstLine() {
        return DebuggerOptions.getGlobalInstance().isDebuggerStoppedAtTheFirstLine();
    }

    public String getPhpInterpreter() {
        return DebuggerOptions.getGlobalInstance().getPhpInterpreter();
    }

    public String getProjectEncoding() {
        return this.projectEncoding != null ? this.projectEncoding : "UTF-8";
    }

    private static class DefaultGlobal
    extends DebuggerOptions {
        @Override
        public int getPort() {
            return PhpOptions.getInstance().getDebuggerPort();
        }

        @Override
        public int getMaxData() {
            return PhpOptions.getInstance().getDebuggerMaxDataLength();
        }

        @Override
        public int getMaxChildren() {
            return PhpOptions.getInstance().getDebuggerMaxChildren();
        }

        @Override
        public int getMaxStructuresDepth() {
            return PhpOptions.getInstance().getDebuggerMaxStructuresDepth();
        }

        @Override
        public boolean isDebugForFirstPageOnly() {
            return false;
        }

        @Override
        public boolean showRequestedUrls() {
            return PhpOptions.getInstance().isDebuggerShowRequestedUrls();
        }

        @Override
        public boolean showDebuggerConsole() {
            return PhpOptions.getInstance().isDebuggerShowDebuggerConsole();
        }

        @Override
        public boolean resolveBreakpoints() {
            return PhpOptions.getInstance().isDebuggerResolveBreakpoints();
        }

        @Override
        public boolean isDebuggerStoppedAtTheFirstLine() {
            return PhpOptions.getInstance().isDebuggerStoppedAtTheFirstLine();
        }

        @Override
        public String getPhpInterpreter() {
            return PhpOptions.getInstance().getPhpInterpreter();
        }
    }
}

