/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.SwingUtilities;
import org.netbeans.modules.websvc.manager.WebServiceManager;
import org.netbeans.modules.websvc.manager.model.WebServiceData;
import org.netbeans.modules.websvc.manager.model.WebServiceListModel;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlDataManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WsdlDataManagerImpl
implements WsdlDataManager {
    private static final RequestProcessor RP = new RequestProcessor(WsdlDataManagerImpl.class);
    private int precedence = 0;

    public WsdlData getWsdlData(String wsdlUrl, String serviceName, boolean synchronuous) {
        return WebServiceListModel.getInstance().getWebServiceData(wsdlUrl, serviceName, synchronuous);
    }

    public WsdlData addWsdlData(String wsdlUrl, String packageName) {
        final WebServiceData wsData = new WebServiceData(wsdlUrl, "default");
        wsData.setPackageName(packageName);
        wsData.setResolved(false);
        Runnable addWsRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    WebServiceManager.getInstance().addWebService(wsData, true);
                }
                catch (IOException ex) {
                    WsdlDataManagerImpl.this.handleException(ex);
                }
            }
        };
        RP.post(addWsRunnable);
        return wsData;
    }

    public void removeWsdlData(String wsdlUrl, String serviceName) {
        WebServiceData wsData = WebServiceListModel.getInstance().findWebServiceData(wsdlUrl, serviceName, true);
        if (wsData != null) {
            WebServiceManager.getInstance().removeWebService(wsData);
        }
    }

    public WsdlData findWsdlData(String wsdlUrl, String serviceName) {
        return WebServiceListModel.getInstance().findWebServiceData(wsdlUrl, serviceName, true);
    }

    public void refresh(WsdlData wsdlData) {
        if (wsdlData instanceof WebServiceData) {
            final WebServiceData data = (WebServiceData)wsdlData;
            Runnable addWsRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        WebServiceManager.getInstance().refreshWebService(data);
                    }
                    catch (IOException ex) {
                        WsdlDataManagerImpl.this.handleException(ex);
                    }
                }
            };
            RP.post(addWsRunnable);
        }
    }

    private void handleException(final Exception exception) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (exception instanceof FileNotFoundException) {
                    String errorMessage = NbBundle.getMessage(WebServiceListModel.class, (String)"INVALID_URL");
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)errorMessage);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                } else {
                    String cause = exception != null ? exception.getLocalizedMessage() : null;
                    String excString = exception != null ? exception.getClass().getName() + " - " + cause : null;
                    String errorMessage = NbBundle.getMessage(WebServiceListModel.class, (String)"WS_ADD_ERROR") + "\n\n" + excString;
                    NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)errorMessage);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
                }
            }
        });
    }

    public void setPrecedence(int precedence) {
        this.precedence = precedence;
    }

    public int getPrecedence() {
        return this.precedence;
    }
}

