/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.TextComponent;
import java.awt.event.TextListener;
import java.util.Hashtable;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.TextDriver;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.Operator;

public class TextComponentOperator
extends ComponentOperator
implements Timeoutable,
Outputable {
    public static final String TEXT_DPROP = "Text";
    private static final long PUSH_KEY_TIMEOUT = 0L;
    private static final long BETWEEN_KEYS_TIMEOUT = 0L;
    private static final long CHANGE_CARET_POSITION_TIMEOUT = 60000L;
    private static final long TYPE_TEXT_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    private TextDriver driver = DriverManager.getTextDriver(this.getClass());

    public TextComponentOperator(TextComponent b) {
        super(b);
    }

    public TextComponentOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((TextComponent)cont.waitSubComponent(new TextComponentFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public TextComponentOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public TextComponentOperator(ContainerOperator cont, String text, int index) {
        this((TextComponent)TextComponentOperator.waitComponent(cont, (ComponentChooser)new TextComponentByTextFinder(text, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public TextComponentOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public TextComponentOperator(ContainerOperator cont, int index) {
        this((TextComponent)TextComponentOperator.waitComponent(cont, (ComponentChooser)new TextComponentFinder(), index));
        this.copyEnvironment(cont);
    }

    public TextComponentOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static TextComponent findTextComponent(Container cont, ComponentChooser chooser, int index) {
        return (TextComponent)TextComponentOperator.findComponent(cont, new TextComponentFinder(chooser), index);
    }

    public static TextComponent findTextComponent(Container cont, ComponentChooser chooser) {
        return TextComponentOperator.findTextComponent(cont, chooser, 0);
    }

    public static TextComponent findTextComponent(Container cont, String text, boolean ce, boolean ccs, int index) {
        return TextComponentOperator.findTextComponent(cont, new TextComponentByTextFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static TextComponent findTextComponent(Container cont, String text, boolean ce, boolean ccs) {
        return TextComponentOperator.findTextComponent(cont, text, ce, ccs, 0);
    }

    public static TextComponent waitTextComponent(Container cont, ComponentChooser chooser, int index) {
        return (TextComponent)TextComponentOperator.waitComponent(cont, (ComponentChooser)new TextComponentFinder(chooser), index);
    }

    public static TextComponent waitTextComponent(Container cont, ComponentChooser chooser) {
        return TextComponentOperator.waitTextComponent(cont, chooser, 0);
    }

    public static TextComponent waitTextComponent(Container cont, String text, boolean ce, boolean ccs, int index) {
        return TextComponentOperator.waitTextComponent(cont, new TextComponentByTextFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static TextComponent waitTextComponent(Container cont, String text, boolean ce, boolean ccs) {
        return TextComponentOperator.waitTextComponent(cont, text, ce, ccs, 0);
    }

    @Override
    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    @Override
    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    @Override
    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    @Override
    public TestOut getOutput() {
        return this.output;
    }

    @Override
    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (TextDriver)DriverManager.getDriver("drivers.text", this.getClass(), anotherOperator.getProperties());
    }

    public void changeCaretPosition(final int position) {
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            @Override
            public Object launch(Object obj) {
                TextComponentOperator.this.driver.changeCaretPosition(TextComponentOperator.this, position);
                return null;
            }

            @Override
            public String getDescription() {
                return "Caret moving";
            }
        }, "TextComponentOperator.ChangeCaretPositionTimeout");
    }

    public void selectText(final int startPosition, final int finalPosition) {
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            @Override
            public Object launch(Object obj) {
                TextComponentOperator.this.driver.selectText(TextComponentOperator.this, startPosition, finalPosition);
                return null;
            }

            @Override
            public String getDescription() {
                return "Text selecting";
            }
        }, "TextComponentOperator.TypeTextTimeout");
    }

    public int getPositionByText(String text, int index) {
        String allText = this.getText();
        int position = 0;
        int ind = 0;
        while ((position = allText.indexOf(text, position)) >= 0) {
            if (ind == index) {
                return position;
            }
            ++ind;
            position += text.length();
        }
        return -1;
    }

    public int getPositionByText(String text) {
        return this.getPositionByText(text, 0);
    }

    public void clearText() {
        this.output.printLine("Clearing text in text component\n    : " + this.toStringSource());
        this.output.printGolden("Clearing text in text component");
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            @Override
            public Object launch(Object obj) {
                TextComponentOperator.this.driver.clearText(TextComponentOperator.this);
                return null;
            }

            @Override
            public String getDescription() {
                return "Text clearing";
            }
        }, "TextComponentOperator.TypeTextTimeout");
    }

    public void typeText(final String text, final int caretPosition) {
        this.output.printLine("Typing text \"" + text + "\" from " + Integer.toString(caretPosition) + " position " + "in text component\n    : " + this.toStringSource());
        this.output.printGolden("Typing text \"" + text + "\" in text component");
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            @Override
            public Object launch(Object obj) {
                TextComponentOperator.this.driver.typeText(TextComponentOperator.this, text, caretPosition);
                return null;
            }

            @Override
            public String getDescription() {
                return "Text typing";
            }
        }, "TextComponentOperator.TypeTextTimeout");
    }

    public void typeText(String text) {
        this.typeText(text, this.getCaretPosition());
    }

    public void enterText(final String text) {
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            @Override
            public Object launch(Object obj) {
                TextComponentOperator.this.driver.enterText(TextComponentOperator.this, text);
                return null;
            }

            @Override
            public String getDescription() {
                return "Text entering";
            }
        }, "TextComponentOperator.TypeTextTimeout");
    }

    @Override
    public Hashtable getDump() {
        Hashtable result = super.getDump();
        result.put(TEXT_DPROP, ((TextComponent)this.getSource()).getText());
        return result;
    }

    public void addTextListener(final TextListener textListener) {
        this.runMapping(new Operator.MapVoidAction("addTextListener"){

            @Override
            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).addTextListener(textListener);
            }
        });
    }

    public int getCaretPosition() {
        return this.runMapping(new Operator.MapIntegerAction("getCaretPosition"){

            @Override
            public int map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).getCaretPosition();
            }
        });
    }

    public String getSelectedText() {
        return (String)this.runMapping(new Operator.MapAction("getSelectedText"){

            @Override
            public Object map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).getSelectedText();
            }
        });
    }

    public int getSelectionEnd() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionEnd"){

            @Override
            public int map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).getSelectionEnd();
            }
        });
    }

    public int getSelectionStart() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionStart"){

            @Override
            public int map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).getSelectionStart();
            }
        });
    }

    public String getText() {
        return (String)this.runMapping(new Operator.MapAction("getText"){

            @Override
            public Object map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).getText();
            }
        });
    }

    public boolean isEditable() {
        return this.runMapping(new Operator.MapBooleanAction("isEditable"){

            @Override
            public boolean map() {
                return ((TextComponent)TextComponentOperator.this.getSource()).isEditable();
            }
        });
    }

    public void removeTextListener(final TextListener textListener) {
        this.runMapping(new Operator.MapVoidAction("removeTextListener"){

            @Override
            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).removeTextListener(textListener);
            }
        });
    }

    public void select(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("select"){

            @Override
            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).select(i, i1);
            }
        });
    }

    public void selectAll() {
        this.runMapping(new Operator.MapVoidAction("selectAll"){

            @Override
            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).selectAll();
            }
        });
    }

    public void setCaretPosition(final int i) {
        this.runMapping(new Operator.MapVoidAction("setCaretPosition"){

            @Override
            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).setCaretPosition(i);
            }
        });
    }

    public void setEditable(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setEditable"){

            @Override
            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).setEditable(b);
            }
        });
    }

    public void setSelectionEnd(final int i) {
        this.runMapping(new Operator.MapVoidAction("setSelectionEnd"){

            @Override
            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).setSelectionEnd(i);
            }
        });
    }

    public void setSelectionStart(final int i) {
        this.runMapping(new Operator.MapVoidAction("setSelectionStart"){

            @Override
            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).setSelectionStart(i);
            }
        });
    }

    public void setText(final String string) {
        this.runMapping(new Operator.MapVoidAction("setText"){

            @Override
            public void map() {
                ((TextComponent)TextComponentOperator.this.getSource()).setText(string);
            }
        });
    }

    protected TextDriver getTextDriver() {
        return this.driver;
    }

    static {
        Timeouts.initDefault("TextComponentOperator.PushKeyTimeout", 0L);
        Timeouts.initDefault("TextComponentOperator.BetweenKeysTimeout", 0L);
        Timeouts.initDefault("TextComponentOperator.ChangeCaretPositionTimeout", 60000L);
        Timeouts.initDefault("TextComponentOperator.TypeTextTimeout", 60000L);
    }

    public static class TextComponentFinder
    extends Operator.Finder {
        public TextComponentFinder(ComponentChooser sf) {
            super(TextComponent.class, sf);
        }

        public TextComponentFinder() {
            super(TextComponent.class);
        }
    }

    public static class TextComponentByTextFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public TextComponentByTextFinder(String lb, Operator.StringComparator comparator) {
            this.label = lb;
            this.comparator = comparator;
        }

        public TextComponentByTextFinder(String lb) {
            this(lb, Operator.getDefaultStringComparator());
        }

        @Override
        public boolean checkComponent(Component comp) {
            if (comp instanceof TextComponent && ((TextComponent)comp).getText() != null) {
                return this.comparator.equals(((TextComponent)comp).getText(), this.label);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return "TextComponent with text \"" + this.label + "\"";
        }
    }
}

