/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config.xml.jms;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.javaee.wildfly.config.WildflyMessageDestination;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WildflyMessageDestinationHandler
extends DefaultHandler {
    private final List<WildflyMessageDestination> messageDestinations = new ArrayList<WildflyMessageDestination>();
    private boolean isDestinations;
    private boolean isDestination;
    private final List<String> jndiNames = new ArrayList<String>();
    private WildflyMessageDestination currentDestination;

    public List<WildflyMessageDestination> getMessageDestinations() {
        return this.messageDestinations;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("jms-destinations".equals(qName)) {
            this.isDestinations = true;
        } else if (this.isDestinations && ("jms-queue".equals(qName) || "jms-topic".equals(qName))) {
            String name = attributes.getValue("name");
            this.currentDestination = "jms-queue".equals(qName) ? new WildflyMessageDestination(name, MessageDestination.Type.QUEUE) : ("jms-topic".equals(qName) ? new WildflyMessageDestination(name, MessageDestination.Type.TOPIC) : null);
            this.isDestination = true;
        } else if (this.isDestination && "entry".equals(qName)) {
            this.jndiNames.add(attributes.getValue("name"));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.isDestination) {
            if ("jms-queue".equals(qName) || "jms-topic".equals(qName)) {
                this.isDestination = false;
                for (String jndiName : this.jndiNames) {
                    this.currentDestination.addEntry(jndiName);
                }
                this.jndiNames.clear();
                this.messageDestinations.add(this.currentDestination);
                this.currentDestination = null;
            }
        } else if (this.isDestinations && "jms-destinations".equals(qName)) {
            this.jndiNames.clear();
            this.isDestination = false;
            this.isDestinations = false;
        }
    }
}

