/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.httpserver;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.httpserver.Bundle;
import org.netbeans.modules.httpserver.HttpServerSettings;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;

public class ServerControlNode
extends AbstractNode {
    static final String NODE_NAME = "nbhttpserver";
    static final String ICON_BASE = "org/netbeans/modules/httpserver/httpserver.png";
    static final String ICON_BASE_ACTIVE = "org/netbeans/modules/httpserver/httpserver-active.png";
    private static final Action ACTION_START = new AbstractAction(Bundle.ACTION_ServerStart()){

        @Override
        public void actionPerformed(ActionEvent e) {
            HttpServerSettings.getDefault().setRunning(true);
        }
    };
    private static final Action ACTION_STOP = new AbstractAction(Bundle.ACTION_ServerStop()){

        @Override
        public void actionPerformed(ActionEvent e) {
            HttpServerSettings.getDefault().setRunning(false);
        }
    };
    private static final Action[] ACTIONS = new Action[]{ACTION_START, ACTION_STOP};
    private static final ServerControlNode INSTANCE = new ServerControlNode();

    public static final ServerControlNode getInstance() {
        return INSTANCE;
    }

    public ServerControlNode() {
        super(Children.LEAF);
        this.setName(NODE_NAME);
        this.setDisplayName(Bundle.LBL_NBWebserver());
        this.setShortDescription(Bundle.TIP_NBWebserver());
        this.setIconBaseWithExtension(ICON_BASE);
        this.updateNodeState();
    }

    public Action[] getActions(boolean context) {
        return Arrays.copyOf(ACTIONS, ACTIONS.length);
    }

    private void updateNodeState0() {
        if (HttpServerSettings.getDefault().isRunning()) {
            this.setDisplayName(Bundle.LBL_NBWebserver_Active());
            this.setShortDescription(Bundle.TIP_NBWebserver_Active(HttpServerSettings.getDefault().getPort()));
            ACTION_START.setEnabled(false);
            ACTION_STOP.setEnabled(true);
            this.setIconBaseWithExtension(ICON_BASE_ACTIVE);
        } else {
            this.setDisplayName(Bundle.LBL_NBWebserver());
            this.setShortDescription(Bundle.TIP_NBWebserver());
            ACTION_START.setEnabled(true);
            ACTION_STOP.setEnabled(false);
            this.setIconBaseWithExtension(ICON_BASE);
        }
    }

    void updateNodeState() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateNodeState0();
        } else {
            SwingUtilities.invokeLater(() -> this.updateNodeState0());
        }
    }
}

