/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.conflicts;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class MarkResolvedAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(MarkResolvedAction.class.getName());

    @Override
    protected boolean enableFull(Node[] activatedNodes) {
        VCSContext context = this.getCurrentContext(activatedNodes);
        return Git.getInstance().getFileStatusCache().containsFiles(context, EnumSet.of(FileInformation.Status.IN_CONFLICT), false);
    }

    @Override
    protected void performAction(final File repository, final File[] roots, VCSContext context) {
        GitProgressSupport supp = new GitProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                File[] conflicts = Git.getInstance().getFileStatusCache().listFiles(roots, EnumSet.of(FileInformation.Status.IN_CONFLICT));
                if (conflicts.length == 0) {
                    DialogDisplayer.getDefault().notifyLater(new NotifyDescriptor((Object)NbBundle.getMessage(MarkResolvedAction.class, (String)"MSG_NoConflicts"), NbBundle.getMessage(MarkResolvedAction.class, (String)"LBL_NoConflicts"), -1, 1, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION));
                } else {
                    LinkedList<File> toAdd = new LinkedList<File>();
                    LinkedList toRemove = new LinkedList();
                    for (File f : conflicts) {
                        (f.exists() ? toAdd : toRemove).add(f);
                    }
                    try {
                        GitClient client = this.getClient();
                        client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(roots));
                        if (!toAdd.isEmpty()) {
                            client.add(toAdd.toArray(new File[0]), this.getProgressMonitor());
                        }
                        if (!toRemove.isEmpty()) {
                            client.remove(toRemove.toArray(new File[0]), true, this.getProgressMonitor());
                        }
                    }
                    catch (GitException ex) {
                        LOG.log(Level.WARNING, null, ex);
                    }
                    finally {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        ArrayList<File> toRefresh = new ArrayList<File>(toAdd.size() + toRemove.size());
                        toRefresh.addAll(toAdd);
                        toRefresh.addAll(toRemove);
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, toRefresh));
                    }
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(MarkResolvedAction.class, (String)"LBL_MarkingProgress"));
    }
}

