/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.git.jgit.commands;

import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Repository;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.jgit.GitClassFactory;
import org.netbeans.libs.git.jgit.commands.GitCommand;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class RenameBranchCommand
extends GitCommand {
    private final String oldName;
    private final String newName;

    public RenameBranchCommand(Repository repository, GitClassFactory gitFactory, String oldName, String newName, ProgressMonitor monitor) {
        super(repository, gitFactory, monitor);
        this.oldName = oldName;
        this.newName = newName;
    }

    @Override
    protected void run() throws GitException {
        Repository repository = this.getRepository();
        try {
            new Git(repository).branchRename().setOldName(this.oldName).setNewName(this.newName).call();
        }
        catch (GitAPIException | JGitInternalException ex) {
            throw new GitException(ex);
        }
    }

    @Override
    protected String getCommandDescription() {
        return "git branch -m " + this.oldName + " " + this.newName;
    }
}

