# coding: utf-8

"""
InfluxDB OSS API Service.

The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint.   # noqa: E501

OpenAPI spec version: 2.0.0
Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from influxdb_client.service._base_service import _BaseService


class UsersService(_BaseService):
    """NOTE: This class is auto generated by OpenAPI Generator.

    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):  # noqa: E501,D401,D403
        """UsersService - a operation defined in OpenAPI."""
        super().__init__(api_client)

    def delete_users_id(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a user.

        Deletes a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).  #### Required permissions  | Action      | Permission required | |:------------|:-----------------------------------------------| | Delete a user | `write-users` or `write-user USER_ID` |  *`USER_ID`* is the ID of the user that you want to delete.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/organizations/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_users_id(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: A user ID. Specifies the [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def delete_users_id_with_http_info(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a user.

        Deletes a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).  #### Required permissions  | Action      | Permission required | |:------------|:-----------------------------------------------| | Delete a user | `write-users` or `write-user USER_ID` |  *`USER_ID`* is the ID of the user that you want to delete.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/organizations/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_users_id_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: A user ID. Specifies the [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_users_id_prepare(user_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/users/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def delete_users_id_async(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Delete a user.

        Deletes a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).  #### Required permissions  | Action      | Permission required | |:------------|:-----------------------------------------------| | Delete a user | `write-users` or `write-user USER_ID` |  *`USER_ID`* is the ID of the user that you want to delete.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/organizations/users/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: A user ID. Specifies the [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) to delete. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._delete_users_id_prepare(user_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/users/{userID}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _delete_users_id_prepare(self, user_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('delete_users_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_users_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_me(self, **kwargs):  # noqa: E501,D401,D403
        """Retrieve the currently authenticated user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_me(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_me_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_me_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_me_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """Retrieve the currently authenticated user.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_me_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_me_prepare(**kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/me', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_me_async(self, **kwargs):  # noqa: E501,D401,D403
        """Retrieve the currently authenticated user.

        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_me_prepare(**kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/me', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_me_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span']  # noqa: E501
        self._check_operation_params('get_me', all_params, local_var_params)

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_users(self, **kwargs):  # noqa: E501,D401,D403
        """List users.

        Lists [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user). Default limit is `20`.  To limit which users are returned, pass query parameters in your request.  #### Required permissions for InfluxDB OSS  | Action | Permission required | Restriction | |:-------|:--------------------|:------------| | List all users | _[Operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_  | | | List a specific user | `read-users` or `read-user USER_ID` | |  *`USER_ID`* is the ID of the user that you want to retrieve.  #### Related guides  - [View users](https://docs.influxdata.com/influxdb/latest/users/view-users/).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset: The offset for pagination. The number of records to skip.  For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param int limit: Limits the number of records returned. Default is `20`.
        :param str after: A resource ID to seek from. Returns records created after the specified record; results don't include the specified record.  Use `after` instead of the `offset` parameter. For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param str name: A user name. Only lists the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :param str id: A user ID. Only lists the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_users_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_users_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_users_with_http_info(self, **kwargs):  # noqa: E501,D401,D403
        """List users.

        Lists [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user). Default limit is `20`.  To limit which users are returned, pass query parameters in your request.  #### Required permissions for InfluxDB OSS  | Action | Permission required | Restriction | |:-------|:--------------------|:------------| | List all users | _[Operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_  | | | List a specific user | `read-users` or `read-user USER_ID` | |  *`USER_ID`* is the ID of the user that you want to retrieve.  #### Related guides  - [View users](https://docs.influxdata.com/influxdb/latest/users/view-users/).
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset: The offset for pagination. The number of records to skip.  For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param int limit: Limits the number of records returned. Default is `20`.
        :param str after: A resource ID to seek from. Returns records created after the specified record; results don't include the specified record.  Use `after` instead of the `offset` parameter. For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param str name: A user name. Only lists the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :param str id: A user ID. Only lists the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_users_prepare(**kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Users',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_users_async(self, **kwargs):  # noqa: E501,D401,D403
        """List users.

        Lists [users](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user). Default limit is `20`.  To limit which users are returned, pass query parameters in your request.  #### Required permissions for InfluxDB OSS  | Action | Permission required | Restriction | |:-------|:--------------------|:------------| | List all users | _[Operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_  | | | List a specific user | `read-users` or `read-user USER_ID` | |  *`USER_ID`* is the ID of the user that you want to retrieve.  #### Related guides  - [View users](https://docs.influxdata.com/influxdb/latest/users/view-users/).
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str zap_trace_span: OpenTracing span context
        :param int offset: The offset for pagination. The number of records to skip.  For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param int limit: Limits the number of records returned. Default is `20`.
        :param str after: A resource ID to seek from. Returns records created after the specified record; results don't include the specified record.  Use `after` instead of the `offset` parameter. For more information about pagination parameters, see [Pagination](https://docs.influxdata.com/influxdb/latest/api/#tag/Pagination).
        :param str name: A user name. Only lists the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :param str id: A user ID. Only lists the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).
        :return: Users
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_users_prepare(**kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/users', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='Users',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_users_prepare(self, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['zap_trace_span', 'offset', 'limit', 'after', 'name', 'id']  # noqa: E501
        self._check_operation_params('get_users', all_params, local_var_params)

        if 'offset' in local_var_params and local_var_params['offset'] < 0:  # noqa: E501
            raise ValueError("Invalid value for parameter `offset` when calling `get_users`, must be a value greater than or equal to `0`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_users`, must be a value less than or equal to `100`")  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `limit` when calling `get_users`, must be a value greater than or equal to `1`")  # noqa: E501
        path_params = {}

        query_params = []
        if 'offset' in local_var_params:
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'limit' in local_var_params:
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'after' in local_var_params:
            query_params.append(('after', local_var_params['after']))  # noqa: E501
        if 'name' in local_var_params:
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'id' in local_var_params:
            query_params.append(('id', local_var_params['id']))  # noqa: E501

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def get_users_id(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a user.

        Retrieves a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/organizations/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_id(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: A user ID. Retrieves the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user). (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_users_id_with_http_info(user_id, **kwargs)  # noqa: E501
            return data

    def get_users_id_with_http_info(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a user.

        Retrieves a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/organizations/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_users_id_with_http_info(user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: A user ID. Retrieves the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user). (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_users_id_prepare(user_id, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/users/{userID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def get_users_id_async(self, user_id, **kwargs):  # noqa: E501,D401,D403
        """Retrieve a user.

        Retrieves a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/organizations/users/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: A user ID. Retrieves the specified [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user). (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._get_users_id_prepare(user_id, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/users/{userID}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _get_users_id_prepare(self, user_id, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('get_users_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_users_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def patch_users_id(self, user_id, user, **kwargs):  # noqa: E501,D401,D403
        """Update a user.

        Updates a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) and returns the user.  #### Required permissions  | Action      | Permission required | |:------------|:-----------------------------------------------| | Update a user | `write-users` or `write-user USER_ID` |  *`USER_ID`* is the ID of the user that you want to update.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/organizations/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_users_id(user_id, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: A user ID. Specifies the [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) to update. (required)
        :param User user: In the request body, provide the user properties to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.patch_users_id_with_http_info(user_id, user, **kwargs)  # noqa: E501
        else:
            (data) = self.patch_users_id_with_http_info(user_id, user, **kwargs)  # noqa: E501
            return data

    def patch_users_id_with_http_info(self, user_id, user, **kwargs):  # noqa: E501,D401,D403
        """Update a user.

        Updates a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) and returns the user.  #### Required permissions  | Action      | Permission required | |:------------|:-----------------------------------------------| | Update a user | `write-users` or `write-user USER_ID` |  *`USER_ID`* is the ID of the user that you want to update.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/organizations/users/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.patch_users_id_with_http_info(user_id, user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: A user ID. Specifies the [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) to update. (required)
        :param User user: In the request body, provide the user properties to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_users_id_prepare(user_id, user, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/users/{userID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def patch_users_id_async(self, user_id, user, **kwargs):  # noqa: E501,D401,D403
        """Update a user.

        Updates a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) and returns the user.  #### Required permissions  | Action      | Permission required | |:------------|:-----------------------------------------------| | Update a user | `write-users` or `write-user USER_ID` |  *`USER_ID`* is the ID of the user that you want to update.  #### Related guides  - [Manage users](https://docs.influxdata.com/influxdb/latest/organizations/users/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: A user ID. Specifies the [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) to update. (required)
        :param User user: In the request body, provide the user properties to update. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._patch_users_id_prepare(user_id, user, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/users/{userID}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _patch_users_id_prepare(self, user_id, user, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'user', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('patch_users_id', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_users_id`")  # noqa: E501
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `patch_users_id`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'user' in local_var_params:
            body_params = local_var_params['user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_users(self, user, **kwargs):  # noqa: E501,D401,D403
        """Create a user.

        Creates a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) that can access InfluxDB. Returns the user.  Use this endpoint to create a user that can sign in to start a user session through one of the following interfaces:    - InfluxDB UI   - `/api/v2/signin` InfluxDB API endpoint   - InfluxDB CLI  This endpoint represents the first two steps in a four-step process to allow a user to authenticate with a username and password, and then access data in an organization:    1. Create a user: send a `POST` request to `POST /api/v2/users`. The `name` property is required.   2. Extract the user ID (`id` property) value from the API response for _step 1_.   3. Create an authorization (and API token) for the user: send a `POST` request to [`POST /api/v2/authorizations`](#operation/PostAuthorizations), passing the user ID (`id`) from _step 2_.   4. Create a password for the user: send a `POST` request to [`POST /api/v2/users/USER_ID/password`](#operation/PostUsersIDPassword), passing the user ID from _step 2_.  #### Required permissions  | Action | Permission required | Restriction | |:-------|:--------------------|:------------| | Create a user | _[Operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_  | |  #### Related guides  - [Create a user](https://docs.influxdata.com/influxdb/latest/users/create-user/) - [Create an API token scoped to a user](https://docs.influxdata.com/influxdb/latest/security/tokens/create-token/#create-a-token-scoped-to-a-user)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param User user: The user to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_users_with_http_info(user, **kwargs)  # noqa: E501
        else:
            (data) = self.post_users_with_http_info(user, **kwargs)  # noqa: E501
            return data

    def post_users_with_http_info(self, user, **kwargs):  # noqa: E501,D401,D403
        """Create a user.

        Creates a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) that can access InfluxDB. Returns the user.  Use this endpoint to create a user that can sign in to start a user session through one of the following interfaces:    - InfluxDB UI   - `/api/v2/signin` InfluxDB API endpoint   - InfluxDB CLI  This endpoint represents the first two steps in a four-step process to allow a user to authenticate with a username and password, and then access data in an organization:    1. Create a user: send a `POST` request to `POST /api/v2/users`. The `name` property is required.   2. Extract the user ID (`id` property) value from the API response for _step 1_.   3. Create an authorization (and API token) for the user: send a `POST` request to [`POST /api/v2/authorizations`](#operation/PostAuthorizations), passing the user ID (`id`) from _step 2_.   4. Create a password for the user: send a `POST` request to [`POST /api/v2/users/USER_ID/password`](#operation/PostUsersIDPassword), passing the user ID from _step 2_.  #### Required permissions  | Action | Permission required | Restriction | |:-------|:--------------------|:------------| | Create a user | _[Operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_  | |  #### Related guides  - [Create a user](https://docs.influxdata.com/influxdb/latest/users/create-user/) - [Create an API token scoped to a user](https://docs.influxdata.com/influxdb/latest/security/tokens/create-token/#create-a-token-scoped-to-a-user)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users_with_http_info(user, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param User user: The user to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_users_prepare(user, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_users_async(self, user, **kwargs):  # noqa: E501,D401,D403
        """Create a user.

        Creates a [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user) that can access InfluxDB. Returns the user.  Use this endpoint to create a user that can sign in to start a user session through one of the following interfaces:    - InfluxDB UI   - `/api/v2/signin` InfluxDB API endpoint   - InfluxDB CLI  This endpoint represents the first two steps in a four-step process to allow a user to authenticate with a username and password, and then access data in an organization:    1. Create a user: send a `POST` request to `POST /api/v2/users`. The `name` property is required.   2. Extract the user ID (`id` property) value from the API response for _step 1_.   3. Create an authorization (and API token) for the user: send a `POST` request to [`POST /api/v2/authorizations`](#operation/PostAuthorizations), passing the user ID (`id`) from _step 2_.   4. Create a password for the user: send a `POST` request to [`POST /api/v2/users/USER_ID/password`](#operation/PostUsersIDPassword), passing the user ID from _step 2_.  #### Required permissions  | Action | Permission required | Restriction | |:-------|:--------------------|:------------| | Create a user | _[Operator token](https://docs.influxdata.com/influxdb/latest/security/tokens/#operator-token)_  | |  #### Related guides  - [Create a user](https://docs.influxdata.com/influxdb/latest/users/create-user/) - [Create an API token scoped to a user](https://docs.influxdata.com/influxdb/latest/security/tokens/create-token/#create-a-token-scoped-to-a-user)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param User user: The user to create. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: UserResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_users_prepare(user, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/users', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type='UserResponse',  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_users_prepare(self, user, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_users', all_params, local_var_params)
        # verify the required parameter 'user' is set
        if ('user' not in local_var_params or
                local_var_params['user'] is None):
            raise ValueError("Missing the required parameter `user` when calling `post_users`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'user' in local_var_params:
            body_params = local_var_params['user']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def post_users_id_password(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        Updates a user password.  #### InfluxDB Cloud  - Doesn't allow you to manage user passwords through the API.   Use the InfluxDB Cloud user interface (UI) to update a password.  #### Related guides  - [InfluxDB Cloud - Change your password](https://docs.influxdata.com/influxdb/cloud/account-management/change-password/) - [InfluxDB OSS - Change your password](https://docs.influxdata.com/influxdb/latest/users/change-password/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users_id_password(user_id, password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to set the password for. (required)
        :param PasswordResetBody password_reset_body: The new password to set for the user. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.post_users_id_password_with_http_info(user_id, password_reset_body, **kwargs)  # noqa: E501
        else:
            (data) = self.post_users_id_password_with_http_info(user_id, password_reset_body, **kwargs)  # noqa: E501
            return data

    def post_users_id_password_with_http_info(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        Updates a user password.  #### InfluxDB Cloud  - Doesn't allow you to manage user passwords through the API.   Use the InfluxDB Cloud user interface (UI) to update a password.  #### Related guides  - [InfluxDB Cloud - Change your password](https://docs.influxdata.com/influxdb/cloud/account-management/change-password/) - [InfluxDB OSS - Change your password](https://docs.influxdata.com/influxdb/latest/users/change-password/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.post_users_id_password_with_http_info(user_id, password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to set the password for. (required)
        :param PasswordResetBody password_reset_body: The new password to set for the user. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_users_id_password_prepare(user_id, password_reset_body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/users/{userID}/password', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def post_users_id_password_async(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        Updates a user password.  #### InfluxDB Cloud  - Doesn't allow you to manage user passwords through the API.   Use the InfluxDB Cloud user interface (UI) to update a password.  #### Related guides  - [InfluxDB Cloud - Change your password](https://docs.influxdata.com/influxdb/cloud/account-management/change-password/) - [InfluxDB OSS - Change your password](https://docs.influxdata.com/influxdb/latest/users/change-password/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the user to set the password for. (required)
        :param PasswordResetBody password_reset_body: The new password to set for the user. (required)
        :param str zap_trace_span: OpenTracing span context
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._post_users_id_password_prepare(user_id, password_reset_body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/users/{userID}/password', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=[],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _post_users_id_password_prepare(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'password_reset_body', 'zap_trace_span']  # noqa: E501
        self._check_operation_params('post_users_id_password', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `post_users_id_password`")  # noqa: E501
        # verify the required parameter 'password_reset_body' is set
        if ('password_reset_body' not in local_var_params or
                local_var_params['password_reset_body'] is None):
            raise ValueError("Missing the required parameter `password_reset_body` when calling `post_users_id_password`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501

        body_params = None
        if 'password_reset_body' in local_var_params:
            body_params = local_var_params['password_reset_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def put_me_password(self, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        Updates the password for the signed-in [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).  This endpoint represents the third step in the following three-step process to let a user with a user session update their password:   1. Pass the user's [Basic authentication credentials](#section/Authentication/BasicAuthentication) to the `POST /api/v2/signin`      endpoint to create a user session and generate a session cookie.   2. From the response in the first step, extract the session cookie (`Set-Cookie`) header.   3. Pass the following in a request to the `PUT /api/v2/me/password` endpoint:      - The `Set-Cookie` header from the second step      - The `Authorization Basic` header with the user's _Basic authentication_ credentials      - `{"password": "NEW_PASSWORD"}` in the request body  #### InfluxDB Cloud  - Doesn't let you manage user passwords through the API.   Use the InfluxDB Cloud user interface (UI) to update your password.  #### Related endpoints  - [Signin](#tag/Signin) - [Signout](#tag/Signout) - [Users](#tag/Users)  #### Related guides  - [InfluxDB Cloud - Change your password](https://docs.influxdata.com/influxdb/cloud/account-management/change-password/) - [InfluxDB OSS - Change your password](https://docs.influxdata.com/influxdb/latest/users/change-password/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_me_password(password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PasswordResetBody password_reset_body: The new password. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_me_password_with_http_info(password_reset_body, **kwargs)  # noqa: E501
        else:
            (data) = self.put_me_password_with_http_info(password_reset_body, **kwargs)  # noqa: E501
            return data

    def put_me_password_with_http_info(self, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        Updates the password for the signed-in [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).  This endpoint represents the third step in the following three-step process to let a user with a user session update their password:   1. Pass the user's [Basic authentication credentials](#section/Authentication/BasicAuthentication) to the `POST /api/v2/signin`      endpoint to create a user session and generate a session cookie.   2. From the response in the first step, extract the session cookie (`Set-Cookie`) header.   3. Pass the following in a request to the `PUT /api/v2/me/password` endpoint:      - The `Set-Cookie` header from the second step      - The `Authorization Basic` header with the user's _Basic authentication_ credentials      - `{"password": "NEW_PASSWORD"}` in the request body  #### InfluxDB Cloud  - Doesn't let you manage user passwords through the API.   Use the InfluxDB Cloud user interface (UI) to update your password.  #### Related endpoints  - [Signin](#tag/Signin) - [Signout](#tag/Signout) - [Users](#tag/Users)  #### Related guides  - [InfluxDB Cloud - Change your password](https://docs.influxdata.com/influxdb/cloud/account-management/change-password/) - [InfluxDB OSS - Change your password](https://docs.influxdata.com/influxdb/latest/users/change-password/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_me_password_with_http_info(password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param PasswordResetBody password_reset_body: The new password. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_me_password_prepare(password_reset_body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/me/password', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=['BasicAuthentication'],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def put_me_password_async(self, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        Updates the password for the signed-in [user](https://docs.influxdata.com/influxdb/latest/reference/glossary/#user).  This endpoint represents the third step in the following three-step process to let a user with a user session update their password:   1. Pass the user's [Basic authentication credentials](#section/Authentication/BasicAuthentication) to the `POST /api/v2/signin`      endpoint to create a user session and generate a session cookie.   2. From the response in the first step, extract the session cookie (`Set-Cookie`) header.   3. Pass the following in a request to the `PUT /api/v2/me/password` endpoint:      - The `Set-Cookie` header from the second step      - The `Authorization Basic` header with the user's _Basic authentication_ credentials      - `{"password": "NEW_PASSWORD"}` in the request body  #### InfluxDB Cloud  - Doesn't let you manage user passwords through the API.   Use the InfluxDB Cloud user interface (UI) to update your password.  #### Related endpoints  - [Signin](#tag/Signin) - [Signout](#tag/Signout) - [Users](#tag/Users)  #### Related guides  - [InfluxDB Cloud - Change your password](https://docs.influxdata.com/influxdb/cloud/account-management/change-password/) - [InfluxDB OSS - Change your password](https://docs.influxdata.com/influxdb/latest/users/change-password/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param PasswordResetBody password_reset_body: The new password. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_me_password_prepare(password_reset_body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/me/password', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=['BasicAuthentication'],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _put_me_password_prepare(self, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['password_reset_body', 'zap_trace_span', 'authorization']  # noqa: E501
        self._check_operation_params('put_me_password', all_params, local_var_params)
        # verify the required parameter 'password_reset_body' is set
        if ('password_reset_body' not in local_var_params or
                local_var_params['password_reset_body'] is None):
            raise ValueError("Missing the required parameter `password_reset_body` when calling `put_me_password`")  # noqa: E501

        path_params = {}

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501
        if 'authorization' in local_var_params:
            header_params['Authorization'] = local_var_params['authorization']  # noqa: E501

        body_params = None
        if 'password_reset_body' in local_var_params:
            body_params = local_var_params['password_reset_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params

    def put_users_id_password(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        Updates a user password.  Use this endpoint to let a user authenticate with [Basic authentication credentials](#section/Authentication/BasicAuthentication) and set a new password.  #### InfluxDB Cloud  - Doesn't allow you to manage user passwords through the API.   Use the InfluxDB Cloud user interface (UI) to update a password.  #### Related guides  - [InfluxDB Cloud - Change your password](https://docs.influxdata.com/influxdb/cloud/account-management/change-password/) - [InfluxDB OSS - Change your password](https://docs.influxdata.com/influxdb/latest/users/change-password/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_users_id_password(user_id, password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to set the password for. (required)
        :param PasswordResetBody password_reset_body: The new password to set for the user. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.put_users_id_password_with_http_info(user_id, password_reset_body, **kwargs)  # noqa: E501
        else:
            (data) = self.put_users_id_password_with_http_info(user_id, password_reset_body, **kwargs)  # noqa: E501
            return data

    def put_users_id_password_with_http_info(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        Updates a user password.  Use this endpoint to let a user authenticate with [Basic authentication credentials](#section/Authentication/BasicAuthentication) and set a new password.  #### InfluxDB Cloud  - Doesn't allow you to manage user passwords through the API.   Use the InfluxDB Cloud user interface (UI) to update a password.  #### Related guides  - [InfluxDB Cloud - Change your password](https://docs.influxdata.com/influxdb/cloud/account-management/change-password/) - [InfluxDB OSS - Change your password](https://docs.influxdata.com/influxdb/latest/users/change-password/)
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.put_users_id_password_with_http_info(user_id, password_reset_body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str user_id: The ID of the user to set the password for. (required)
        :param PasswordResetBody password_reset_body: The new password to set for the user. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_users_id_password_prepare(user_id, password_reset_body, **kwargs)  # noqa: E501

        return self.api_client.call_api(
            '/api/v2/users/{userID}/password', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=['BasicAuthentication'],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    async def put_users_id_password_async(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        """Update a password.

        Updates a user password.  Use this endpoint to let a user authenticate with [Basic authentication credentials](#section/Authentication/BasicAuthentication) and set a new password.  #### InfluxDB Cloud  - Doesn't allow you to manage user passwords through the API.   Use the InfluxDB Cloud user interface (UI) to update a password.  #### Related guides  - [InfluxDB Cloud - Change your password](https://docs.influxdata.com/influxdb/cloud/account-management/change-password/) - [InfluxDB OSS - Change your password](https://docs.influxdata.com/influxdb/latest/users/change-password/)
        This method makes an asynchronous HTTP request.

        :param async_req bool
        :param str user_id: The ID of the user to set the password for. (required)
        :param PasswordResetBody password_reset_body: The new password to set for the user. (required)
        :param str zap_trace_span: OpenTracing span context
        :param str authorization: An auth credential for the Basic scheme
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """  # noqa: E501
        local_var_params, path_params, query_params, header_params, body_params = \
            self._put_users_id_password_prepare(user_id, password_reset_body, **kwargs)  # noqa: E501

        return await self.api_client.call_api(
            '/api/v2/users/{userID}/password', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=[],
            files={},
            response_type=None,  # noqa: E501
            auth_settings=['BasicAuthentication'],
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats={},
            urlopen_kw=kwargs.get('urlopen_kw', None))

    def _put_users_id_password_prepare(self, user_id, password_reset_body, **kwargs):  # noqa: E501,D401,D403
        local_var_params = locals()

        all_params = ['user_id', 'password_reset_body', 'zap_trace_span', 'authorization']  # noqa: E501
        self._check_operation_params('put_users_id_password', all_params, local_var_params)
        # verify the required parameter 'user_id' is set
        if ('user_id' not in local_var_params or
                local_var_params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `put_users_id_password`")  # noqa: E501
        # verify the required parameter 'password_reset_body' is set
        if ('password_reset_body' not in local_var_params or
                local_var_params['password_reset_body'] is None):
            raise ValueError("Missing the required parameter `password_reset_body` when calling `put_users_id_password`")  # noqa: E501

        path_params = {}
        if 'user_id' in local_var_params:
            path_params['userID'] = local_var_params['user_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'zap_trace_span' in local_var_params:
            header_params['Zap-Trace-Span'] = local_var_params['zap_trace_span']  # noqa: E501
        if 'authorization' in local_var_params:
            header_params['Authorization'] = local_var_params['authorization']  # noqa: E501

        body_params = None
        if 'password_reset_body' in local_var_params:
            body_params = local_var_params['password_reset_body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        return local_var_params, path_params, query_params, header_params, body_params
