/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.PaxLoggingManager;
import org.ops4j.pax.logging.PaxLoggingManagerAwareLogger;
import org.ops4j.pax.logging.internal.Activator;
import org.ops4j.pax.logging.jcl.JclLogger;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.osgi.framework.FrameworkUtil;

public class LogFactory {
    private static PaxLoggingManager m_paxLogging;
    private static final LogFactory m_instance;
    public static final String PRIORITY_KEY = "priority";
    public static final String TCCL_KEY = "use_tccl";
    public static final String FACTORY_PROPERTY = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_DEFAULT = "org.apache.commons.logging.LogFactory";
    public static final String FACTORY_PROPERTIES = "commons-logging.properties";
    protected static final String SERVICE_ID = "META-INF/services/org.apache.commons.logging.LogFactory";
    public static final String DIAGNOSTICS_DEST_PROPERTY = "org.apache.commons.logging.diagnostics.dest";
    public static final String HASHTABLE_IMPLEMENTATION_PROPERTY = "org.apache.commons.logging.LogFactory.HashtableImpl";
    protected static Hashtable<ClassLoader, LogFactory> factories;
    @Deprecated
    protected static volatile LogFactory nullClassLoaderFactory;

    public static void setPaxLoggingManager(PaxLoggingManager manager) {
        m_paxLogging = manager;
    }

    protected static ClassLoader getClassLoader(Class<?> clazz) {
        return clazz.getClassLoader();
    }

    public static LogFactory getFactory() throws LogConfigurationException {
        return m_instance;
    }

    public static Log getLog(Class<?> clazz) throws LogConfigurationException {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String name) throws LogConfigurationException {
        return LogFactory.getFactory().getInstance(name);
    }

    protected static void handleThrowable(Throwable t) {
        if (t instanceof ThreadDeath) {
            throw (ThreadDeath)t;
        }
        if (t instanceof VirtualMachineError) {
            throw (VirtualMachineError)t;
        }
    }

    public static String objectId(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + System.identityHashCode(o);
    }

    public static void release(ClassLoader classLoader) {
    }

    public static void releaseAll() {
    }

    protected LogFactory() {
    }

    public Object getAttribute(String name) {
        return null;
    }

    public String[] getAttributeNames() {
        return new String[0];
    }

    public Log getInstance(Class<?> clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Log getInstance(String name) throws LogConfigurationException {
        PaxLogger logger = m_paxLogging == null ? FallbackLogFactory.createFallbackLog(FrameworkUtil.getBundle(Log.class), name) : m_paxLogging.getLogger(name, JclLogger.JCL_FQCN);
        JclLogger jclLogger = new JclLogger(name, logger);
        if (m_paxLogging == null) {
            List<PaxLoggingManagerAwareLogger> list = Activator.m_loggers;
            synchronized (list) {
                Activator.m_loggers.add(jclLogger);
            }
        }
        return jclLogger;
    }

    public void release() {
    }

    public void removeAttribute(String name) {
    }

    public void setAttribute(String name, Object value) {
    }

    static {
        m_instance = new LogFactory();
    }
}

