/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.io;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.common.util.Utils;

public class FreeColXMLWriter
implements Closeable,
XMLStreamWriter {
    private static final Logger logger = Logger.getLogger(FreeColXMLWriter.class.getName());
    private final XMLStreamWriter xmlStreamWriter;
    private final StringWriter stringWriter;
    private final Transformer transformer;
    private final Writer outputWriter;
    private WriteScope writeScope;

    public FreeColXMLWriter(OutputStream outputStream, WriteScope scope, boolean indent) throws IOException {
        this(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8), scope, indent);
    }

    public FreeColXMLWriter(Writer writer) throws IOException {
        this(writer, WriteScope.toSave());
    }

    public FreeColXMLWriter(Writer writer, WriteScope scope) throws IOException {
        this(writer, scope, false);
    }

    public FreeColXMLWriter(Writer writer, WriteScope scope, boolean indent) throws IOException {
        this.outputWriter = writer;
        try {
            this.stringWriter = new StringWriter(1024);
            this.xmlStreamWriter = this.getFactory().createXMLStreamWriter(this.stringWriter);
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        this.transformer = indent ? Utils.makeTransformer(false, true) : null;
        this.writeScope = scope == null ? WriteScope.toSave() : scope;
    }

    private XMLOutputFactory getFactory() {
        return XMLOutputFactory.newInstance();
    }

    public WriteScope getWriteScope() {
        return this.writeScope;
    }

    public void setWriteScope(WriteScope writeScope) {
        this.writeScope = writeScope;
    }

    public WriteScope replaceScope(WriteScope newWriteScope) {
        WriteScope ret = this.writeScope;
        this.writeScope = newWriteScope;
        return ret;
    }

    public StringBuffer flushBuffer() throws XMLStreamException {
        this.xmlStreamWriter.flush();
        StringBuffer sb = this.stringWriter.getBuffer();
        if (sb.length() > 0) {
            String str = sb.toString();
            if (this.transformer == null) {
                try {
                    this.outputWriter.write(str);
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Flush-write fail:" + str, ioe);
                }
            } else {
                StreamSource source = new StreamSource(new StringReader(str));
                StreamResult result = new StreamResult(this.outputWriter);
                try {
                    this.transformer.transform(source, result);
                }
                catch (TransformerException te) {
                    logger.log(Level.WARNING, "Transform fail:" + str, te);
                }
            }
            try {
                this.outputWriter.flush();
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Flush fail", ioe);
            }
        }
        return sb;
    }

    @Override
    public void flush() throws XMLStreamException {
        this.flushBuffer().setLength(0);
    }

    @Override
    public void close() {
        try {
            this.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
        if (this.xmlStreamWriter != null) {
            try {
                this.xmlStreamWriter.close();
            }
            catch (XMLStreamException xse) {
                logger.log(Level.WARNING, "Error closing stream.", xse);
            }
        }
    }

    public void writeAttribute(String attributeName, boolean value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(String attributeName, float value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(String attributeName, int value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(String attributeName, long value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(String attributeName, Enum<?> value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, StringUtils.downCase(value.toString()));
    }

    public void writeAttribute(String attributeName, Object value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(attributeName, String.valueOf(value));
    }

    public void writeAttribute(String attributeName, FreeColObject value) throws XMLStreamException {
        String id;
        if (value != null && (id = value.getId()) != null) {
            this.xmlStreamWriter.writeAttribute(attributeName, value.getId());
        }
    }

    public void writeLocationAttribute(String attributeName, Location value) throws XMLStreamException {
        this.writeAttribute(attributeName, (FreeColObject)((Object)value));
    }

    public <T extends FreeColObject> void writeToListElement(String tag, Collection<T> members) throws XMLStreamException {
        if (members.isEmpty()) {
            return;
        }
        this.writeStartElement(tag);
        this.writeAttribute("xLength", members.size());
        int i = 0;
        for (FreeColObject t : members) {
            this.writeAttribute(FreeColObject.arrayKey(i), t);
            ++i;
        }
        this.writeEndElement();
    }

    public Player getClientPlayer() {
        return this.writeScope.getClient();
    }

    public boolean validForSave() {
        return this.writeScope.validForSave();
    }

    public boolean validFor(Player player) {
        return this.writeScope.validFor(player);
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.xmlStreamWriter.getNamespaceContext();
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return this.xmlStreamWriter.getPrefix(uri);
    }

    @Override
    public Object getProperty(String name) {
        return this.xmlStreamWriter.getProperty(name);
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.xmlStreamWriter.setDefaultNamespace(uri);
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.xmlStreamWriter.setNamespaceContext(context);
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
        this.xmlStreamWriter.setPrefix(prefix, uri);
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.xmlStreamWriter.writeAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        this.xmlStreamWriter.writeCData(data);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(text, start, len);
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.xmlStreamWriter.writeCharacters(text);
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
        this.xmlStreamWriter.writeComment(data);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.xmlStreamWriter.writeDefaultNamespace(namespaceURI);
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
        this.xmlStreamWriter.writeDTD(dtd);
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.xmlStreamWriter.writeEmptyElement(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.xmlStreamWriter.writeEmptyElement(namespaceURI, localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.xmlStreamWriter.writeEmptyElement(prefix, localName, namespaceURI);
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
        this.xmlStreamWriter.writeEndDocument();
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        this.xmlStreamWriter.writeEndElement();
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        this.xmlStreamWriter.writeEntityRef(name);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.xmlStreamWriter.writeNamespace(prefix, namespaceURI);
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
        this.xmlStreamWriter.writeProcessingInstruction(target);
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
        this.xmlStreamWriter.writeProcessingInstruction(target, data);
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument();
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(version);
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
        this.xmlStreamWriter.writeStartDocument(encoding, version);
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(namespaceURI, localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.xmlStreamWriter.writeStartElement(prefix, localName, namespaceURI);
    }

    public static class WriteScope {
        private final WriteScopeType scopeType;
        private final Player player;

        WriteScope(WriteScopeType scopeType, Player player) {
            this.scopeType = scopeType;
            this.player = player;
        }

        public static WriteScope toClient(Player player) {
            return new WriteScope(WriteScopeType.CLIENT, player);
        }

        public static WriteScope toServer() {
            return new WriteScope(WriteScopeType.SERVER, null);
        }

        public static WriteScope toSave() {
            return new WriteScope(WriteScopeType.SAVE, null);
        }

        public boolean isValid() {
            return this.scopeType == WriteScopeType.CLIENT == (this.player != null);
        }

        public boolean validForSave() {
            return this.scopeType == WriteScopeType.SAVE;
        }

        public boolean validFor(Player player) {
            return this.scopeType != WriteScopeType.CLIENT || this.player == player;
        }

        public Player getClient() {
            return this.player;
        }

        public String toString() {
            Object ret = this.scopeType.toString();
            if (this.scopeType == WriteScopeType.CLIENT) {
                ret = (String)ret + ":" + (this.player == null ? "INVALID" : this.player.getId());
            }
            return ret;
        }
    }

    public static enum WriteScopeType {
        CLIENT,
        SERVER,
        SAVE;

    }
}

